/*
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 1998,2006 Oracle.  All rights reserved.
 *
 * $Id: QueryWorkload.cpp,v 1.5 2006/10/30 17:46:17 bostic Exp $
 */

#include <sstream>
#include "QueryWorkload.hpp"

using namespace std;
using namespace DbXml;

int QueryWorkload::setup()
{
	int ret = DbXmlWorkload::setup();
	if(ret != 0) return ret;

	try {
		XmlUpdateContext uc = mgr_->createUpdateContext();

		// Add indexes
		cont_->addIndex("", "b", "node-element-presence", uc);

		// Add documents to the container
		cont_->putDocument("query", "<a x=\"1\"><b x=\"2\">frank</b><b x=\"3\">bob</b></a>",
			uc, DBXML_GEN_NAME);

		// Prepare the query expression
		XmlQueryContext qc = mgr_->createQueryContext(
			XmlQueryContext::LiveValues,
			XmlQueryContext::Lazy);
		qc.setDefaultCollection(cont_->getName());
		expr_ = mgr_->prepare("collection()//b", qc);

		// Warm the cache
		XmlResults res = expr_.execute(qc, DBXML_LAZY_DOCS);
		XmlValue val;
		while(res.next(val)) {}

	} catch (XmlException &xe) {
		cout << "XmlException: " << xe.what() << endl;
		return 1;
	} catch (DbException &de) {
		cout << "DbException: " << de.what() << endl;
		return 1;
	}

	return ret;
}

int QueryWorkload::work(int id, int *iteration, ThreadGlobal *tglob)
{
	XmlResults res = expr_.execute(tglob->txn, ((QueryThreadGlobal*)tglob)->qc, DBXML_LAZY_DOCS);
	XmlValue val;
	while(res.next(val)) {}
	return 0;
}

int QueryWorkload::cleanup()
{
	int ret = DbXmlWorkload::cleanup();
	if(ret != 0) return ret;

	expr_ = 0;

	return ret;
}

ThreadGlobal *QueryWorkload::createThreadGlobal(int id)
{
	QueryThreadGlobal *result = new QueryThreadGlobal();

	result->qc = mgr_->createQueryContext(
		XmlQueryContext::LiveValues,
		XmlQueryContext::Lazy);

	return result;
}

int Query2Workload::setup()
{
	int ret = DbXmlWorkload::setup();
	if(ret != 0) return ret;

	try {
		XmlUpdateContext uc = mgr_->createUpdateContext();

		// Add indexes
		cont_->addIndex("", "id", "node-element-equality-decimal", uc);

		// Add documents to the container
		ostringstream doc;
		doc << "<doc>";
		for(int i = 0; i < 100000; ++i) {
			doc << "<record><id>" << i << "</id></record>";
		}
		doc << "</doc>";

		cont_->putDocument("query", doc.str(), uc, DBXML_GEN_NAME);

		// Prepare the query expression
		XmlQueryContext qc = mgr_->createQueryContext(
			XmlQueryContext::LiveValues,
			XmlQueryContext::Lazy);
		qc.setDefaultCollection(cont_->getName());
		expr_ = mgr_->prepare("collection()//id[.=750]", qc);

		// Warm the cache
		XmlResults res = expr_.execute(qc, DBXML_LAZY_DOCS);
		XmlValue val;
		while(res.next(val)) {}

	} catch (XmlException &xe) {
		cout << "XmlException: " << xe.what() << endl;
		return 1;
	} catch (DbException &de) {
		cout << "DbException: " << de.what() << endl;
		return 1;
	}

	return ret;
}

int Query2Workload::work(int id, int *iteration, ThreadGlobal *tglob)
{
	XmlResults res = expr_.execute(tglob->txn, ((QueryThreadGlobal*)tglob)->qc, DBXML_LAZY_DOCS);
	XmlValue val;
	while(res.next(val)) {}
	return 0;
}

int Query2Workload::cleanup()
{
	int ret = DbXmlWorkload::cleanup();
	if(ret != 0) return ret;

	expr_ = 0;

	return ret;
}

