/*
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 1998,2006 Oracle.  All rights reserved.
 *
 * $Id: PutWorkload.hpp,v 1.3 2006/10/30 17:46:17 bostic Exp $
 */

#ifndef __PUTWORKLOAD_HPP
#define	__PUTWORKLOAD_HPP

#include "DbXmlWorkload.hpp"

class PutThreadGlobal : public ThreadGlobal {
public:
	DbXml::XmlUpdateContext uc;
};

class PutWorkload : public DbXmlWorkload {
public:
	PutWorkload(struct perf_globals *globals, PerfParams &params)
		: DbXmlWorkload(globals, params)
	{}

	virtual int setup();
	virtual int work(int id, int *iteration, ThreadGlobal *tglob);
	virtual int cleanup();

protected:
	virtual ThreadGlobal *createThreadGlobal(int id);

private:
	std::string getContent(int i);
};

#endif
