/*
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 1998,2006 Oracle.  All rights reserved.
 *
 * $Id: PutWorkload.cpp,v 1.3 2006/10/30 17:46:17 bostic Exp $
 */

#include "PutWorkload.hpp"
#include <sys/time.h>

using namespace std;
using namespace DbXml;

int PutWorkload::setup()
{
	int ret = DbXmlWorkload::setup();
	if(ret != 0) return ret;

	try {
	} catch (XmlException &xe) {
		cout << "XmlException: " << xe.what() << endl;
		return 1;
	} catch (DbException &de) {
		cout << "DbException: " << de.what() << endl;
		return 1;
	}

	return ret;
}

int PutWorkload::work(int id, int *iteration, ThreadGlobal *tglob)
{
	timeval tv;
	gettimeofday(&tv, NULL);

	char buf[100];
	sprintf(buf, "%u", *iteration);
	XmlValue domainIdVal(XmlValue::DECIMAL, "0");
	XmlValue objectIdVal(XmlValue::DECIMAL, buf);
	XmlValue versionIdVal(XmlValue::DECIMAL, "0");
	XmlValue nextVersionIdVal(XmlValue::DECIMAL, "1");
	XmlValue startSidVal(XmlValue::DECIMAL, "1");
	XmlValue endSidVal(XmlValue::DECIMAL, "0");
	sprintf (buf, "%u", (unsigned int)time(NULL));
	XmlValue timestampVal(XmlValue::DECIMAL, buf);

	sprintf(buf, "%u-%u.%u", *iteration, (unsigned int)tv.tv_sec, (unsigned int)tv.tv_usec);
	string docName(buf);
	string content = getContent(*iteration);

	XmlDocument doc = mgr_->createDocument();
	doc.setName(docName);
	doc.setContent(content);
	doc.setMetaData("", "DOMAIN_ID", domainIdVal);
	doc.setMetaData("", "OBJECT_ID", objectIdVal);
	doc.setMetaData("", "VERSION_ID", versionIdVal);
	doc.setMetaData("", "NEXT_VERSION_ID", nextVersionIdVal);
	doc.setMetaData("", "START_SID", startSidVal);
	doc.setMetaData("", "END_SID", endSidVal);
	doc.setMetaData("", "TIMESTAMP", timestampVal);

	cont_->putDocument(tglob->txn, doc, ((PutThreadGlobal*)tglob)->uc);

	return 0;
}

string PutWorkload::getContent(int i) {
  char buf[1024];
  sprintf(buf, 
          "<__><![CDATA[doc_%u]]>\n"
          "  <admin-name><![CDATA[tjiang]]></admin-name>\n"
          "  <timestamp><![CDATA[%u]]></timestamp>\n"
          "  <admin-login-domain><![CDATA[global]]></admin-login-domain>\n"
          "  <command-name><![CDATA[query]]></command-name>\n"
          "  <outcome><![CDATA[success]]></outcome>\n"
          "  <misc><![CDATA[whatever]]></misc>\n"
          "  <modified-objects>\n"
          "    <__>\n"
          "      <domain-id><![CDATA[1]]></domain-id>\n"
          "      <category><![CDATA[deviceobj]]></category>\n"
          "      <objectId><![CDATA[0]]></objectId>\n"
          "    </__>\n"
          "    <__>\n"
          "      <domain-id><![CDATA[1]]></domain-id>\n"
          "      <category><![CDATA[deviceobj]]></category>\n"
          "      <objectId><![CDATA[1]]></objectId>\n"
          "    </__>\n"
          "  </modified-objects>\n"
          "</__>\n", i, (unsigned int)time(NULL)
  );
  
  return string(buf);
}

int PutWorkload::cleanup()
{
	int ret = DbXmlWorkload::cleanup();
	if(ret != 0) return ret;

	return ret;
}

ThreadGlobal *PutWorkload::createThreadGlobal(int id)
{
	PutThreadGlobal *result = new PutThreadGlobal();

	result->uc = mgr_->createUpdateContext();

	return result;
}
