/*
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 1998,2006 Oracle.  All rights reserved.
 *
 * $Id: PutAndQueriesWorkload.hpp,v 1.4 2006/10/30 17:46:17 bostic Exp $
 */

#ifndef __PUTANDQUERIESWORKLOAD_HPP
#define	__PUTANDQUERIESWORKLOAD_HPP

#include "DbXmlWorkload.hpp"

class PutAndQueriesThreadGlobal : public ThreadGlobal {
public:
	DbXml::XmlQueryContext qc;
	DbXml::XmlUpdateContext uc;
};

class PutAndQueriesWorkload : public DbXmlWorkload {
public:
	PutAndQueriesWorkload(struct perf_globals *globals, PerfParams &params)
		: DbXmlWorkload(globals, params)
	{}

	virtual int setup();
	virtual int work(int id, int *iteration, ThreadGlobal *tglob);
	virtual int cleanup();

protected:
	virtual ThreadGlobal *createThreadGlobal(int id);

private:
	DbXml::XmlQueryExpression expr_;
};

#endif
