/*
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 1998,2006 Oracle.  All rights reserved.
 *
 * $Id: PutAndQueriesWorkload.cpp,v 1.4 2006/10/30 17:46:17 bostic Exp $
 */

#include "PutAndQueriesWorkload.hpp"

using namespace std;
using namespace DbXml;

int PutAndQueriesWorkload::setup()
{
	int ret = DbXmlWorkload::setup();
	if(ret != 0) return ret;

	try {
		XmlUpdateContext uc = mgr_->createUpdateContext();

		// Add indexes
		cont_->addIndex("node-element-presence", "", "b", uc);

		// Add documents
		for(int i = 0; i < 100; ++i) {
			cont_->putDocument("putandqueries",
				"<a x=\"1\"><b x=\"2\">frank</b><b x=\"3\">bob</b></a>",
				uc, DBXML_GEN_NAME);
		}

		// Prepare the query expression
		XmlQueryContext qc = mgr_->createQueryContext();
		qc.setDefaultCollection(cont_->getName());
		expr_ = mgr_->prepare("collection()//b", qc);

	} catch (XmlException &xe) {
		cout << "XmlException: " << xe.what() << endl;
		return 1;
	} catch (DbException &de) {
		cout << "DbException: " << de.what() << endl;
		return 1;
	}

	return ret;
}

int PutAndQueriesWorkload::work(int id, int *iteration, ThreadGlobal *tglob)
{
	if(id == 0) {
		// Put behaviour
		cont_->putDocument(tglob->txn, "putandqueries",
			"<a x=\"1\"><b x=\"2\">frank</b><b x=\"3\">bob</b></a>",
			((PutAndQueriesThreadGlobal*)tglob)->uc, DBXML_GEN_NAME);
	} else {
		// Query behaviour
		XmlResults res = expr_.execute(tglob->txn, ((PutAndQueriesThreadGlobal*)tglob)->qc);
		XmlValue val;
		while(res.next(val)) {}
	}

	return 0;
}

int PutAndQueriesWorkload::cleanup()
{
	int ret = DbXmlWorkload::cleanup();
	if(ret != 0) return ret;

	expr_ = 0;

	return ret;
}

ThreadGlobal *PutAndQueriesWorkload::createThreadGlobal(int id)
{
	PutAndQueriesThreadGlobal *result = new PutAndQueriesThreadGlobal();

	result->qc = mgr_->createQueryContext(
		XmlQueryContext::LiveValues,
		XmlQueryContext::Lazy);
	result->uc = mgr_->createUpdateContext();

	return result;
}
