/*
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 1998,2006 Oracle.  All rights reserved.
 *
 * $Id: DbXmlWorkload.hpp,v 1.4 2006/10/30 17:46:17 bostic Exp $
 */

#ifndef __DBXMLWORKLOAD_HPP
#define	__DBXMLWORKLOAD_HPP

#include "perf_workload.hpp"
#include <dbxml/DbXml.hpp>
#include <vector>

class PerfParams {
public:
	PerfParams()
		: opsPerTransaction(1),
		  envDir("."),
		  containerName("perf.dbxml"),
		  cacheSize(64*1024*1024),
		  nodeStorage(true),
		  nodeIndexes(false),
		  verbose(false)
	{}

	int opsPerTransaction; // 0 means no txn
	std::string envDir;
	std::string containerName;
	int cacheSize;
	bool nodeStorage;
	bool nodeIndexes;
	bool verbose;
};

class ThreadGlobal {
public:
	virtual ~ThreadGlobal() {}

	DbXml::XmlTransaction txn;
};

class DbXmlWorkload : public PerfWorkload {
public:
	DbXmlWorkload(struct perf_globals *globals, PerfParams &params)
		: PerfWorkload(globals),
		  params_(params),
		  dbenv_(0), mgr_(0), cont_(0)
	{}
	virtual ~DbXmlWorkload();
	virtual int setup();
	virtual int work(int id, int *iteration);
	virtual int work(int id, int *iteration, ThreadGlobal *tglob) = 0;
	virtual int cleanup();

protected:
	virtual ThreadGlobal *createThreadGlobal(int id);

protected:
	PerfParams &params_;

	DbEnv *dbenv_;
	DbXml::XmlManager *mgr_;
	DbXml::XmlContainer *cont_;

private:
	std::vector<ThreadGlobal*> threadGlobals_;	
};

#endif
