#! /usr/bin/perl -w

use diagnostics;
use strict;

my $here = `dirname $0`;
chomp $here;

my $eval_prog = shift @ARGV;
my $scripts_dir = "$here";

my $summary_xml_script = "$scripts_dir/create_summary_xml.xqy";
my $summary_script = "$scripts_dir/create_summary.xqy";
my $report_script = "$scripts_dir/create_report.xqy";

my $pwd = `pwd`;
chomp $pwd;

`mkdir output 2>/dev/null`;

open(FILE, ">output/summary.xml") or die "Can't open summary.xml for writing";
print FILE "<summary>\n";
foreach my $arg (@ARGV) {
    my $out = $arg;
    $out =~ s/\.xml/\.summary/;
    if(!(-e $out)) {
        print "Creating summary data for $arg\n";
        `$eval_prog $summary_xml_script -i file:$pwd/$arg -o $out`;
    }

    open(SUMMARY, "<$out");
    while(<SUMMARY>) {
        print FILE "$_";
    }
    close(SUMMARY);

    my $out2 = `basename $arg`;
    chomp $out2;
    $out2 =~ s/\.xml$/\.html/;
    if(!(-e "output/$out2")) {
        print "Creating benchmark report for $arg\n";
        `$eval_prog $report_script -i file:$pwd/$arg -o output/$out2`;
    }
}
print FILE "</summary>\n";
close(FILE);

print "Creating index\n";

`$eval_prog $summary_script -i file:$pwd/output/summary.xml -o output/index.html`;
