(:
 : XQuery script to create a benchmark report
 :)

declare boundary-space preserve;

declare function local:size($entries)
{
  for $e in $entries
  let $size := string($e/size)
  return
    if($size eq "miniscule") then (20 * 1024)
    else if($size eq "tiny") then (1024 * 1024)
    else if($size eq "small") then (10 * 1024 * 1024)
    else error(concat("Unknown size: ", $size))
};

declare function local:round($num)
{
  round($num * 1000) div 1000
};

declare function local:per-second($entries)
{
  local:round(1 div (sum($entries/time) div sum($entries/count)))
};

declare function local:entry($entries, $totals)
{
  let $count := count($entries)
  return

  <entry name="{ $entries[1]/@name }">
    <storage>{ $entries[1]/storage }</storage>
    <indexes>{ local:round(avg($entries/indexes)) }</indexes>
    <size>{ local:round(sum(local:size($entries)) div $count) }</size>
    <per_second>
      <average>{ local:per-second($entries) }</average>
      <minimum>{ min($totals) }</minimum>
      <maximum>{ max($totals) }</maximum>
    </per_second>
  </entry>
};

let $docElem := /statistics
let $entries := $docElem/entry
let $totalTime := sum($entries/time)
return <statistics>{ $docElem/@timestamp, $docElem/@version }
  { $docElem/note }
  {
  for $s in distinct-values($entries/storage)
  for $n in distinct-values($entries/@name)
  let $indexedEntries := $entries[@name=$n][storage = $s][not(indexes = 0)]
  let $notIndexedEntries := $entries[@name=$n][storage = $s][indexes = 0]
  return

  if($n eq "query") then (
    (: Deal with Query Stats :)
    if(exists($indexedEntries)) then local:entry($indexedEntries,
      for $d in distinct-values($indexedEntries/data_type)
      let $dEntries := $indexedEntries[data_type = $d]
      for $q in distinct-values($dEntries/query_index)
      let $qEntries := $dEntries[query_index = $q]
      return local:per-second($qEntries)
    ) else ()
  )
  else (
    (: Deal with Load Stats :)
    if(exists($notIndexedEntries)) then local:entry($notIndexedEntries, 
      for $d in distinct-values($notIndexedEntries/data_type)
      let $dEntries := $notIndexedEntries[data_type = $d]
      return local:per-second($dEntries)
    ) else (),
    if(exists($indexedEntries)) then local:entry($indexedEntries,
      for $d in distinct-values($indexedEntries/data_type)
      let $dEntries := $indexedEntries[data_type = $d]
      return local:per-second($dEntries)
    ) else ()
  )
  }
</statistics>