#! /usr/bin/perl -w

use diagnostics;
use strict;

my $here = `dirname $0`;
chomp $here;

my $eval_prog = shift @ARGV;
my $scripts_dir = "$here";

my $comparison_script = "$scripts_dir/create_comparison.xqy";

my $pwd = `pwd`;
chomp $pwd;

open(FILE, ">compare.xml") or die "Can't open compare.xml for writing";
print FILE "<compare>\n";
foreach(@ARGV) {
    open(FILE2, "<$_");
    while(<FILE2>) {
        print FILE "$_";
    }
    close(FILE2);
}
print FILE "</compare>\n";
close(FILE);

print "Creating comparison\n";

`$eval_prog $comparison_script -i file:$pwd/compare.xml -o comparison.html`;
