/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.29
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_DIRECTORS

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC)
#   if (__SUNPRO_CC <= 0x560)
#     define SWIGTEMPLATEDISAMBIGUATOR template
#   else
#     define SWIGTEMPLATEDISAMBIGUATOR 
#   endif
# else
#   define SWIGTEMPLATEDISAMBIGUATOR 
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER)
# define _CRT_SECURE_NO_DEPRECATE
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTELC__)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1 
#define  SWIG_IOError        	   -2 
#define  SWIG_RuntimeError   	   -3 
#define  SWIG_IndexError     	   -4 
#define  SWIG_TypeError      	   -5 
#define  SWIG_DivisionByZero 	   -6 
#define  SWIG_OverflowError  	   -7 
#define  SWIG_SyntaxError    	   -8 
#define  SWIG_ValueError     	   -9 
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12 
#define  SWIG_NullReferenceError   -13



/* -----------------------------------------------------------------------------
 * See the LICENSE file for information on copyright, usage and redistribution
 * of SWIG, and the README file for authors - http://www.swig.org/release.html.
 *
 * director.swg
 *
 * This file contains support for director classes that proxy
 * method calls from C++ to Java extensions.
 * ----------------------------------------------------------------------------- */

#ifdef __cplusplus

#if defined(DEBUG_DIRECTOR_OWNED)
#include <iostream>
#endif

namespace Swig {
  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = weak_global;
        if (jobj)
          jthis_ = ((weak_global_ || !mem_own) ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj));
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java
       proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else { /* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* director base class */
  class Director {
  private:
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Acquire Java VM environment from Java VM */
    JNIEnv *swig_acquire_jenv() const {
      JNIEnv *env = NULL;
      swig_jvm_->AttachCurrentThread((void **) &env, NULL);
      return env;
    }

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnv *jenv = swig_acquire_jenv();
      jobject jobj = swig_self_.peek();
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      swig_self_.release(swig_acquire_jenv());
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };
}

#endif /* __cplusplus */


namespace Swig {
  static jclass jclass_dbxml_javaJNI = NULL;
  static jmethodID director_methids[8];
}

SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}


#include <stdexcept>


#include "db_cxx.h"
#include "dbxml/DbXml.hpp"
#include <errno.h>
#include <fstream>

using namespace DbXml;

class XmlIndexDeclaration {
public:
	XmlIndexDeclaration() {}
	XmlIndexDeclaration(const std::string &uri, const std::string &name, const std::string &index) : uri(uri), name(name), index(index) {}
#ifndef SWIGJAVA	
	const std::string &get_uri() const { return uri; }
	const std::string &get_name() const { return name; }
	const std::string &get_index() const { return index; }
#endif
	std::string uri, name, index;
};

class XmlMetaData {
public:
	XmlMetaData() {}
	XmlMetaData(const std::string &uri, const std::string &name, const
		    XmlValue &value) : uri(uri), name(name), value(value) {}
	
	const std::string &get_uri() const { return uri; }
	const std::string &get_name() const { return name; }
	const XmlValue &get_value() const { return value; }
	std::string uri, name;
	XmlValue value;
};



#include <string>


class JavaException {};

class XmlInputStream_ReadBytes_InOutByteArray {
public:
	XmlInputStream_ReadBytes_InOutByteArray(JNIEnv *jenv, jbyteArray &jtoFill, char *toFill, unsigned int &result)
		: jenv_(jenv), jtoFill_(jtoFill), toFill_(toFill), result_(result)
	{
	}
	~XmlInputStream_ReadBytes_InOutByteArray() {
		if(jenv_->ExceptionOccurred()) {
			// This is caught in the exception handling routines
			throw JavaException();
		} else {
			jenv_->GetByteArrayRegion(jtoFill_, (jsize)0, (jsize)result_, (jbyte*)toFill_);
		}
	}
private:
	JNIEnv *jenv_;
	jbyteArray &jtoFill_;
	char *toFill_;
	unsigned int &result_;
};


/* don't use SWIG's array handling - save code space */
#define SWIG_NOINCLUDE 1

#if DB_VERSION_MAJOR > 4 || (DB_VERSION_MAJOR == 4 && DB_VERSION_MINOR >= 4)
#define DB_EXTRA_EXC 1
#endif

// XML classes
static jclass xml_indexdecl_class;
static jclass xmlex_class;
static jclass np_class;
// DB classes
static jclass dbenv_class;
static jclass dbtxn_class;
// DB exception classes
static jclass dbex_class, deadex_class, lockex_class, memex_class;
static jclass runrecex_class, rephandledeadex_class;
#ifdef DB_EXTRA_EXC
// DB 4.4 TBD...
static jclass repdupmasterex_class;
static jclass repholdelectionex_class, repunavailex_class;
static jclass versionex_class;
#endif


// fields
jfieldID dbenv_private_fid;
jfieldID dbtxn_private_fid;

// method IDs
static jmethodID xml_indexdecl_construct;
static jmethodID xmlex_construct;
// DB exception method ids
static jmethodID dbex_construct, deadex_construct, lockex_construct;
static jmethodID memex_construct;
static jmethodID rephandledeadex_construct;
static jmethodID runrecex_construct;
#ifdef DB_EXTRA_EXC
// DB 4.4. TBD
static jmethodID repdupmasterex_construct, memex_update_method;
static jmethodID repholdelectionex_construct, repunavailex_construct;
static jmethodID versionex_construct;
#endif

#define DB_PKG "com/sleepycat/db/"
#define DB_PKG_INT "com/sleepycat/db/internal/"
#define XML_PKG "com/sleepycat/dbxml/"

/* Forward declarations */
static jthrowable __dbj_get_except(JNIEnv *jenv,
   int err, const char *msg, jobject obj, jobject jdbenv);

static jthrowable make_db_except(JNIEnv *jenv,
   int err, const char *msg, jobject obj, jobject jdbenv);

// all classes
const struct {
    jclass *cl;
    const char *name;
} all_classes[] = {
    // XML
    { &xml_indexdecl_class, XML_PKG "XmlIndexDeclaration" },
    { &xmlex_class, XML_PKG "XmlException" },
    // DB
    { &dbenv_class, DB_PKG_INT "DbEnv" },
    { &dbtxn_class, DB_PKG_INT "DbTxn" },
    { &dbex_class, DB_PKG "DatabaseException" },
    { &deadex_class, DB_PKG "DeadlockException" },
    { &lockex_class, DB_PKG "LockNotGrantedException" },
    { &memex_class, DB_PKG "MemoryException" },
    { &rephandledeadex_class, DB_PKG "ReplicationHandleDeadException" },
    { &runrecex_class, DB_PKG "RunRecoveryException" },
#ifdef DB_EXTRA_EXC
    { &repdupmasterex_class, DB_PKG "ReplicationDuplicateMasterException" },
    { &repholdelectionex_class, DB_PKG "ReplicationHoldElectionException" },
    { &repunavailex_class, DB_PKG "ReplicationSiteUnavailableException" },
    { &versionex_class, DB_PKG "VersionMismatchException" },
#endif
    // Misc
    { &np_class, "java/lang/NullPointerException" }
};

const struct {
	jmethodID *mid;
	jclass *cl;
	const char *name;
	const char *sig;
} all_methods[] = {
    // XML methods
    { &xml_indexdecl_construct, &xml_indexdecl_class, "<init>",
      "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"  },
    { &xmlex_construct, &xmlex_class, "<init>",
      "(ILjava/lang/String;L" DB_PKG "DatabaseException;III)V"  },
    // DB methods
    { &dbex_construct, &dbex_class, "<init>",
      "(Ljava/lang/String;I)V" },
    { &deadex_construct, &deadex_class, "<init>",
      "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
    { &lockex_construct, &lockex_class, "<init>",
      "(Ljava/lang/String;IIL" DB_PKG "DatabaseEntry;L" DB_PKG "internal/DbLock;IL" DB_PKG "internal/DbEnv;)V" },
    { &memex_construct, &memex_class, "<init>",
      "(Ljava/lang/String;L" DB_PKG "DatabaseEntry;IL" DB_PKG "internal/DbEnv;)V" },
    { &rephandledeadex_construct, &rephandledeadex_class, "<init>",
      "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
    { &runrecex_construct, &runrecex_class, "<init>",
      "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" }
#ifdef DB_EXTRA_EXC
    ,{ &memex_update_method, &memex_class, "updateDatabaseEntry",
      "(L" DB_PKG "DatabaseEntry;)V" },
    { &repdupmasterex_construct, &repdupmasterex_class, "<init>",
      "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
    { &repholdelectionex_construct, &repholdelectionex_class, "<init>",
      "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
    { &repunavailex_construct, &repunavailex_class, "<init>",
      "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
    { &versionex_construct, &versionex_class, "<init>",
      "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" }
#endif
};

#define NELEM(x) (sizeof (x) / sizeof (x[0]))

static bool checkDbVersion()
{
	int major, minor, patch, dmajor, dminor, dpatch;
	(void) db_version(&major, &minor, &patch);
	(void) DbXml::dbxml_db_version(&dmajor, &dminor, &dpatch);
	// match major and minor numbers
	// TBD: warn if patch level is different
	if (major != dmajor || minor != dminor)
		return false;
	return true;
}

extern "C"
JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_initialize
  (JNIEnv *jenv, jclass clazz)
{
    (void)clazz; /* unused */
    jclass cl;
    unsigned int i, j;

    if (checkDbVersion() == false) {
	    fprintf(stderr,
		    "Mismatched Berkeley DB libraries");
	    return;
    }
    // This initialization code comes from DB's java_util.i file
    for (i = 0; i < NELEM(all_classes); i++) {
	cl = (jenv)->FindClass(all_classes[i].name);
	if (cl == NULL) {
	    fprintf(stderr,
		    "Failed to load class %s - check CLASSPATH\n",
		    all_classes[i].name);
	    return;
	}
	/*
	 * Wrap classes in GlobalRefs so we keep the reference between
	 * calls.
	 */
	*all_classes[i].cl = (jclass)(jenv)->NewGlobalRef(cl);

	if (*all_classes[i].cl == NULL) {
	    fprintf(stderr,
		    "Failed to create a global reference for %s\n",
		    all_classes[i].name);
	    return;
	}
    }

    // get some field ids
#if DB_VERSION_MAJOR < 4 || (DB_VERSION_MAJOR == 4 && DB_VERSION_MINOR <= 1)
    dbenv_private_fid = jenv->GetFieldID(dbenv_class, "private_dbobj_", "J");
    dbtxn_private_fid = jenv->GetFieldID(dbtxn_class, "private_dbobj_", "J");
#else
    dbenv_private_fid = jenv->GetFieldID(dbenv_class, "swigCPtr", "J");
    dbtxn_private_fid = jenv->GetFieldID(dbtxn_class, "swigCPtr", "J");
#endif
    /* Get method IDs */
    for (i = 0; i < NELEM(all_methods); i++) {
	*all_methods[i].mid = (jenv)->
	    GetMethodID(*all_methods[i].cl, all_methods[i].name,
			all_methods[i].sig);

	if (*all_methods[i].mid == NULL) {
	    for (j = 0; j < NELEM(all_classes); j++)
		if (all_methods[i].cl == all_classes[j].cl)
		    break;
	    fprintf(stderr,
		    "Failed to look up method %s.%s with sig %s\n",
		    all_classes[j].name, all_methods[i].name,
		    all_methods[i].sig);
	    return;
	}
    }
}

/* Union to convert longs to pointers (see {get,set}_private_dbobj). */
typedef union {
	jlong java_long;
	void *ptr;
} long_to_ptr;

static DbEnv *get_DbEnv(JNIEnv *jenv, jobject jdbenv)
{
	if (jdbenv == NULL)
		return NULL;
	else {
#if DB_VERSION_MAJOR < 4 || (DB_VERSION_MAJOR == 4 && DB_VERSION_MINOR <= 1)
		long_to_ptr lp;
		lp.java_long = jenv->GetLongField(jdbenv, dbenv_private_fid);
		return DbEnv::wrap_DB_ENV((DB_ENV *)lp.ptr);
#else
		jlong swigCPtr = jenv->GetLongField(jdbenv, dbenv_private_fid);
		return DbEnv::wrap_DB_ENV(*(DB_ENV **)&swigCPtr);
#endif
	}
}

static DbTxn *get_DbTxn(JNIEnv *jenv, jobject jtxn)
{
	if (jtxn == NULL)
		return NULL;
	else {
#if DB_VERSION_MAJOR < 4 || (DB_VERSION_MAJOR == 4 && DB_VERSION_MINOR <= 1)
		long_to_ptr lp;
		lp.java_long = jenv->GetLongField(jtxn, dbtxn_private_fid);
		return DbTxn::wrap_DB_TXN((DB_TXN *)lp.ptr);
#else
		jlong swigCPtr = jenv->GetLongField(jtxn, dbtxn_private_fid);
		return DbTxn::wrap_DB_TXN(*(DB_TXN **)&swigCPtr);
#endif
	}
}

struct DBT_INFO {
	Dbt dbt;
	jbyte *orig_data;
};



static jthrowable make_db_except(JNIEnv *jenv,
				 int err, const char *msg, jobject obj,
				 jobject jdbenv) {

    jthrowable dt = __dbj_get_except(jenv, err, msg, obj, jdbenv);
    return (jthrowable)jenv->
	NewObject(xmlex_class, xmlex_construct,
		  XmlException::DATABASE_ERROR,
		  jenv->NewStringUTF(msg), dt, 0, 0, 0, 0);
}

static jthrowable __dbj_get_except(
   JNIEnv *jenv,
   int err, const char *msg, jobject obj, jobject jdbenv) {
    jobject jmsg;

    if (msg == NULL)
	msg = db_strerror(err);

    jmsg = jenv->NewStringUTF(msg);

    switch (err) {
#if 0
    // don't map these (yet?)
    case EINVAL:
	return (jthrowable)jenv->
	    NewObject(
		      illegalargex_class, illegalargex_construct, jmsg);

    case ENOENT:
	return (jthrowable)jenv->
	    NewObject(filenotfoundex_class, filenotfoundex_construct, jmsg);

    case ENOMEM:
	return (jthrowable)jenv->
	    NewObject(outofmemerr_class, outofmemerr_construct, jmsg);
#endif
    case DB_BUFFER_SMALL:
	return (jthrowable)jenv->
	    NewObject(memex_class, memex_construct, jmsg, obj, err, jdbenv);

    case DB_REP_HANDLE_DEAD:
	return (jthrowable)jenv->
	    NewObject(rephandledeadex_class, rephandledeadex_construct,
		      jmsg, err, jdbenv);
    case DB_RUNRECOVERY:
	return (jthrowable)jenv->
	    NewObject(runrecex_class, runrecex_construct, jmsg, err, jdbenv);

    case DB_LOCK_DEADLOCK:
	return (jthrowable)jenv->
	    NewObject(deadex_class, deadex_construct, jmsg, err, jdbenv);

    case DB_LOCK_NOTGRANTED:
	return (jthrowable)jenv->
	    NewObject(lockex_class,lockex_construct,
		      jmsg, 0, 0, NULL, NULL, 0, jdbenv);

#ifdef DB_EXTRA_EXC
    // These are from DB 4.4, TBD...
    case DB_REP_DUPMASTER:
	return (jthrowable)jenv->
	    NewObject(repdupmasterex_class, repdupmasterex_construct,
		      jmsg, err, jdbenv);

    case DB_REP_HOLDELECTION:
	return (jthrowable)jenv->
	    NewObject(repholdelectionex_class, repholdelectionex_construct,
		      jmsg, err, jdbenv);

    case DB_REP_UNAVAIL:
	return (jthrowable)jenv->
	    NewObject(repunavailex_class, repunavailex_construct,
		      jmsg, err, jdbenv);

    case DB_VERSION_MISMATCH:
	return (jthrowable)jenv->
	    NewObject(versionex_class,
		      versionex_construct, jmsg, 0, 0, NULL, NULL, 0, jdbenv);
#endif //  DB 4.4
    default:
    return (jthrowable)jenv->
	NewObject(dbex_class,
		  dbex_construct, jmsg, err, jdbenv);
    }
}


SWIGINTERN XmlInputStream *XmlManager_createStdInInputStream(XmlManager const *self){
		return self->createStdInInputStream();
	}
SWIGINTERN XmlInputStream *XmlManager_createLocalFileInputStream(XmlManager const *self,std::string const &filename){
		return self->createLocalFileInputStream(filename);
	}
SWIGINTERN XmlInputStream *XmlManager_createMemBufInputStream__SWIG_0(XmlManager const *self,char const *bytes,unsigned int const count,char const *id,bool const adopt=false){
		return self->createMemBufInputStream(bytes,
						     count,
						     id, adopt);
	}
SWIGINTERN XmlInputStream *XmlManager_createMemBufInputStream__SWIG_2(XmlManager const *self,char const *bytes,unsigned int const count,bool const copyBuffer){
		return self->createMemBufInputStream(bytes,
						     count,
						     copyBuffer);
	}
SWIGINTERN XmlInputStream *XmlManager_createURLInputStream__SWIG_0(XmlManager const *self,std::string const &baseId,std::string const &systemId,std::string const &publicId){
		return self->createURLInputStream(baseId, systemId, publicId);
	}
SWIGINTERN XmlInputStream *XmlManager_createURLInputStream__SWIG_1(XmlManager const *self,std::string const &baseId,std::string const &systemId){
		return self->createURLInputStream(baseId, systemId);
	}
SWIGINTERN XmlContainer *XmlManager_createContainer__SWIG_0(XmlManager *self,std::string const &name,u_int32_t flags,enum XmlContainer::ContainerType type=XmlContainer::NodeContainer,int mode=0){
		return new XmlContainer(
			self->createContainer(name, flags, type, mode));
	 }
SWIGINTERN XmlContainer *XmlManager_createContainer__SWIG_3(XmlManager *self,XmlTransaction &txn,std::string const &name,u_int32_t flags,enum XmlContainer::ContainerType type=XmlContainer::NodeContainer,int mode=0){
		return new XmlContainer(self->createContainer(txn, name, flags,
							      type, mode));
        }
SWIGINTERN XmlContainer *XmlManager_openContainer__SWIG_0(XmlManager *self,std::string const &name,u_int32_t flags){
		return new XmlContainer(self->openContainer(name, flags));
        }
SWIGINTERN XmlContainer *XmlManager_openContainer__SWIG_1(XmlManager *self,XmlTransaction &txn,std::string const &name,u_int32_t flags){
		return new XmlContainer(self->openContainer(txn, name, flags));
        }
SWIGINTERN XmlContainer *XmlManager_openContainer__SWIG_2(XmlManager *self,std::string const &name,u_int32_t flags,enum XmlContainer::ContainerType type,int mode=0){
	    return new XmlContainer(self->openContainer(name,
						    flags, type, mode));
        }
SWIGINTERN XmlContainer *XmlManager_openContainer__SWIG_4(XmlManager *self,XmlTransaction &txn,std::string const &name,u_int32_t flags,enum XmlContainer::ContainerType type,int mode=0){
	    return new XmlContainer(self->openContainer(txn, name,
						    flags, type, mode));
        }
SWIGINTERN void XmlManager_dumpContainer(XmlManager *self,std::string const &name,char const *filename){
		std::ofstream out(filename);
		self->dumpContainer(name, &out);
		out.close();
	}
SWIGINTERN void XmlManager_loadContainer(XmlManager *self,std::string const &name,char const *filename,XmlUpdateContext &uc){
		std::ifstream in(filename);
		unsigned long lineno = 0;
		self->loadContainer(name, &in, &lineno, uc);
		in.close();
	}
SWIGINTERN void XmlManager_verifyContainer__SWIG_0(XmlManager *self,std::string const &name,char const *filename,u_int32_t flags=0){
		std::ofstream out;
		if (flags & DB_SALVAGE)
			out.open(filename);
		self->verifyContainer(name, &out, flags);
		if (flags & DB_SALVAGE)
			out.close();
	}
SWIGINTERN XmlDocument *XmlManager_createDocument(XmlManager *self){
		return new XmlDocument(self->createDocument());
	}
SWIGINTERN XmlQueryContext *XmlManager_createQueryContext__SWIG_0(XmlManager *self,enum XmlQueryContext::ReturnType rt,enum XmlQueryContext::EvaluationType et){
		return new XmlQueryContext(self->createQueryContext(rt, et));
	}
SWIGINTERN XmlQueryContext *XmlManager_createQueryContext__SWIG_1(XmlManager *self){
		return new XmlQueryContext(self->createQueryContext(
			XmlQueryContext::LiveValues, XmlQueryContext::Eager));
	}
SWIGINTERN XmlQueryContext *XmlManager_createQueryContext__SWIG_2(XmlManager *self,enum XmlQueryContext::ReturnType rt){
		return new XmlQueryContext(self->createQueryContext(rt, XmlQueryContext::Eager));
	}
SWIGINTERN XmlUpdateContext *XmlManager_createUpdateContext(XmlManager *self){
		return new XmlUpdateContext(self->createUpdateContext());
	}
SWIGINTERN XmlQueryExpression *XmlManager_prepare__SWIG_0(XmlManager *self,std::string const &query,XmlQueryContext &context){
		return new XmlQueryExpression(self->prepare(query, context));
	}
SWIGINTERN XmlQueryExpression *XmlManager_prepare__SWIG_1(XmlManager *self,XmlTransaction &txn,std::string const &query,XmlQueryContext &context){
		return new XmlQueryExpression(self->prepare(
						      txn,query, context));
	}
SWIGINTERN XmlResults *XmlManager_query__SWIG_0(XmlManager *self,std::string const &query,XmlQueryContext &context,u_int32_t flags){
		return new XmlResults(self->query(query, context, flags));
	}
SWIGINTERN XmlResults *XmlManager_query__SWIG_1(XmlManager *self,XmlTransaction &txn,std::string const &query,XmlQueryContext &context,u_int32_t flags){
		return new XmlResults(self->query(txn, query, context, flags));
	}
SWIGINTERN XmlResults *XmlManager_query__SWIG_2(XmlManager *self,std::string const &query,XmlQueryContext &context){
		return new XmlResults(self->query(query, context, 0));
	}
SWIGINTERN XmlResults *XmlManager_query__SWIG_3(XmlManager *self,XmlTransaction &txn,std::string const &query,XmlQueryContext &context){
		return new XmlResults(self->query(txn, query, context, 0));
	}
SWIGINTERN XmlResults *XmlManager_createResults(XmlManager *self){
		return new XmlResults(self->createResults());
	}
SWIGINTERN XmlModify *XmlManager_createModify(XmlManager *self){
		return new XmlModify(self->createModify());
	}
SWIGINTERN XmlTransaction *XmlManager_createTransaction(XmlManager *self,DbTxn *toAdopt){
		return new XmlTransaction(self->createTransaction(toAdopt));
        }
SWIGINTERN XmlIndexLookup *XmlManager_createIndexLookup__SWIG_0(XmlManager *self,XmlContainer &cont,std::string const &uri,std::string const &name,std::string const &index,XmlValue const &value=XmlValue(),enum XmlIndexLookup::Operation op=XmlIndexLookup::NONE){
		return new XmlIndexLookup(self->createIndexLookup(cont, uri,name,
								  index, value,
								  op));
	}
SWIGINTERN void XmlManager_setLogLevel(enum LogLevel level,bool enabled){
		DbXml::setLogLevel(level, enabled);
	}
SWIGINTERN void XmlManager_setLogCategory(enum LogCategory category,bool enabled){
		DbXml::setLogCategory(category, enabled);
	}
SWIGINTERN int XmlManager_get_version_major(){
		int major;
		(void)dbxml_version(&major, NULL, NULL);
		return major;
	}
SWIGINTERN int XmlManager_get_version_minor(){
		int minor;
		(void)dbxml_version(NULL, &minor, NULL);
		return minor;
	}
SWIGINTERN int XmlManager_get_version_patch(){
		int patch;
		(void)dbxml_version(NULL, NULL, &patch);
		return patch;
	}
SWIGINTERN char const *XmlManager_get_version_string(){
		return dbxml_version(NULL, NULL, NULL);
	}
SWIGINTERN XmlResults *XmlIndexLookup_execute__SWIG_0(XmlIndexLookup const *self,XmlQueryContext &context,u_int32_t flags=0){
		return new XmlResults(self->execute(context, flags));
	}
SWIGINTERN XmlResults *XmlIndexLookup_execute__SWIG_2(XmlIndexLookup const *self,XmlTransaction &txn,XmlQueryContext &context,u_int32_t flags=0){
		return new XmlResults(self->execute(txn, context, flags));
	}
SWIGINTERN XmlIndexSpecification *XmlContainer_getIndexSpecification__SWIG_0(XmlContainer const *self){
		return new XmlIndexSpecification(self->getIndexSpecification());
	}
SWIGINTERN XmlIndexSpecification *XmlContainer_getIndexSpecification__SWIG_1(XmlContainer const *self,XmlTransaction &txn){
		 return new XmlIndexSpecification(
			 self->getIndexSpecification(txn));
        }
SWIGINTERN XmlIndexSpecification *XmlContainer_getIndexSpecification__SWIG_2(XmlContainer const *self,XmlTransaction &txn,u_int32_t flags){
		 return new XmlIndexSpecification(
			 self->getIndexSpecification(txn, flags));
	 }
SWIGINTERN XmlDocument *XmlContainer_getDocument__SWIG_0(XmlContainer *self,std::string const &name,u_int32_t flags){
		return new XmlDocument(self->getDocument(name, flags));
	}
SWIGINTERN XmlDocument *XmlContainer_getDocument__SWIG_1(XmlContainer *self,XmlTransaction &txn,std::string const &name,u_int32_t flags){
		return new XmlDocument(self->getDocument(txn, name, flags));
	}
SWIGINTERN XmlValue *XmlContainer_getNode__SWIG_0(XmlContainer *self,std::string const &name,u_int32_t flags){
		return new XmlValue(self->getNode(name, flags));
	}
SWIGINTERN XmlValue *XmlContainer_getNode__SWIG_1(XmlContainer *self,XmlTransaction &txn,std::string const &name,u_int32_t flags){
		return new XmlValue(self->getNode(txn, name, flags));
	}
SWIGINTERN XmlResults *XmlContainer_getAllDocuments__SWIG_0(XmlContainer *self,u_int32_t flags){
		   return new XmlResults(self->getAllDocuments(flags));
	}
SWIGINTERN XmlResults *XmlContainer_getAllDocuments__SWIG_1(XmlContainer *self,XmlTransaction &txn,u_int32_t flags){
		   return new XmlResults(self->getAllDocuments(txn, flags));
	}
SWIGINTERN XmlResults *XmlContainer_lookupIndex__SWIG_0(XmlContainer *self,XmlQueryContext &context,std::string const &uri,std::string const &name,std::string const &index,XmlValue const &value=XmlValue(),u_int32_t flags=0){
		return new XmlResults(
			self->lookupIndex(context, uri, name, index,
					  value, flags));
	}
SWIGINTERN XmlResults *XmlContainer_lookupIndex__SWIG_3(XmlContainer *self,XmlQueryContext &context,std::string const &uri,std::string const &name,std::string const &parent_uri,std::string const &parent_name,std::string const &index,XmlValue const &value=XmlValue(),u_int32_t flags=0){
		return new XmlResults(self->lookupIndex(context, uri, name,
							parent_uri, parent_name,
							index, value, flags));
	}
SWIGINTERN XmlResults *XmlContainer_lookupIndex__SWIG_6(XmlContainer *self,XmlTransaction &txn,XmlQueryContext &context,std::string const &uri,std::string const &name,std::string const &index,XmlValue const &value=XmlValue(),u_int32_t flags=0){
                return new XmlResults(self->lookupIndex(txn, context, uri, name,
							index, value, flags));
        }
SWIGINTERN XmlResults *XmlContainer_lookupIndex__SWIG_9(XmlContainer *self,XmlTransaction &txn,XmlQueryContext &context,std::string const &uri,std::string const &name,std::string const &parent_uri,std::string const &parent_name,std::string const &index,XmlValue const &value=XmlValue(),u_int32_t flags=0){
	        return new XmlResults(self->lookupIndex(txn, context, uri, name,
							parent_uri, parent_name,
							index, value, flags));
	}
SWIGINTERN XmlStatistics *XmlContainer_lookupStatistics__SWIG_0(XmlContainer *self,std::string const &uri,std::string const &name,std::string const &index,XmlValue const &value=XmlValue()){
		return new XmlStatistics(self->lookupStatistics(uri, name, index,
								value));
	}
SWIGINTERN XmlStatistics *XmlContainer_lookupStatistics__SWIG_2(XmlContainer *self,std::string const &uri,std::string const &name,std::string const &parent_uri,std::string const &parent_name,std::string const &index,XmlValue const &value=XmlValue()){
		return new XmlStatistics(self->lookupStatistics(uri, name,
								parent_uri,
								parent_name,
								index, value));
	}
SWIGINTERN XmlStatistics *XmlContainer_lookupStatistics__SWIG_4(XmlContainer *self,XmlTransaction &txn,std::string const &uri,std::string const &name,std::string const &index,XmlValue const &value=XmlValue()){
		return new XmlStatistics(self->lookupStatistics(txn, uri, name,
								index, value));
	}
SWIGINTERN XmlStatistics *XmlContainer_lookupStatistics__SWIG_6(XmlContainer *self,XmlTransaction &txn,std::string const &uri,std::string const &name,std::string const &parent_uri,std::string const &parent_name,std::string const &index,XmlValue const &value=XmlValue()){
		return new XmlStatistics(self->lookupStatistics(txn, uri, name,
								parent_uri,
								parent_name,
								index, value));
	}
SWIGINTERN std::string XmlDocument_getContentAsString(XmlDocument const *self){
		std::string s;
		return self->getContent(s);
	}
SWIGINTERN XmlData const *XmlDocument_getContent(XmlDocument const *self){
		return new XmlData(self->getContent());
	}
SWIGINTERN XmlData const *XmlDocument_getMetaData__SWIG_1(XmlDocument *self,std::string const &uri,std::string const &name){
		XmlData data;
		bool ret = self->getMetaData(uri, name, data);
		if (ret)
			return new XmlData(data);
		return 0;
	}
SWIGINTERN XmlMetaDataIterator *XmlDocument_getMetaDataIterator(XmlDocument const *self){
		return new XmlMetaDataIterator(self->getMetaDataIterator());
	}
SWIGINTERN bool XmlDocument_equals(XmlDocument const *self,XmlDocument const &other){
		return (*self == other);
	}
SWIGINTERN XmlMetaData *XmlMetaDataIterator_next(XmlMetaDataIterator *self){
		XmlMetaData *idecl = new XmlMetaData;
		if (self->next(idecl->uri, idecl->name, idecl->value))
			return idecl;
		else
			delete idecl;
		return NULL;
	}
SWIGINTERN XmlValue *XmlQueryContext_getVariableValue(XmlQueryContext const *self,std::string const &name){
		XmlValue *value = new XmlValue;
		try {
			if (self->getVariableValue(name, *value))
				return value;
			else {
				delete value;
				return NULL;
			}
		}
		catch(...) {
			delete value;
			throw;
		}
	}
SWIGINTERN XmlResults *XmlQueryContext_getVariableValues(XmlQueryContext const *self,std::string const &name){
		XmlResults *res = new XmlResults();
		try {
			if (self->getVariableValue(name, *res))
				return res;
			else {
				delete res;
				return NULL;
			}
		}
		catch(...) {
			delete res;
			throw;
		}
	}
SWIGINTERN XmlValue *XmlResults_next__SWIG_0(XmlResults *self){
		XmlValue *value = new XmlValue;
		if (self->next(*value))
			return value;
		else {
			delete value;
			return NULL;
		}
	}
SWIGINTERN XmlValue *XmlResults_previous__SWIG_0(XmlResults *self){
		XmlValue *value = new XmlValue;
		if (self->previous(*value))
			return value;
		else {
			delete value;
			return NULL;
		}
	}
SWIGINTERN XmlValue *XmlResults_peek__SWIG_0(XmlResults *self){
		XmlValue *value = new XmlValue;
		if (self->peek(*value))
			return value;
		else {
			delete value;
			return NULL;
		}
	}
SWIGINTERN XmlData *XmlValue_asBinary(XmlValue const *self){
		XmlData data = self->asBinary();
		return new XmlData(data);
	}
SWIGINTERN XmlValue *XmlValue_getParentNode(XmlValue const *self){
		return new XmlValue(self->getParentNode());
	}
SWIGINTERN XmlValue *XmlValue_getFirstChild(XmlValue const *self){
		return new XmlValue(self->getFirstChild());
	}
SWIGINTERN XmlValue *XmlValue_getLastChild(XmlValue const *self){
		return new XmlValue(self->getLastChild());
	}
SWIGINTERN XmlValue *XmlValue_getPreviousSibling(XmlValue const *self){
		return new XmlValue(self->getPreviousSibling());
	}
SWIGINTERN XmlValue *XmlValue_getNextSibling(XmlValue const *self){
		return new XmlValue(self->getNextSibling());
	}
SWIGINTERN XmlResults *XmlValue_getAttributes(XmlValue const *self){
		return new XmlResults(self->getAttributes());
	}
SWIGINTERN XmlValue *XmlValue_getOwnerElement(XmlValue const *self){
		return new XmlValue(self->getOwnerElement());
	}
SWIGINTERN void XmlValue_setValue(XmlValue &to,XmlValue const &from){
		to = from;
	}
SWIGINTERN XmlIndexDeclaration *XmlIndexSpecification_find(XmlIndexSpecification *self,std::string const &uri,std::string const &name){
		XmlIndexDeclaration *idecl =
			new XmlIndexDeclaration(uri, name, "");
		if (self->find(idecl->uri, idecl->name, idecl->index))
			return idecl;
		else {
			delete idecl;
			return NULL;
		}
	}
SWIGINTERN XmlIndexDeclaration *XmlIndexSpecification_next(XmlIndexSpecification *self){
		XmlIndexDeclaration *idecl = new XmlIndexDeclaration;
		if (self->next(idecl->uri, idecl->name, idecl->index))
			return idecl;
		else {
			delete idecl;
			return NULL;
		}
	}
SWIGINTERN XmlResults *XmlQueryExpression_execute__SWIG_0(XmlQueryExpression const *self,XmlQueryContext &context,u_int32_t flags=0){
		return new XmlResults(self->execute(context, flags));
	}
SWIGINTERN XmlResults *XmlQueryExpression_execute__SWIG_2(XmlQueryExpression const *self,XmlValue const &contextItem,XmlQueryContext &context,u_int32_t flags=0){
		return new XmlResults(
			self->execute(contextItem, context, flags));
	}
SWIGINTERN XmlResults *XmlQueryExpression_execute__SWIG_4(XmlQueryExpression const *self,XmlTransaction &txn,XmlQueryContext &context,u_int32_t flags=0){
		return new XmlResults(self->execute(txn, context, flags));
	}
SWIGINTERN XmlResults *XmlQueryExpression_execute__SWIG_6(XmlQueryExpression const *self,XmlTransaction &txn,XmlValue const &contextItem,XmlQueryContext &context,u_int32_t flags=0){
		return new XmlResults(self->execute(txn, contextItem,
						    context, flags));
	}
SWIGINTERN void XmlInputStream_freeMemory(XmlInputStream *self){
		delete self;
	}
SWIGINTERN unsigned char const *XmlEventReader_getValue(XmlEventReader const *self){
		int len;
		return self->getValue(len);
	}


/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "dbxml_java_wrap.h"

SwigDirector_XmlInputStream::SwigDirector_XmlInputStream(JNIEnv *jenv): XmlInputStream(), Swig::Director(jenv) {
}

unsigned int SwigDirector_XmlInputStream::curPos() const {
  unsigned int result ;
  jlong jresult  = 0 ;
  JNIEnv * jenv = (JNIEnv *) NULL ;
  jobject  jobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    jenv = swig_acquire_jenv();
    SWIG_JavaThrowException(jenv, SWIG_JavaDirectorPureVirtual,
      "Attempted to invoke pure virtual method XmlInputStream::curPos.");
    return result;
  }
  jenv = swig_acquire_jenv();
  jobj = swig_get_self(jenv);
  if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[0], jobj);
    if (jenv->ExceptionOccurred()) return result;
    result = (unsigned int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (jobj) jenv->DeleteLocalRef(jobj);
  return result;
}

unsigned int SwigDirector_XmlInputStream::readBytes(char *toFill, unsigned int const maxToRead) {
  unsigned int result ;
  jlong jresult  = 0 ;
  JNIEnv * jenv = (JNIEnv *) NULL ;
  jobject  jobj = (jobject) NULL ;
  jbyteArray jtoFill = 0 ;
  jlong jmaxToRead  ;
  
  if (!swig_override[1]) {
    jenv = swig_acquire_jenv();
    SWIG_JavaThrowException(jenv, SWIG_JavaDirectorPureVirtual,
      "Attempted to invoke pure virtual method XmlInputStream::readBytes.");
    return result;
  }
  jenv = swig_acquire_jenv();
  jobj = swig_get_self(jenv);
  if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
    jtoFill = jenv->NewByteArray((jsize)maxToRead);
    XmlInputStream_ReadBytes_InOutByteArray arg_guard1(jenv, jtoFill, toFill, result);
    
    jmaxToRead = (jlong) maxToRead;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[1], jobj, jtoFill, jmaxToRead);
    if (jenv->ExceptionOccurred()) return result;
    result = (unsigned int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (jobj) jenv->DeleteLocalRef(jobj);
  return result;
}

SwigDirector_XmlInputStream::~SwigDirector_XmlInputStream() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_XmlInputStream::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "curPos", "()J", NULL 
    },
    {
      "readBytes", "([BJ)J", NULL 
    }
  };
  
  static jclass baseclass  = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/sleepycat/dbxml/XmlInputStream");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_XmlResolver::SwigDirector_XmlResolver(JNIEnv *jenv): XmlResolver(), Swig::Director(jenv) {
}

bool SwigDirector_XmlResolver::resolveDocument(XmlTransaction *txn, XmlManager &mgr, std::string const &uri, XmlValue &reslt) const {
  bool result = false;
  jboolean jresult  = 0 ;
  JNIEnv * jenv = (JNIEnv *) NULL ;
  jobject  jobj = (jobject) NULL ;
  jlong jtxn = 0 ;
  jlong jmgr = 0 ;
  jstring juri = 0 ;
  jlong jreslt = 0 ;
  
  if (!swig_override[0]) {
    return XmlResolver::resolveDocument(txn,mgr,uri,reslt);
  }
  jenv = swig_acquire_jenv();
  jobj = swig_get_self(jenv);
  if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
    *((XmlTransaction **)&jtxn) = (XmlTransaction *) txn; 
    *(XmlManager **)&jmgr = (XmlManager *) &mgr; 
    juri = jenv->NewStringUTF((&uri)->c_str()); 
    *(XmlValue **)&jreslt = (XmlValue *) &reslt; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[2], jobj, jtxn, jmgr, juri, jreslt);
    if (jenv->ExceptionOccurred()) return result;
    result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (jobj) jenv->DeleteLocalRef(jobj);
  return result;
}

bool SwigDirector_XmlResolver::resolveModuleLocation(XmlTransaction *txn, XmlManager &mgr, std::string const &nameSpace, XmlResults &reslt) const {
  bool result = false;
  jboolean jresult  = 0 ;
  JNIEnv * jenv = (JNIEnv *) NULL ;
  jobject  jobj = (jobject) NULL ;
  jlong jtxn = 0 ;
  jlong jmgr = 0 ;
  jstring jnameSpace = 0 ;
  jlong jreslt = 0 ;
  
  if (!swig_override[1]) {
    return XmlResolver::resolveModuleLocation(txn,mgr,nameSpace,reslt);
  }
  jenv = swig_acquire_jenv();
  jobj = swig_get_self(jenv);
  if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
    *((XmlTransaction **)&jtxn) = (XmlTransaction *) txn; 
    *(XmlManager **)&jmgr = (XmlManager *) &mgr; 
    jnameSpace = jenv->NewStringUTF((&nameSpace)->c_str()); 
    *(XmlResults **)&jreslt = (XmlResults *) &reslt; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[3], jobj, jtxn, jmgr, jnameSpace, jreslt);
    if (jenv->ExceptionOccurred()) return result;
    result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (jobj) jenv->DeleteLocalRef(jobj);
  return result;
}

SwigDirector_XmlResolver::~SwigDirector_XmlResolver() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_XmlResolver::resolveCollection(XmlTransaction *txn, XmlManager &mgr, std::string const &uri, XmlResults &reslt) const {
  bool result = false;
  jboolean jresult  = 0 ;
  JNIEnv * jenv = (JNIEnv *) NULL ;
  jobject  jobj = (jobject) NULL ;
  jlong jtxn = 0 ;
  jlong jmgr = 0 ;
  jstring juri = 0 ;
  jlong jreslt = 0 ;
  
  if (!swig_override[2]) {
    return XmlResolver::resolveCollection(txn,mgr,uri,reslt);
  }
  jenv = swig_acquire_jenv();
  jobj = swig_get_self(jenv);
  if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
    *((XmlTransaction **)&jtxn) = (XmlTransaction *) txn; 
    *(XmlManager **)&jmgr = (XmlManager *) &mgr; 
    juri = jenv->NewStringUTF((&uri)->c_str()); 
    *(XmlResults **)&jreslt = (XmlResults *) &reslt; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[4], jobj, jtxn, jmgr, juri, jreslt);
    if (jenv->ExceptionOccurred()) return result;
    result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (jobj) jenv->DeleteLocalRef(jobj);
  return result;
}

XmlInputStream *SwigDirector_XmlResolver::resolveSchema(XmlTransaction *txn, XmlManager &mgr, std::string const &schemaLocation, std::string const &nameSpace) const {
  XmlInputStream *result = 0 ;
  jlong jresult  = 0 ;
  JNIEnv * jenv = (JNIEnv *) NULL ;
  jobject  jobj = (jobject) NULL ;
  jlong jtxn = 0 ;
  jlong jmgr = 0 ;
  jstring jschemaLocation = 0 ;
  jstring jnameSpace = 0 ;
  
  if (!swig_override[3]) {
    return XmlResolver::resolveSchema(txn,mgr,schemaLocation,nameSpace);
  }
  jenv = swig_acquire_jenv();
  jobj = swig_get_self(jenv);
  if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
    *((XmlTransaction **)&jtxn) = (XmlTransaction *) txn; 
    *(XmlManager **)&jmgr = (XmlManager *) &mgr; 
    jschemaLocation = jenv->NewStringUTF((&schemaLocation)->c_str()); 
    jnameSpace = jenv->NewStringUTF((&nameSpace)->c_str()); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[5], jobj, jtxn, jmgr, jschemaLocation, jnameSpace);
    if (jenv->ExceptionOccurred()) return result;
    result = *(XmlInputStream **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (jobj) jenv->DeleteLocalRef(jobj);
  return result;
}

XmlInputStream *SwigDirector_XmlResolver::resolveEntity(XmlTransaction *txn, XmlManager &mgr, std::string const &systemId, std::string const &publicId) const {
  XmlInputStream *result = 0 ;
  jlong jresult  = 0 ;
  JNIEnv * jenv = (JNIEnv *) NULL ;
  jobject  jobj = (jobject) NULL ;
  jlong jtxn = 0 ;
  jlong jmgr = 0 ;
  jstring jsystemId = 0 ;
  jstring jpublicId = 0 ;
  
  if (!swig_override[4]) {
    return XmlResolver::resolveEntity(txn,mgr,systemId,publicId);
  }
  jenv = swig_acquire_jenv();
  jobj = swig_get_self(jenv);
  if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
    *((XmlTransaction **)&jtxn) = (XmlTransaction *) txn; 
    *(XmlManager **)&jmgr = (XmlManager *) &mgr; 
    jsystemId = jenv->NewStringUTF((&systemId)->c_str()); 
    jpublicId = jenv->NewStringUTF((&publicId)->c_str()); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[6], jobj, jtxn, jmgr, jsystemId, jpublicId);
    if (jenv->ExceptionOccurred()) return result;
    result = *(XmlInputStream **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (jobj) jenv->DeleteLocalRef(jobj);
  return result;
}

XmlInputStream *SwigDirector_XmlResolver::resolveModule(XmlTransaction *txn, XmlManager &mgr, std::string const &moduleLocation, std::string const &nameSpace) const {
  XmlInputStream *result = 0 ;
  jlong jresult  = 0 ;
  JNIEnv * jenv = (JNIEnv *) NULL ;
  jobject  jobj = (jobject) NULL ;
  jlong jtxn = 0 ;
  jlong jmgr = 0 ;
  jstring jmoduleLocation = 0 ;
  jstring jnameSpace = 0 ;
  
  if (!swig_override[5]) {
    return XmlResolver::resolveModule(txn,mgr,moduleLocation,nameSpace);
  }
  jenv = swig_acquire_jenv();
  jobj = swig_get_self(jenv);
  if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
    *((XmlTransaction **)&jtxn) = (XmlTransaction *) txn; 
    *(XmlManager **)&jmgr = (XmlManager *) &mgr; 
    jmoduleLocation = jenv->NewStringUTF((&moduleLocation)->c_str()); 
    jnameSpace = jenv->NewStringUTF((&nameSpace)->c_str()); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[7], jobj, jtxn, jmgr, jmoduleLocation, jnameSpace);
    if (jenv->ExceptionOccurred()) return result;
    result = *(XmlInputStream **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (jobj) jenv->DeleteLocalRef(jobj);
  return result;
}

void SwigDirector_XmlResolver::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "resolveDocument", "(Lcom/sleepycat/dbxml/XmlTransaction;Lcom/sleepycat/dbxml/XmlManager;Ljava/lang/String;Lcom/sleepycat/dbxml/XmlValue;)Z", NULL 
    },
    {
      "resolveModuleLocation", "(Lcom/sleepycat/dbxml/XmlTransaction;Lcom/sleepycat/dbxml/XmlManager;Ljava/lang/String;Lcom/sleepycat/dbxml/XmlResults;)Z", NULL 
    },
    {
      "resolveCollection", "(Lcom/sleepycat/dbxml/XmlTransaction;Lcom/sleepycat/dbxml/XmlManager;Ljava/lang/String;Lcom/sleepycat/dbxml/XmlResults;)Z", NULL 
    },
    {
      "resolveSchema", "(Lcom/sleepycat/dbxml/XmlTransaction;Lcom/sleepycat/dbxml/XmlManager;Ljava/lang/String;Ljava/lang/String;)Lcom/sleepycat/dbxml/XmlInputStream;", NULL 
    },
    {
      "resolveEntity", "(Lcom/sleepycat/dbxml/XmlTransaction;Lcom/sleepycat/dbxml/XmlManager;Ljava/lang/String;Ljava/lang/String;)Lcom/sleepycat/dbxml/XmlInputStream;", NULL 
    },
    {
      "resolveModule", "(Lcom/sleepycat/dbxml/XmlTransaction;Lcom/sleepycat/dbxml/XmlManager;Ljava/lang/String;Ljava/lang/String;)Lcom/sleepycat/dbxml/XmlInputStream;", NULL 
    }
  };
  
  static jclass baseclass  = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/sleepycat/dbxml/XmlResolver");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 6; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlManager(JNIEnv *jenv, jclass jcls, jobject jarg1, jint jarg2) {
  jlong jresult = 0 ;
  DbEnv *arg1 = (DbEnv *) 0 ;
  u_int32_t arg2 ;
  XmlManager *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    arg1 = get_DbEnv(jenv, jarg1);
  }
  arg2 = (u_int32_t)jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = (XmlManager *)new XmlManager(arg1,arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlManager **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlManager(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
      
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1setDefaultPageSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  u_int32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setDefaultPageSize(arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1getDefaultPageSize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->getDefaultPageSize();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1setDefaultSequenceIncrement(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  u_int32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setDefaultSequenceIncrement(arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1getDefaultSequenceIncrement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->getDefaultSequenceIncrement();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1setDefaultContainerType(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  enum XmlContainer::ContainerType arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = (enum XmlContainer::ContainerType)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setDefaultContainerType(arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1getDefaultContainerType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  enum XmlContainer::ContainerType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlContainer::ContainerType)(arg1)->getDefaultContainerType();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1getHome(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        std::string const &_result_ref = ((XmlManager const *)arg1)->getHome();
        result = (std::string *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1registerResolver(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlResolver *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlResolver **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlResolver const & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->registerResolver((XmlResolver const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1getImplicitTimezone(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (int)((XmlManager const *)arg1)->getImplicitTimezone();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1setImplicitTimezone(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setImplicitTimezone(arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1existsContainer(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (int)(arg1)->existsContainer((std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1removeContainer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->removeContainer((std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1removeContainer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->removeContainer(*arg2,(std::string const &)*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1renameContainer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->renameContainer((std::string const &)*arg2,(std::string const &)*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1renameContainer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->renameContainer(*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1upgradeContainer(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->upgradeContainer((std::string const &)*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1compactContainer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jint jarg4) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  u_int32_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->compactContainer((std::string const &)*arg2,*arg3,arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1compactContainer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->compactContainer((std::string const &)*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1compactContainer_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4, jint jarg5) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  u_int32_t arg5 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  arg5 = (u_int32_t)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->compactContainer(*arg2,(std::string const &)*arg3,*arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1compactContainer_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->compactContainer(*arg2,(std::string const &)*arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1truncateContainer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jint jarg4) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  u_int32_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->truncateContainer((std::string const &)*arg2,*arg3,arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1truncateContainer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->truncateContainer((std::string const &)*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1truncateContainer_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4, jint jarg5) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  u_int32_t arg5 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  arg5 = (u_int32_t)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->truncateContainer(*arg2,(std::string const &)*arg3,*arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1truncateContainer_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->truncateContainer(*arg2,(std::string const &)*arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1reindexContainer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jint jarg4) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  u_int32_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->reindexContainer((std::string const &)*arg2,*arg3,arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1reindexContainer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->reindexContainer((std::string const &)*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1reindexContainer_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4, jint jarg5) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  u_int32_t arg5 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  arg5 = (u_int32_t)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->reindexContainer(*arg2,(std::string const &)*arg3,*arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1reindexContainer_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->reindexContainer(*arg2,(std::string const &)*arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createStdInInputStream(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)XmlManager_createStdInInputStream((XmlManager const *)arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createLocalFileInputStream(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)XmlManager_createLocalFileInputStream((XmlManager const *)arg1,(std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createMemBufInputStream_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jstring jarg4, jboolean jarg5) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned int arg3 ;
  char *arg4 = (char *) 0 ;
  bool arg5 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (unsigned int)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  
  arg5 = (jarg5 != JNI_FALSE);
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)XmlManager_createMemBufInputStream__SWIG_0((XmlManager const *)arg1,(char const *)arg2,arg3,(char const *)arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, arg4);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createMemBufInputStream_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned int arg3 ;
  char *arg4 = (char *) 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (unsigned int)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)XmlManager_createMemBufInputStream__SWIG_0((XmlManager const *)arg1,(char const *)arg2,arg3,(char const *)arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, arg4);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createMemBufInputStream_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned int arg3 ;
  bool arg4 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (unsigned int)jarg3; 
  
  arg4 = (jarg4 != JNI_FALSE);
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)XmlManager_createMemBufInputStream__SWIG_2((XmlManager const *)arg1,(char const *)arg2,arg3,arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createURLInputStream_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)XmlManager_createURLInputStream__SWIG_0((XmlManager const *)arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createURLInputStream_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)XmlManager_createURLInputStream__SWIG_1((XmlManager const *)arg1,(std::string const &)*arg2,(std::string const &)*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createContainer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  u_int32_t arg3 ;
  enum XmlContainer::ContainerType arg4 ;
  int arg5 ;
  XmlContainer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = (u_int32_t)jarg3; 
  arg4 = (enum XmlContainer::ContainerType)jarg4; 
  arg5 = (int)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlContainer *)XmlManager_createContainer__SWIG_0(arg1,(std::string const &)*arg2,arg3,arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createContainer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  u_int32_t arg3 ;
  enum XmlContainer::ContainerType arg4 ;
  XmlContainer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = (u_int32_t)jarg3; 
  arg4 = (enum XmlContainer::ContainerType)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlContainer *)XmlManager_createContainer__SWIG_0(arg1,(std::string const &)*arg2,arg3,arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createContainer_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  u_int32_t arg3 ;
  XmlContainer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = (u_int32_t)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlContainer *)XmlManager_createContainer__SWIG_0(arg1,(std::string const &)*arg2,arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createContainer_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jint jarg4, jint jarg5, jint jarg6) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  u_int32_t arg4 ;
  enum XmlContainer::ContainerType arg5 ;
  int arg6 ;
  XmlContainer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (u_int32_t)jarg4; 
  arg5 = (enum XmlContainer::ContainerType)jarg5; 
  arg6 = (int)jarg6; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlContainer *)XmlManager_createContainer__SWIG_3(arg1,*arg2,(std::string const &)*arg3,arg4,arg5,arg6);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createContainer_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  u_int32_t arg4 ;
  enum XmlContainer::ContainerType arg5 ;
  XmlContainer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (u_int32_t)jarg4; 
  arg5 = (enum XmlContainer::ContainerType)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlContainer *)XmlManager_createContainer__SWIG_3(arg1,*arg2,(std::string const &)*arg3,arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createContainer_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jint jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  u_int32_t arg4 ;
  XmlContainer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlContainer *)XmlManager_createContainer__SWIG_3(arg1,*arg2,(std::string const &)*arg3,arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1openContainer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  u_int32_t arg3 ;
  XmlContainer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = (u_int32_t)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlContainer *)XmlManager_openContainer__SWIG_0(arg1,(std::string const &)*arg2,arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1openContainer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jint jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  u_int32_t arg4 ;
  XmlContainer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlContainer *)XmlManager_openContainer__SWIG_1(arg1,*arg2,(std::string const &)*arg3,arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1openContainer_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  u_int32_t arg3 ;
  enum XmlContainer::ContainerType arg4 ;
  int arg5 ;
  XmlContainer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = (u_int32_t)jarg3; 
  arg4 = (enum XmlContainer::ContainerType)jarg4; 
  arg5 = (int)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlContainer *)XmlManager_openContainer__SWIG_2(arg1,(std::string const &)*arg2,arg3,arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1openContainer_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  u_int32_t arg3 ;
  enum XmlContainer::ContainerType arg4 ;
  XmlContainer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = (u_int32_t)jarg3; 
  arg4 = (enum XmlContainer::ContainerType)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlContainer *)XmlManager_openContainer__SWIG_2(arg1,(std::string const &)*arg2,arg3,arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1openContainer_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jint jarg4, jint jarg5, jint jarg6) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  u_int32_t arg4 ;
  enum XmlContainer::ContainerType arg5 ;
  int arg6 ;
  XmlContainer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (u_int32_t)jarg4; 
  arg5 = (enum XmlContainer::ContainerType)jarg5; 
  arg6 = (int)jarg6; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlContainer *)XmlManager_openContainer__SWIG_4(arg1,*arg2,(std::string const &)*arg3,arg4,arg5,arg6);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1openContainer_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  u_int32_t arg4 ;
  enum XmlContainer::ContainerType arg5 ;
  XmlContainer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (u_int32_t)jarg4; 
  arg5 = (enum XmlContainer::ContainerType)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlContainer *)XmlManager_openContainer__SWIG_4(arg1,*arg2,(std::string const &)*arg3,arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1dumpContainer(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_dumpContainer(arg1,(std::string const &)*arg2,(char const *)arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3);
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1loadContainer(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jlong jarg4) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  XmlUpdateContext *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_loadContainer(arg1,(std::string const &)*arg2,(char const *)arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3);
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1verifyContainer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jint jarg4) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  u_int32_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_verifyContainer__SWIG_0(arg1,(std::string const &)*arg2,(char const *)arg3,arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3);
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1verifyContainer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_verifyContainer__SWIG_0(arg1,(std::string const &)*arg2,(char const *)arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3);
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createDocument(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlDocument *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlDocument *)XmlManager_createDocument(arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlDocument **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createQueryContext_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  enum XmlQueryContext::ReturnType arg2 ;
  enum XmlQueryContext::EvaluationType arg3 ;
  XmlQueryContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = (enum XmlQueryContext::ReturnType)jarg2; 
  arg3 = (enum XmlQueryContext::EvaluationType)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlQueryContext *)XmlManager_createQueryContext__SWIG_0(arg1,arg2,arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlQueryContext **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createQueryContext_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlQueryContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlQueryContext *)XmlManager_createQueryContext__SWIG_1(arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlQueryContext **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createQueryContext_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  enum XmlQueryContext::ReturnType arg2 ;
  XmlQueryContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = (enum XmlQueryContext::ReturnType)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlQueryContext *)XmlManager_createQueryContext__SWIG_2(arg1,arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlQueryContext **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createUpdateContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlUpdateContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlUpdateContext *)XmlManager_createUpdateContext(arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlUpdateContext **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1prepare_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  XmlQueryExpression *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlQueryContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlQueryExpression *)XmlManager_prepare__SWIG_0(arg1,(std::string const &)*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlQueryExpression **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1prepare_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlQueryContext *arg4 = 0 ;
  XmlQueryExpression *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlQueryContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlQueryExpression *)XmlManager_prepare__SWIG_1(arg1,*arg2,(std::string const &)*arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlQueryExpression **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1query_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jint jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  u_int32_t arg4 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlQueryContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlManager_query__SWIG_0(arg1,(std::string const &)*arg2,*arg3,arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1query_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4, jint jarg5) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlQueryContext *arg4 = 0 ;
  u_int32_t arg5 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlQueryContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  arg5 = (u_int32_t)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlManager_query__SWIG_1(arg1,*arg2,(std::string const &)*arg3,*arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1query_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlQueryContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlManager_query__SWIG_2(arg1,(std::string const &)*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1query_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlQueryContext *arg4 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlQueryContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlManager_query__SWIG_3(arg1,*arg2,(std::string const &)*arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createResults(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlManager_createResults(arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createModify(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlModify *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlModify *)XmlManager_createModify(arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlModify **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createTransaction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  DbTxn *arg2 = (DbTxn *) 0 ;
  XmlTransaction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  {
    arg2 = get_DbTxn(jenv, jarg2);
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlTransaction *)XmlManager_createTransaction(arg1,arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlTransaction **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createIndexLookup_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jlong jarg6, jint jarg7) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlContainer *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlValue *arg6 = 0 ;
  enum XmlIndexLookup::Operation arg7 ;
  XmlIndexLookup *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlContainer **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlContainer & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  arg6 = *(XmlValue **)&jarg6;
  if(!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  arg7 = (enum XmlIndexLookup::Operation)jarg7; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexLookup *)XmlManager_createIndexLookup__SWIG_0(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(XmlValue const &)*arg6,arg7);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlIndexLookup **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createIndexLookup_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jlong jarg6) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlContainer *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlValue *arg6 = 0 ;
  XmlIndexLookup *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlContainer **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlContainer & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  arg6 = *(XmlValue **)&jarg6;
  if(!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexLookup *)XmlManager_createIndexLookup__SWIG_0(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(XmlValue const &)*arg6);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlIndexLookup **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createIndexLookup_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlContainer *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlIndexLookup *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlContainer **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlContainer & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexLookup *)XmlManager_createIndexLookup__SWIG_0(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlIndexLookup **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1setLogLevel(JNIEnv *jenv, jclass jcls, jint jarg1, jboolean jarg2) {
  enum LogLevel arg1 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (enum LogLevel)jarg1; 
  
  arg2 = (jarg2 != JNI_FALSE);
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_setLogLevel(arg1,arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1setLogCategory(JNIEnv *jenv, jclass jcls, jint jarg1, jboolean jarg2) {
  enum LogCategory arg1 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (enum LogCategory)jarg1; 
  
  arg2 = (jarg2 != JNI_FALSE);
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_setLogCategory(arg1,arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1get_1version_1major(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (int)XmlManager_get_version_major();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1get_1version_1minor(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (int)XmlManager_get_version_minor();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1get_1version_1patch(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (int)XmlManager_get_version_patch();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1get_1version_1string(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (char *)XmlManager_get_version_string();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  if(result) jresult = jenv->NewStringUTF(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlIndexLookup(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlIndexLookup *arg1 = 0 ;
  XmlIndexLookup *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlIndexLookup const & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexLookup *)new XmlIndexLookup((XmlIndexLookup const &)*arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlIndexLookup **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlIndexLookup(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
      
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlIndexLookup const *)arg1)->isNull();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getIndex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        std::string const &_result_ref = ((XmlIndexLookup const *)arg1)->getIndex();
        result = (std::string *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1setIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setIndex((std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getNodeURI(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        std::string const &_result_ref = ((XmlIndexLookup const *)arg1)->getNodeURI();
        result = (std::string *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getNodeName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        std::string const &_result_ref = ((XmlIndexLookup const *)arg1)->getNodeName();
        result = (std::string *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1setNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setNode((std::string const &)*arg2,(std::string const &)*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getParentURI(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        std::string const &_result_ref = ((XmlIndexLookup const *)arg1)->getParentURI();
        result = (std::string *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getParentName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        std::string const &_result_ref = ((XmlIndexLookup const *)arg1)->getParentName();
        result = (std::string *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1setParent(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setParent((std::string const &)*arg2,(std::string const &)*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getLowBoundValue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        XmlValue const &_result_ref = ((XmlIndexLookup const *)arg1)->getLowBoundValue();
        result = (XmlValue *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getLowBoundOperation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  enum XmlIndexLookup::Operation result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlIndexLookup::Operation)((XmlIndexLookup const *)arg1)->getLowBoundOperation();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1setLowBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlValue *arg2 = 0 ;
  enum XmlIndexLookup::Operation arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  arg2 = *(XmlValue **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return ;
  } 
  arg3 = (enum XmlIndexLookup::Operation)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setLowBound((XmlValue const &)*arg2,arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getHighBoundValue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        XmlValue const &_result_ref = ((XmlIndexLookup const *)arg1)->getHighBoundValue();
        result = (XmlValue *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getHighBoundOperation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  enum XmlIndexLookup::Operation result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlIndexLookup::Operation)((XmlIndexLookup const *)arg1)->getHighBoundOperation();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1setHighBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlValue *arg2 = 0 ;
  enum XmlIndexLookup::Operation arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  arg2 = *(XmlValue **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return ;
  } 
  arg3 = (enum XmlIndexLookup::Operation)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setHighBound((XmlValue const &)*arg2,arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getContainer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlContainer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        XmlContainer const &_result_ref = ((XmlIndexLookup const *)arg1)->getContainer();
        result = (XmlContainer *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1setContainer(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlContainer *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  arg2 = *(XmlContainer **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlContainer & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setContainer(*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1execute_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jlong jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  u_int32_t arg3 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  arg2 = *(XmlQueryContext **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  arg3 = (u_int32_t)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlIndexLookup_execute__SWIG_0((XmlIndexLookup const *)arg1,*arg2,arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1execute_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  arg2 = *(XmlQueryContext **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlIndexLookup_execute__SWIG_0((XmlIndexLookup const *)arg1,*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1execute_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
  jlong jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  u_int32_t arg4 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlQueryContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlIndexLookup_execute__SWIG_2((XmlIndexLookup const *)arg1,*arg2,*arg3,arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1execute_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlQueryContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlIndexLookup_execute__SWIG_2((XmlIndexLookup const *)arg1,*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlContainer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = 0 ;
  XmlContainer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlContainer const & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (XmlContainer *)new XmlContainer((XmlContainer const &)*arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlContainer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
      
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1sync(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->sync();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1addAlias(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jboolean jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)(arg1)->addAlias((std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1removeAlias(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jboolean jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)(arg1)->removeAlias((std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        std::string const &_result_ref = ((XmlContainer const *)arg1)->getName();
        result = (std::string *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getContainerType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  enum XmlContainer::ContainerType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlContainer::ContainerType)((XmlContainer const *)arg1)->getContainerType();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getIndexNodes(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlContainer const *)arg1)->getIndexNodes();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getPageSize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlContainer const *)arg1)->getPageSize();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1setIndexSpecification_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlIndexSpecification *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlIndexSpecification **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlIndexSpecification const & reference is null");
    return ;
  } 
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setIndexSpecification((XmlIndexSpecification const &)*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1addIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jlong jarg5) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlUpdateContext *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = *(XmlUpdateContext **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4,*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1addIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jint jarg4, jint jarg5, jlong jarg6) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  enum XmlIndexSpecification::Type arg4 ;
  enum XmlValue::Type arg5 ;
  XmlUpdateContext *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (enum XmlIndexSpecification::Type)jarg4; 
  arg5 = (enum XmlValue::Type)jarg5; 
  arg6 = *(XmlUpdateContext **)&jarg6;
  if(!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addIndex((std::string const &)*arg2,(std::string const &)*arg3,arg4,arg5,*arg6);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jlong jarg5) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlUpdateContext *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = *(XmlUpdateContext **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->deleteIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4,*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1replaceIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jlong jarg5) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlUpdateContext *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = *(XmlUpdateContext **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->replaceIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4,*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1addDefaultIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addDefaultIndex((std::string const &)*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteDefaultIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->deleteDefaultIndex((std::string const &)*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1replaceDefaultIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->replaceDefaultIndex((std::string const &)*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1setIndexSpecification_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlIndexSpecification *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  arg3 = *(XmlIndexSpecification **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlIndexSpecification const & reference is null");
    return ;
  } 
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setIndexSpecification(*arg2,(XmlIndexSpecification const &)*arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1addIndex_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jlong jarg6) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlUpdateContext *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return ;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  arg6 = *(XmlUpdateContext **)&jarg6;
  if(!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addIndex(*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,*arg6);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1addIndex_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jint jarg5, jint jarg6, jlong jarg7) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  enum XmlIndexSpecification::Type arg5 ;
  enum XmlValue::Type arg6 ;
  XmlUpdateContext *arg7 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = (enum XmlIndexSpecification::Type)jarg5; 
  arg6 = (enum XmlValue::Type)jarg6; 
  arg7 = *(XmlUpdateContext **)&jarg7;
  if(!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addIndex(*arg2,(std::string const &)*arg3,(std::string const &)*arg4,arg5,arg6,*arg7);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jlong jarg6) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlUpdateContext *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return ;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  arg6 = *(XmlUpdateContext **)&jarg6;
  if(!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->deleteIndex(*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,*arg6);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1replaceIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jlong jarg6) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlUpdateContext *arg6 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return ;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  arg6 = *(XmlUpdateContext **)&jarg6;
  if(!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->replaceIndex(*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,*arg6);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1addDefaultIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addDefaultIndex(*arg2,(std::string const &)*arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteDefaultIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->deleteDefaultIndex(*arg2,(std::string const &)*arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1replaceDefaultIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->replaceDefaultIndex(*arg2,(std::string const &)*arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlDocument *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  u_int32_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlDocument **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
    return ;
  } 
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->putDocument(*arg2,*arg3,arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlDocument *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlDocument **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
    return ;
  } 
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->putDocument(*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jlong jarg4, jint jarg5) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  u_int32_t arg5 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return 0;
  } 
  arg5 = (u_int32_t)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->putDocument((std::string const &)*arg2,(std::string const &)*arg3,*arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jlong jarg4) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->putDocument((std::string const &)*arg2,(std::string const &)*arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  XmlEventReader *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  u_int32_t arg5 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlEventReader **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlEventReader & reference is null");
    return 0;
  } 
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return 0;
  } 
  arg5 = (u_int32_t)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->putDocument((std::string const &)*arg2,*arg3,*arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocumentAsEventWriter_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlDocument *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  u_int32_t arg4 ;
  XmlEventWriter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlDocument **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
    return 0;
  } 
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return 0;
  } 
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        XmlEventWriter &_result_ref = (arg1)->putDocumentAsEventWriter(*arg2,*arg3,arg4);
        result = (XmlEventWriter *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlEventWriter **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocumentAsEventWriter_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlDocument *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  XmlEventWriter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlDocument **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
    return 0;
  } 
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        XmlEventWriter &_result_ref = (arg1)->putDocumentAsEventWriter(*arg2,*arg3);
        result = (XmlEventWriter *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlEventWriter **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteDocument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlDocument *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlDocument **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
    return ;
  } 
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->deleteDocument(*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteDocument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->deleteDocument((std::string const &)*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1updateDocument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlDocument *arg2 = 0 ;
  XmlUpdateContext *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlDocument **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
    return ;
  } 
  arg3 = *(XmlUpdateContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->updateDocument(*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  XmlInputStream *arg3 = (XmlInputStream *) 0 ;
  XmlUpdateContext *arg4 = 0 ;
  u_int32_t arg5 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlInputStream **)&jarg3; 
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return 0;
  } 
  arg5 = (u_int32_t)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->putDocument((std::string const &)*arg2,arg3,*arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jlong jarg4) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  XmlInputStream *arg3 = (XmlInputStream *) 0 ;
  XmlUpdateContext *arg4 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlInputStream **)&jarg3; 
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->putDocument((std::string const &)*arg2,arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4, jlong jarg5, jint jarg6) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlInputStream *arg4 = (XmlInputStream *) 0 ;
  XmlUpdateContext *arg5 = 0 ;
  u_int32_t arg6 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlInputStream **)&jarg4; 
  arg5 = *(XmlUpdateContext **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return 0;
  } 
  arg6 = (u_int32_t)jarg6; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->putDocument(*arg2,(std::string const &)*arg3,arg4,*arg5,arg6);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4, jlong jarg5) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlInputStream *arg4 = (XmlInputStream *) 0 ;
  XmlUpdateContext *arg5 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlInputStream **)&jarg4; 
  arg5 = *(XmlUpdateContext **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->putDocument(*arg2,(std::string const &)*arg3,arg4,*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_19(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlDocument *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  u_int32_t arg5 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  arg3 = *(XmlDocument **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
    return ;
  } 
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  arg5 = (u_int32_t)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->putDocument(*arg2,*arg3,*arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_110(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlDocument *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  arg3 = *(XmlDocument **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
    return ;
  } 
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->putDocument(*arg2,*arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_111(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jlong jarg5, jint jarg6) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlUpdateContext *arg5 = 0 ;
  u_int32_t arg6 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = *(XmlUpdateContext **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return 0;
  } 
  arg6 = (u_int32_t)jarg6; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->putDocument(*arg2,(std::string const &)*arg3,(std::string const &)*arg4,*arg5,arg6);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_112(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jlong jarg5) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlUpdateContext *arg5 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = *(XmlUpdateContext **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->putDocument(*arg2,(std::string const &)*arg3,(std::string const &)*arg4,*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_113(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4, jlong jarg5, jint jarg6) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlEventReader *arg4 = 0 ;
  XmlUpdateContext *arg5 = 0 ;
  u_int32_t arg6 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlEventReader **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlEventReader & reference is null");
    return 0;
  } 
  arg5 = *(XmlUpdateContext **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return 0;
  } 
  arg6 = (u_int32_t)jarg6; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->putDocument(*arg2,(std::string const &)*arg3,*arg4,*arg5,arg6);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocumentAsEventWriter_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlDocument *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  u_int32_t arg5 ;
  XmlEventWriter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlDocument **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
    return 0;
  } 
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return 0;
  } 
  arg5 = (u_int32_t)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        XmlEventWriter &_result_ref = (arg1)->putDocumentAsEventWriter(*arg2,*arg3,*arg4,arg5);
        result = (XmlEventWriter *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlEventWriter **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocumentAsEventWriter_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlDocument *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  XmlEventWriter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlDocument **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
    return 0;
  } 
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        XmlEventWriter &_result_ref = (arg1)->putDocumentAsEventWriter(*arg2,*arg3,*arg4);
        result = (XmlEventWriter *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlEventWriter **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteDocument_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlDocument *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  arg3 = *(XmlDocument **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
    return ;
  } 
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->deleteDocument(*arg2,*arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteDocument_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jlong jarg4) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->deleteDocument(*arg2,(std::string const &)*arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1updateDocument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlDocument *arg3 = 0 ;
  XmlUpdateContext *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  arg3 = *(XmlDocument **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
    return ;
  } 
  arg4 = *(XmlUpdateContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->updateDocument(*arg2,*arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getNumDocuments_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->getNumDocuments();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getNumDocuments_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->getNumDocuments(*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getIndexSpecification_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlIndexSpecification *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexSpecification *)XmlContainer_getIndexSpecification__SWIG_0((XmlContainer const *)arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlIndexSpecification **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getIndexSpecification_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlIndexSpecification *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexSpecification *)XmlContainer_getIndexSpecification__SWIG_1((XmlContainer const *)arg1,*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlIndexSpecification **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getIndexSpecification_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  u_int32_t arg3 ;
  XmlIndexSpecification *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = (u_int32_t)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexSpecification *)XmlContainer_getIndexSpecification__SWIG_2((XmlContainer const *)arg1,*arg2,arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlIndexSpecification **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getDocument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  u_int32_t arg3 ;
  XmlDocument *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = (u_int32_t)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlDocument *)XmlContainer_getDocument__SWIG_0(arg1,(std::string const &)*arg2,arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlDocument **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getDocument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jint jarg4) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  u_int32_t arg4 ;
  XmlDocument *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlDocument *)XmlContainer_getDocument__SWIG_1(arg1,*arg2,(std::string const &)*arg3,arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlDocument **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getNode_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  u_int32_t arg3 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = (u_int32_t)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)XmlContainer_getNode__SWIG_0(arg1,(std::string const &)*arg2,arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getNode_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jint jarg4) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  u_int32_t arg4 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)XmlContainer_getNode__SWIG_1(arg1,*arg2,(std::string const &)*arg3,arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getAllDocuments_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  u_int32_t arg2 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_getAllDocuments__SWIG_0(arg1,arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getAllDocuments_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  u_int32_t arg3 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = (u_int32_t)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_getAllDocuments__SWIG_1(arg1,*arg2,arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jlong jarg6, jint jarg7) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlValue *arg6 = 0 ;
  u_int32_t arg7 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlQueryContext **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  arg6 = *(XmlValue **)&jarg6;
  if(!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  arg7 = (u_int32_t)jarg7; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_0(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(XmlValue const &)*arg6,arg7);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jlong jarg6) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlValue *arg6 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlQueryContext **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  arg6 = *(XmlValue **)&jarg6;
  if(!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_0(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(XmlValue const &)*arg6);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlQueryContext **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_0(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7, jlong jarg8, jint jarg9) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  XmlValue *arg8 = 0 ;
  u_int32_t arg9 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlQueryContext **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  const char *arg7_pstr = "";
  if(jarg7) {
    arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0);
  }
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  if (jarg7) {
    jenv->ReleaseStringUTFChars(jarg7, arg7_pstr);
  }
  
  arg8 = *(XmlValue **)&jarg8;
  if(!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  arg9 = (u_int32_t)jarg9; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_3(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(XmlValue const &)*arg8,arg9);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7, jlong jarg8) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  XmlValue *arg8 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlQueryContext **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  const char *arg7_pstr = "";
  if(jarg7) {
    arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0);
  }
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  if (jarg7) {
    jenv->ReleaseStringUTFChars(jarg7, arg7_pstr);
  }
  
  arg8 = *(XmlValue **)&jarg8;
  if(!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_3(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(XmlValue const &)*arg8);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlQueryContext **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  const char *arg7_pstr = "";
  if(jarg7) {
    arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0);
  }
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  if (jarg7) {
    jenv->ReleaseStringUTFChars(jarg7, arg7_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_3(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jlong jarg7, jint jarg8) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  XmlValue *arg7 = 0 ;
  u_int32_t arg8 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlQueryContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  arg7 = *(XmlValue **)&jarg7;
  if(!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  arg8 = (u_int32_t)jarg8; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_6(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(XmlValue const &)*arg7,arg8);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jlong jarg7) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  XmlValue *arg7 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlQueryContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  arg7 = *(XmlValue **)&jarg7;
  if(!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_6(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(XmlValue const &)*arg7);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jstring jarg4, jstring jarg5, jstring jarg6) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlQueryContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_6(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_19(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7, jstring jarg8, jlong jarg9, jint jarg10) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  std::string *arg8 = 0 ;
  XmlValue *arg9 = 0 ;
  u_int32_t arg10 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlQueryContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  const char *arg7_pstr = "";
  if(jarg7) {
    arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0);
  }
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  if (jarg7) {
    jenv->ReleaseStringUTFChars(jarg7, arg7_pstr);
  }
  
  
  const char *arg8_pstr = "";
  if(jarg8) {
    arg8_pstr = (const char *)jenv->GetStringUTFChars(jarg8, 0);
  }
  if (!arg8_pstr) return 0;
  std::string arg8_str(arg8_pstr);
  arg8 = &arg8_str;
  if (jarg8) {
    jenv->ReleaseStringUTFChars(jarg8, arg8_pstr);
  }
  
  arg9 = *(XmlValue **)&jarg9;
  if(!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  arg10 = (u_int32_t)jarg10; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_9(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(std::string const &)*arg8,(XmlValue const &)*arg9,arg10);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_110(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7, jstring jarg8, jlong jarg9) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  std::string *arg8 = 0 ;
  XmlValue *arg9 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlQueryContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  const char *arg7_pstr = "";
  if(jarg7) {
    arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0);
  }
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  if (jarg7) {
    jenv->ReleaseStringUTFChars(jarg7, arg7_pstr);
  }
  
  
  const char *arg8_pstr = "";
  if(jarg8) {
    arg8_pstr = (const char *)jenv->GetStringUTFChars(jarg8, 0);
  }
  if (!arg8_pstr) return 0;
  std::string arg8_str(arg8_pstr);
  arg8 = &arg8_str;
  if (jarg8) {
    jenv->ReleaseStringUTFChars(jarg8, arg8_pstr);
  }
  
  arg9 = *(XmlValue **)&jarg9;
  if(!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_9(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(std::string const &)*arg8,(XmlValue const &)*arg9);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_111(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7, jstring jarg8) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  std::string *arg8 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlQueryContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  const char *arg7_pstr = "";
  if(jarg7) {
    arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0);
  }
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  if (jarg7) {
    jenv->ReleaseStringUTFChars(jarg7, arg7_pstr);
  }
  
  
  const char *arg8_pstr = "";
  if(jarg8) {
    arg8_pstr = (const char *)jenv->GetStringUTFChars(jarg8, 0);
  }
  if (!arg8_pstr) return 0;
  std::string arg8_str(arg8_pstr);
  arg8 = &arg8_str;
  if (jarg8) {
    jenv->ReleaseStringUTFChars(jarg8, arg8_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_9(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(std::string const &)*arg8);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupStatistics_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlValue *arg5 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = *(XmlValue **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_0(arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(XmlValue const &)*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupStatistics_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_0(arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupStatistics_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jlong jarg7) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  XmlValue *arg7 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  arg7 = *(XmlValue **)&jarg7;
  if(!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_2(arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(XmlValue const &)*arg7);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupStatistics_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_2(arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupStatistics_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jlong jarg6) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlValue *arg6 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  arg6 = *(XmlValue **)&jarg6;
  if(!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_4(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(XmlValue const &)*arg6);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupStatistics_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_4(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupStatistics_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7, jlong jarg8) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  XmlValue *arg8 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  const char *arg7_pstr = "";
  if(jarg7) {
    arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0);
  }
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  if (jarg7) {
    jenv->ReleaseStringUTFChars(jarg7, arg7_pstr);
  }
  
  arg8 = *(XmlValue **)&jarg8;
  if(!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_6(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(XmlValue const &)*arg8);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupStatistics_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  const char *arg7_pstr = "";
  if(jarg7) {
    arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0);
  }
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  if (jarg7) {
    jenv->ReleaseStringUTFChars(jarg7, arg7_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_6(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlDocument(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlDocument *arg1 = 0 ;
  XmlDocument *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument const & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (XmlDocument *)new XmlDocument((XmlDocument const &)*arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlDocument **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlDocument(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
      
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1setName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setName((std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlDocument const *)arg1)->getName();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1setContent_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setContent((std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1setContent_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jbyteArray jarg2) {
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  XmlData *arg2 = 0 ;
  XmlData xml_data2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  {
    if (jarg2 != NULL) {
      xml_data2.set_data(jenv->GetByteArrayElements(jarg2, (jboolean *)0));
      xml_data2.set_size(jenv->GetArrayLength(jarg2));
    }
    arg2 = &xml_data2;
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setContent((XmlData const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1getContentAsXmlInputStream(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)((XmlDocument const *)arg1)->getContentAsXmlInputStream();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1setContentAsXmlInputStream_1java(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  XmlInputStream *arg2 = (XmlInputStream *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  arg2 = *(XmlInputStream **)&jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setContentAsXmlInputStream(arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1getContentAsEventReader(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  XmlEventReader *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        XmlEventReader &_result_ref = ((XmlDocument const *)arg1)->getContentAsEventReader();
        result = (XmlEventReader *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlEventReader **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1setContentAsEventReader_1java(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  XmlEventReader *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  arg2 = *(XmlEventReader **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlEventReader & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setContentAsEventReader(*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1getContentAsEventWriter(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  XmlEventWriter *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  arg2 = *(XmlEventWriter **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlEventWriter & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->getContentAsEventWriter(*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1fetchAllData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->fetchAllData();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1setMetaData_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jlong jarg4) {
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlValue *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlValue **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setMetaData((std::string const &)*arg2,(std::string const &)*arg3,(XmlValue const &)*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1getMetaData_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlValue *arg4 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlValue **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)(arg1)->getMetaData((std::string const &)*arg2,(std::string const &)*arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1removeMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->removeMetaData((std::string const &)*arg2,(std::string const &)*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1setMetaData_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jbyteArray jarg4) {
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlData *arg4 = 0 ;
  XmlData xml_data4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  {
    if (jarg4 != NULL) {
      xml_data4.set_data(jenv->GetByteArrayElements(jarg4, (jboolean *)0));
      xml_data4.set_size(jenv->GetArrayLength(jarg4));
    }
    arg4 = &xml_data4;
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setMetaData((std::string const &)*arg2,(std::string const &)*arg3,(XmlData const &)*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1getContentAsString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlDocument_getContentAsString((XmlDocument const *)arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jbyteArray JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1getContent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jbyteArray jresult = 0 ;
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  XmlData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlData *)XmlDocument_getContent((XmlDocument const *)arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  if (result) {
    jresult = jenv->NewByteArray(result->get_size());
    jenv->SetByteArrayRegion(jresult, 0, result->get_size(),
      (jbyte *)result->get_data());
    delete result; // done with new XmlData object
  } else {
    jresult = NULL;
  }
  
  return jresult;
}


JNIEXPORT jbyteArray JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1getMetaData_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  jbyteArray jresult = 0 ;
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlData *)XmlDocument_getMetaData__SWIG_1(arg1,(std::string const &)*arg2,(std::string const &)*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  if (result) {
    jresult = jenv->NewByteArray(result->get_size());
    jenv->SetByteArrayRegion(jresult, 0, result->get_size(),
      (jbyte *)result->get_data());
    delete result; // done with new XmlData object
  } else {
    jresult = NULL;
  }
  
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1getMetaDataIterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  XmlMetaDataIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlMetaDataIterator *)XmlDocument_getMetaDataIterator((XmlDocument const *)arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlMetaDataIterator **)&jresult = result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDocument_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  XmlDocument *arg1 = (XmlDocument *) 0 ;
  XmlDocument *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1; 
  arg2 = *(XmlDocument **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument const & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)XmlDocument_equals((XmlDocument const *)arg1,(XmlDocument const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlMetaDataIterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlMetaDataIterator *arg1 = 0 ;
  XmlMetaDataIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlMetaDataIterator **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlMetaDataIterator const & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (XmlMetaDataIterator *)new XmlMetaDataIterator((XmlMetaDataIterator const &)*arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlMetaDataIterator **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlMetaDataIterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlMetaDataIterator *arg1 = (XmlMetaDataIterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlMetaDataIterator **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
      
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlMetaDataIterator_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlMetaDataIterator *arg1 = (XmlMetaDataIterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlMetaDataIterator **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->reset();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlMetaDataIterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlMetaDataIterator *arg1 = (XmlMetaDataIterator *) 0 ;
  XmlMetaData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlMetaDataIterator **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlMetaData *)XmlMetaDataIterator_next(arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlMetaData **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlMetaData *arg1 = (XmlMetaData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlMetaData **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
      
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlMetaData_1get_1uri(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlMetaData *arg1 = (XmlMetaData *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlMetaData **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        std::string const &_result_ref = ((XmlMetaData const *)arg1)->get_uri();
        result = (std::string *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlMetaData_1get_1name(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlMetaData *arg1 = (XmlMetaData *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlMetaData **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        std::string const &_result_ref = ((XmlMetaData const *)arg1)->get_name();
        result = (std::string *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlMetaData_1get_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlMetaData *arg1 = (XmlMetaData *) 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlMetaData **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        XmlValue const &_result_ref = ((XmlMetaData const *)arg1)->get_value();
        result = (XmlValue *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlQueryContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlQueryContext *arg1 = 0 ;
  XmlQueryContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext const & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (XmlQueryContext *)new XmlQueryContext((XmlQueryContext const &)*arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlQueryContext **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlQueryContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
      
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1setNamespace(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setNamespace((std::string const &)*arg2,(std::string const &)*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1getNamespace(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  std::string *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->getNamespace((std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1removeNamespace(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->removeNamespace((std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1clearNamespaces(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->clearNamespaces();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1setVariableValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  std::string *arg2 = 0 ;
  XmlValue *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlValue **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setVariableValue((std::string const &)*arg2,(XmlValue const &)*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1setVariableValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  std::string *arg2 = 0 ;
  XmlResults *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlResults **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlResults & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setVariableValue((std::string const &)*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1setBaseURI(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setBaseURI((std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1getBaseURI(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlQueryContext const *)arg1)->getBaseURI();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1setReturnType(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  enum XmlQueryContext::ReturnType arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  arg2 = (enum XmlQueryContext::ReturnType)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setReturnType(arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1getReturnType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  enum XmlQueryContext::ReturnType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlQueryContext::ReturnType)((XmlQueryContext const *)arg1)->getReturnType();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1setEvaluationType(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  enum XmlQueryContext::EvaluationType arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  arg2 = (enum XmlQueryContext::EvaluationType)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setEvaluationType(arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1getEvaluationType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  enum XmlQueryContext::EvaluationType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlQueryContext::EvaluationType)((XmlQueryContext const *)arg1)->getEvaluationType();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1setDefaultCollection(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setDefaultCollection((std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1getDefaultCollection(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlQueryContext const *)arg1)->getDefaultCollection();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1interruptQuery(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->interruptQuery();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1setQueryTimeoutSeconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  u_int32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setQueryTimeoutSeconds(arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1getQueryTimeoutSeconds(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlQueryContext const *)arg1)->getQueryTimeoutSeconds();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1getVariableValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  std::string *arg2 = 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)XmlQueryContext_getVariableValue((XmlQueryContext const *)arg1,(std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryContext_1getVariableValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  XmlQueryContext *arg1 = (XmlQueryContext *) 0 ;
  std::string *arg2 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryContext **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryContext_getVariableValues((XmlQueryContext const *)arg1,(std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlResults(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlResults *arg1 = (XmlResults *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
      
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlResults(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlResults *arg1 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResults **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlResults const & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)new XmlResults((XmlResults const &)*arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1hasNext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)(arg1)->hasNext();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1hasPrevious(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)(arg1)->hasPrevious();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1next_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)XmlResults_next__SWIG_0(arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1previous_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)XmlResults_previous__SWIG_0(arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1peek_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)XmlResults_peek__SWIG_0(arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1getEvaluationType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  enum XmlQueryContext::EvaluationType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlQueryContext::EvaluationType)((XmlResults const *)arg1)->getEvaluationType();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1next_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlDocument *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResults **)&jarg1; 
  arg2 = *(XmlDocument **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)(arg1)->next(*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1previous_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlDocument *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResults **)&jarg1; 
  arg2 = *(XmlDocument **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)(arg1)->previous(*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1peek_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlDocument *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResults **)&jarg1; 
  arg2 = *(XmlDocument **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)(arg1)->peek(*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlResults *arg1 = (XmlResults *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->reset();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlResults const *)arg1)->size();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlValue *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResults **)&jarg1; 
  arg2 = *(XmlValue **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->add((XmlValue const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlUpdateContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlUpdateContext *arg1 = 0 ;
  XmlUpdateContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlUpdateContext **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlUpdateContext const & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (XmlUpdateContext *)new XmlUpdateContext((XmlUpdateContext const &)*arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlUpdateContext **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlUpdateContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlUpdateContext *arg1 = (XmlUpdateContext *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlUpdateContext **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
      
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlUpdateContext_1setApplyChangesToContainers(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
  XmlUpdateContext *arg1 = (XmlUpdateContext *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlUpdateContext **)&jarg1; 
  
  arg2 = (jarg2 != JNI_FALSE);
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setApplyChangesToContainers(arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlUpdateContext_1getApplyChangesToContainers(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  XmlUpdateContext *arg1 = (XmlUpdateContext *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlUpdateContext **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlUpdateContext const *)arg1)->getApplyChangesToContainers();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)new XmlValue();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlValue *arg1 = 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)new XmlValue((XmlValue const &)*arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlValue_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  const char *arg1_pstr = "";
  if(jarg1) {
    arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0);
  }
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  if (jarg1) {
    jenv->ReleaseStringUTFChars(jarg1, arg1_pstr);
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)new XmlValue((std::string const &)*arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlValue_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  double arg1 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)new XmlValue(arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlValue_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jlong jresult = 0 ;
  bool arg1 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  arg1 = (jarg1 != JNI_FALSE);
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)new XmlValue(arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlValue_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlDocument *arg1 = 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDocument **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlDocument const & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)new XmlValue((XmlDocument const &)*arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlValue_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  enum XmlValue::Type arg1 ;
  std::string *arg2 = 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (enum XmlValue::Type)jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)new XmlValue(arg1,(std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlValue_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jint jarg1, jbyteArray jarg2) {
  jlong jresult = 0 ;
  enum XmlValue::Type arg1 ;
  XmlData *arg2 = 0 ;
  XmlValue *result = 0 ;
  XmlData xml_data2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (enum XmlValue::Type)jarg1; 
  {
    if (jarg2 != NULL) {
      xml_data2.set_data(jenv->GetByteArrayElements(jarg2, (jboolean *)0));
      xml_data2.set_size(jenv->GetArrayLength(jarg2));
    }
    arg2 = &xml_data2;
  }
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)new XmlValue(arg1,(XmlData const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlValue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlValue *arg1 = (XmlValue *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
      
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  enum XmlValue::Type result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlValue::Type)((XmlValue const *)arg1)->getType();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getTypeURI(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlValue const *)arg1)->getTypeURI();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getTypeName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlValue const *)arg1)->getTypeName();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlValue const *)arg1)->isNull();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1isType(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  enum XmlValue::Type arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  arg2 = (enum XmlValue::Type)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlValue const *)arg1)->isType(arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1isNumber(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlValue const *)arg1)->isNumber();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1isString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlValue const *)arg1)->isString();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1isBoolean(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlValue const *)arg1)->isBoolean();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1isBinary(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlValue const *)arg1)->isBinary();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1isNode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlValue const *)arg1)->isNode();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jdouble JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1asNumber(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (double)((XmlValue const *)arg1)->asNumber();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1asString_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlValue const *)arg1)->asString();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1asString_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  std::string *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlValue const *)arg1)->asString((std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1asBoolean(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlValue const *)arg1)->asBoolean();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jbyteArray JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1asBinary(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jbyteArray jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  XmlData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlData *)XmlValue_asBinary((XmlValue const *)arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  if (result) {
    jresult = jenv->NewByteArray(result->get_size());
    jenv->SetByteArrayRegion(jresult, 0, result->get_size(),
      (jbyte *)result->get_data());
    delete result; // done with new XmlData object
  } else {
    jresult = NULL;
  }
  
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1asDocument(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  SwigValueWrapper<XmlDocument > result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlValue const *)arg1)->asDocument();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlDocument **)&jresult = new XmlDocument((XmlDocument &)result); 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1asEventReader(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  XmlEventReader *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        XmlEventReader &_result_ref = ((XmlValue const *)arg1)->asEventReader();
        result = (XmlEventReader *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlEventReader **)&jresult = result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getNodeHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlValue const *)arg1)->getNodeHandle();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  XmlValue *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  arg2 = *(XmlValue **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlValue const *)arg1)->equals((XmlValue const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getNodeName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlValue const *)arg1)->getNodeName();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getNodeValue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlValue const *)arg1)->getNodeValue();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getNamespaceURI(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlValue const *)arg1)->getNamespaceURI();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getPrefix(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlValue const *)arg1)->getPrefix();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getLocalName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlValue const *)arg1)->getLocalName();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jshort JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getNodeType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jshort jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  short result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (short)((XmlValue const *)arg1)->getNodeType();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jshort)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getParentNode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)XmlValue_getParentNode((XmlValue const *)arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getFirstChild(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)XmlValue_getFirstChild((XmlValue const *)arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getLastChild(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)XmlValue_getLastChild((XmlValue const *)arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getPreviousSibling(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)XmlValue_getPreviousSibling((XmlValue const *)arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getNextSibling(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)XmlValue_getNextSibling((XmlValue const *)arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getAttributes(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlValue_getAttributes((XmlValue const *)arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1getOwnerElement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlValue *arg1 = (XmlValue *) 0 ;
  XmlValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlValue *)XmlValue_getOwnerElement((XmlValue const *)arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlValue **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlValue_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  XmlValue *arg1 = 0 ;
  XmlValue *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlValue **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue & reference is null");
    return ;
  } 
  arg2 = *(XmlValue **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return ;
  } 
  {
    jthrowable t = NULL;
    try {
      XmlValue_setValue(*arg1,(XmlValue const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlIndexSpecification(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
      
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1addIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jint jarg4, jint jarg5) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  enum XmlIndexSpecification::Type arg4 ;
  enum XmlValue::Type arg5 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (enum XmlIndexSpecification::Type)jarg4; 
  arg5 = (enum XmlValue::Type)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addIndex((std::string const &)*arg2,(std::string const &)*arg3,arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1addIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1deleteIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jint jarg4, jint jarg5) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  enum XmlIndexSpecification::Type arg4 ;
  enum XmlValue::Type arg5 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (enum XmlIndexSpecification::Type)jarg4; 
  arg5 = (enum XmlValue::Type)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->deleteIndex((std::string const &)*arg2,(std::string const &)*arg3,arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1deleteIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->deleteIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1replaceIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jint jarg4, jint jarg5) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  enum XmlIndexSpecification::Type arg4 ;
  enum XmlValue::Type arg5 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (enum XmlIndexSpecification::Type)jarg4; 
  arg5 = (enum XmlValue::Type)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->replaceIndex((std::string const &)*arg2,(std::string const &)*arg3,arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1replaceIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->replaceIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1addDefaultIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  enum XmlIndexSpecification::Type arg2 ;
  enum XmlValue::Type arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  arg2 = (enum XmlIndexSpecification::Type)jarg2; 
  arg3 = (enum XmlValue::Type)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addDefaultIndex(arg2,arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1addDefaultIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addDefaultIndex((std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1deleteDefaultIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  enum XmlIndexSpecification::Type arg2 ;
  enum XmlValue::Type arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  arg2 = (enum XmlIndexSpecification::Type)jarg2; 
  arg3 = (enum XmlValue::Type)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->deleteDefaultIndex(arg2,arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1deleteDefaultIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->deleteDefaultIndex((std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1replaceDefaultIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  enum XmlIndexSpecification::Type arg2 ;
  enum XmlValue::Type arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  arg2 = (enum XmlIndexSpecification::Type)jarg2; 
  arg3 = (enum XmlValue::Type)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->replaceDefaultIndex(arg2,arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1replaceDefaultIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->replaceDefaultIndex((std::string const &)*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->reset();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1find(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  jobject jresult = 0 ;
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlIndexDeclaration *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexDeclaration *)XmlIndexSpecification_find(arg1,(std::string const &)*arg2,(std::string const &)*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  if (result == NULL)
  jresult = NULL;
  else {
    jresult = jenv->NewObject(xml_indexdecl_class, xml_indexdecl_construct,
      jenv->NewStringUTF(result->uri.c_str()),
      jenv->NewStringUTF(result->name.c_str()),
      jenv->NewStringUTF(result->index.c_str()));
    delete result;
  }
  
  return jresult;
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1next(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jobject jresult = 0 ;
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  XmlIndexDeclaration *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexDeclaration *)XmlIndexSpecification_next(arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  if (result == NULL)
  jresult = NULL;
  else {
    jresult = jenv->NewObject(xml_indexdecl_class, xml_indexdecl_construct,
      jenv->NewStringUTF(result->uri.c_str()),
      jenv->NewStringUTF(result->name.c_str()),
      jenv->NewStringUTF(result->index.c_str()));
    delete result;
  }
  
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1getDefaultIndex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlIndexSpecification const *)arg1)->getDefaultIndex();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1getValueType(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  enum XmlValue::Type result;
  
  (void)jenv;
  (void)jcls;
  
  const char *arg1_pstr = "";
  if(jarg1) {
    arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0);
  }
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  if (jarg1) {
    jenv->ReleaseStringUTFChars(jarg1, arg1_pstr);
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlValue::Type)XmlIndexSpecification::getValueType((std::string const &)*arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlQueryExpression(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = 0 ;
  XmlQueryExpression *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryExpression **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryExpression const & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (XmlQueryExpression *)new XmlQueryExpression((XmlQueryExpression const &)*arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlQueryExpression **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlQueryExpression(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
      
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1getQuery(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      {
        std::string const &_result_ref = ((XmlQueryExpression const *)arg1)->getQuery();
        result = (std::string *) &_result_ref;
      }
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1getQueryPlan(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlQueryExpression const *)arg1)->getQueryPlan();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1execute_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  u_int32_t arg3 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  arg2 = *(XmlQueryContext **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  arg3 = (u_int32_t)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryExpression_execute__SWIG_0((XmlQueryExpression const *)arg1,*arg2,arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1execute_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  arg2 = *(XmlQueryContext **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryExpression_execute__SWIG_0((XmlQueryExpression const *)arg1,*arg2);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1execute_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  XmlValue *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  u_int32_t arg4 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  arg2 = *(XmlValue **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  arg3 = *(XmlQueryContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryExpression_execute__SWIG_2((XmlQueryExpression const *)arg1,(XmlValue const &)*arg2,*arg3,arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1execute_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  XmlValue *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  arg2 = *(XmlValue **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  arg3 = *(XmlQueryContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryExpression_execute__SWIG_2((XmlQueryExpression const *)arg1,(XmlValue const &)*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1execute_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  u_int32_t arg4 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlQueryContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryExpression_execute__SWIG_4((XmlQueryExpression const *)arg1,*arg2,*arg3,arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1execute_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlQueryContext **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryExpression_execute__SWIG_4((XmlQueryExpression const *)arg1,*arg2,*arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1execute_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlValue *arg3 = 0 ;
  XmlQueryContext *arg4 = 0 ;
  u_int32_t arg5 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlValue **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  arg4 = *(XmlQueryContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  arg5 = (u_int32_t)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryExpression_execute__SWIG_6((XmlQueryExpression const *)arg1,*arg2,(XmlValue const &)*arg3,*arg4,arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1execute_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlValue *arg3 = 0 ;
  XmlQueryContext *arg4 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlValue **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue const & reference is null");
    return 0;
  } 
  arg4 = *(XmlQueryContext **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryContext & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryExpression_execute__SWIG_6((XmlQueryExpression const *)arg1,*arg2,(XmlValue const &)*arg3,*arg4);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlInputStream(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)new SwigDirector_XmlInputStream(jenv);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlInputStream(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlInputStream *arg1 = (XmlInputStream *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlInputStream **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
      
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlInputStream_1curPos(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlInputStream *arg1 = (XmlInputStream *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlInputStream **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (unsigned int)((XmlInputStream const *)arg1)->curPos();
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlInputStream_1readBytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jbyteArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  XmlInputStream *arg1 = (XmlInputStream *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlInputStream **)&jarg1; 
  {
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg2) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    arg2 = (char *) jenv->GetByteArrayElements(jarg2, 0); 
  }
  arg3 = (unsigned int)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (unsigned int)(arg1)->readBytes(arg2,arg3);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jlong)result; 
  {
    jenv->ReleaseByteArrayElements(jarg2, (jbyte *)arg2, 0); 
  }
  
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlInputStream_1freeMemory(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlInputStream *arg1 = (XmlInputStream *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlInputStream **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlInputStream_freeMemory(arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlInputStream_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  XmlInputStream *obj = *((XmlInputStream **)&objarg);
  (void)jcls;
  SwigDirector_XmlInputStream *director = (SwigDirector_XmlInputStream *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlInputStream_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  XmlInputStream *obj = *((XmlInputStream **)&objarg);
  SwigDirector_XmlInputStream *director = (SwigDirector_XmlInputStream *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlResolver(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  XmlResolver *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (XmlResolver *)new SwigDirector_XmlResolver(jenv);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResolver **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlResolver(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResolver **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
      
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jstring jarg4, jlong jarg5) {
  jboolean jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlValue *arg5 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = *(XmlValue **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlValue & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlResolver const *)arg1)->resolveDocument(arg2,*arg3,(std::string const &)*arg4,*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveCollection(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jstring jarg4, jlong jarg5) {
  jboolean jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlResults *arg5 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = *(XmlResults **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlResults & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlResolver const *)arg1)->resolveCollection(arg2,*arg3,(std::string const &)*arg4,*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveSchema(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)((XmlResolver const *)arg1)->resolveSchema(arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveEntity(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)((XmlResolver const *)arg1)->resolveEntity(arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveModuleLocation(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jstring jarg4, jlong jarg5) {
  jboolean jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlResults *arg5 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = *(XmlResults **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlResults & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlResolver const *)arg1)->resolveModuleLocation(arg2,*arg3,(std::string const &)*arg4,*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveModule(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)((XmlResolver const *)arg1)->resolveModule(arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  XmlResolver *obj = *((XmlResolver **)&objarg);
  (void)jcls;
  SwigDirector_XmlResolver *director = (SwigDirector_XmlResolver *)(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  XmlResolver *obj = *((XmlResolver **)&objarg);
  SwigDirector_XmlResolver *director = (SwigDirector_XmlResolver *)(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlModify(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  XmlModify *arg1 = 0 ;
  XmlModify *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlModify **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlModify const & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (XmlModify *)new XmlModify((XmlModify const &)*arg1);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlModify **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlModify(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlModify *arg1 = (XmlModify *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlModify **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
      
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlModify_1addInsertBeforeStep_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jstring jarg4, jstring jarg5) {
  XmlModify *arg1 = (XmlModify *) 0 ;
  XmlQueryExpression *arg2 = 0 ;
  enum XmlModify::XmlObject arg3 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlModify **)&jarg1; 
  arg2 = *(XmlQueryExpression **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryExpression const & reference is null");
    return ;
  } 
  arg3 = (enum XmlModify::XmlObject)jarg3; 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return ;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addInsertBeforeStep((XmlQueryExpression const &)*arg2,arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlModify_1addInsertBeforeStep_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jstring jarg4, jlong jarg5) {
  XmlModify *arg1 = (XmlModify *) 0 ;
  XmlQueryExpression *arg2 = 0 ;
  enum XmlModify::XmlObject arg3 ;
  std::string *arg4 = 0 ;
  XmlResults *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlModify **)&jarg1; 
  arg2 = *(XmlQueryExpression **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryExpression const & reference is null");
    return ;
  } 
  arg3 = (enum XmlModify::XmlObject)jarg3; 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = *(XmlResults **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlResults & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addInsertBeforeStep((XmlQueryExpression const &)*arg2,arg3,(std::string const &)*arg4,*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlModify_1addInsertAfterStep_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jstring jarg4, jstring jarg5) {
  XmlModify *arg1 = (XmlModify *) 0 ;
  XmlQueryExpression *arg2 = 0 ;
  enum XmlModify::XmlObject arg3 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlModify **)&jarg1; 
  arg2 = *(XmlQueryExpression **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryExpression const & reference is null");
    return ;
  } 
  arg3 = (enum XmlModify::XmlObject)jarg3; 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return ;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addInsertAfterStep((XmlQueryExpression const &)*arg2,arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    
    if (t) {
      jenv->Throw(t);
      return ;
    }
  }
}


JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlModify_1addInsertAfterStep_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jstring jarg4, jlong jarg5) {
  XmlModify *arg1 = (XmlModify *) 0 ;
  XmlQueryExpression *arg2 = 0 ;
  enum XmlModify::XmlObject arg3 ;
  std::string *arg4 = 0 ;
  XmlResults *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlModify **)&jarg1; 
  arg2 = *(XmlQueryExpression **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryExpression const & reference is null");
    return ;
  } 
  arg3 = (enum XmlModify::XmlObject)jarg3; 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = *(XmlResults **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlResults & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addInsertAfterStep((XmlQueryExpression const &)*arg2,arg3,(std::string const &)*arg4,*arg5);
    }
    catch (XmlException &xe) {
      // use 0 for dberr; otherwise, DatabaseException::toString
      // prints redundant information.  The DB error information
      // is already in the what() string.
      if (xe.getExceptionCode() == XmlException::NULL_POINTER) {
        // throw null pointer exception
        jenv->ThrowNew(np_class, xe.what());
      } else {
        jthrowable dt = 0;
        const char *msg = xe.what();
        XmlException::ExceptionCode ecode =
        xe.getExceptionCode();
        int qLine = xe.getQueryLine();
        int qCol = xe.getQueryColumn();
        if (ecode == XmlException::DATABASE_ERROR) {
          dt = __dbj_get_except(jenv, xe.getDbErrno(),
            msg, NULL, NULL);
        }
        t = (jthrowable)jenv->
        NewObject(xmlex_class, xmlex_construct,
          ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
      }
    }
    catch (DbException &de) {
      t = make_db_except(jenv, de.get_errno(),
        de.what(), NULL, NULL);
    }
    catch (std::exception &se) {
      std::string emsg = "std::exception thrown from C++ API: ";
      emsg += se.what();
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ER