%{

// turn off the warnings "switch statement contains 'default' but no 'case' labels"
//                       "'yyerrlab1' : unreferenced label"
#pragma warning(disable : 4065 4102)

#include "Scanner.hpp"

#include "xquery/XQQuery.hpp"
#include "xquery/functions/XQFunction.hpp"
#include "xquery/dataItem/XQDOMConstructor.hpp"
#include "xquery/dataItem/XQFLWOR.hpp"
#include "xquery/dataItem/XQQuantified.hpp"
#include "xquery/dataItem/XQTypeswitch.hpp"
#include "xquery/dataItem/XQValidate.hpp"
#include "xquery/dataItem/XQGlobalVariable.hpp"
#include "xquery/dataItem/XQDebugHook.hpp"
#include "xquery/dataItem/XQFunctionCall.hpp"
#include "xquery/dataItem/XQOrderingChange.hpp"

#include <xercesc/validators/schema/SchemaSymbols.hpp>
#include <xercesc/dom/DOMXPathNamespace.hpp>
#include <xercesc/dom/DOMNode.hpp>

#include <pathan/AnyAtomicTypeConstructor.hpp>

#include <pathan/dataItem/DataItemSequence.hpp>
#include <pathan/dataItem/DataItemParenthesizedExpr.hpp>
#include <pathan/dataItem/DataItemNav.hpp>
#include <pathan/dataItem/DataItemStep.hpp>
#include <pathan/dataItem/DataItemLiteral.hpp>
#include <pathan/dataItem/DataItemVariable.hpp>
#include <pathan/dataItem/DataItemQuantifiedExpr.hpp>
#include <pathan/dataItem/DataItemInstanceOf.hpp>
#include <pathan/dataItem/DataItemCastAs.hpp>
#include <pathan/dataItem/DataItemCastableAs.hpp>
#include <pathan/dataItem/DataItemTreatAs.hpp>
#include <pathan/dataItem/DataItemIf.hpp>
#include <pathan/dataItem/DataItemContextItem.hpp>

#include <pathan/internal/parser/QName.hpp>

#include <pathan/operators/Equals.hpp>
#include <pathan/operators/GeneralComp.hpp>
#include <pathan/operators/NotEquals.hpp>
#include <pathan/operators/LessThan.hpp>
#include <pathan/operators/GreaterThan.hpp>
#include <pathan/operators/LessThanEqual.hpp>
#include <pathan/operators/GreaterThanEqual.hpp>
#include <pathan/operators/Plus.hpp>
#include <pathan/operators/Minus.hpp>
#include <pathan/operators/Multiply.hpp>
#include <pathan/operators/Divide.hpp>
#include <pathan/operators/IntegerDivide.hpp>
#include <pathan/operators/Mod.hpp>
#include <pathan/operators/UnaryMinus.hpp>
#include <pathan/operators/NodeComparison.hpp>
#include <pathan/operators/OrderComparison.hpp>
#include <pathan/operators/Intersect.hpp>
#include <pathan/operators/Except.hpp>
#include <pathan/operators/Union.hpp>
#include <pathan/operators/Or.hpp>
#include <pathan/operators/And.hpp>
#include <pathan/operators/Range.hpp>

#include <pathan/internal/navigation/ChildAxis.hpp>
#include <pathan/internal/navigation/DescendantAxis.hpp>
#include <pathan/internal/navigation/AttributeAxis.hpp>
#include <pathan/internal/navigation/SelfAxis.hpp>
#include <pathan/internal/navigation/DescendantOrSelfAxis.hpp>
#include <pathan/internal/navigation/ParentAxis.hpp>
#include <pathan/internal/navigation/FollowingSiblingAxis.hpp>
#include <pathan/internal/navigation/FollowingAxis.hpp>
#include <pathan/internal/navigation/AncestorAxis.hpp>
#include <pathan/internal/navigation/PrecedingSiblingAxis.hpp>
#include <pathan/internal/navigation/PrecedingAxis.hpp>
#include <pathan/internal/navigation/AncestorOrSelfAxis.hpp>

#include <pathan/SequenceType.hpp>
#include <pathan/exceptions/NamespaceLookupException.hpp>

#include <pathan/XPath2Utils.hpp>

#define YYPARSE_PARAM qp
#define YYDEBUG 1
#define YYERROR_VERBOSE

#define QP						((XQueryParserArgs*)qp)
#define CONTEXT					(QP->_context)
#define MEMMGR					(CONTEXT->getMemoryManager())
#define WRAP(pos,object)		(wrapForDebug((QP),(object),NULL  ,(pos).first_line, (pos).first_column))
#define FNWRAP(pos,name,object)	(wrapForDebug((QP),(object),(name),(pos).first_line, (pos).first_column))

#undef yylex
#define yylex QP->_scanner->yylex
#undef yyerror
#define yyerror QP->_scanner->error

static XMLCh szQuote[]=		 { XERCES_CPP_NAMESPACE_QUALIFIER chDoubleQuote, XERCES_CPP_NAMESPACE_QUALIFIER chNull };
static XMLCh szApos[]=		 { XERCES_CPP_NAMESPACE_QUALIFIER chDoubleQuote, XERCES_CPP_NAMESPACE_QUALIFIER chNull };
static XMLCh szCurlyOpen[]=  { XERCES_CPP_NAMESPACE_QUALIFIER chOpenCurly, XERCES_CPP_NAMESPACE_QUALIFIER chNull };
static XMLCh szCurlyClose[]= { XERCES_CPP_NAMESPACE_QUALIFIER chCloseCurly, XERCES_CPP_NAMESPACE_QUALIFIER chNull };
static XMLCh szFLWOR[] =     { XERCES_CPP_NAMESPACE_QUALIFIER chLatin_F, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_L, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_W,
                               XERCES_CPP_NAMESPACE_QUALIFIER chLatin_O, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_R, XERCES_CPP_NAMESPACE_QUALIFIER chNull };

static inline bool isAllSpaces(const XMLCh* str)
{
	while(*str)
	{
		if(*str!='\r' && *str != '\n' && *str != ' ' && *str != '\t')
			return false;
		str++;
	}
	return true;
}

static inline DataItemNav* getNavigation(DataItem *possibleNav, XPath2MemoryManager * expr)
{
	DataItem* originalObj=possibleNav;
	if((unsigned int)possibleNav->getType()==XQContext::DEBUG_HOOK)
		possibleNav=((XQDebugHook*)possibleNav)->m_impl;
	if(possibleNav->getType()==DataItem::NAVIGATION)
		return (DataItemNav*)possibleNav;
	else
	{
		DataItemNav* nav=new (expr) DataItemNav(expr);
		nav->addStep(originalObj);
		return nav;
	}
}

static inline VectorOfDataItems packageArgs(DataItem *arg1Impl, DataItem *arg2Impl, XPath2MemoryManager* memMgr)
{
	VectorOfDataItems args=VectorOfDataItems(2,(DataItem*)NULL,PathanAllocator<DataItem*>(memMgr));
	args[0]=arg1Impl;
	args[1]=arg2Impl;

	return args;
}

static void merge_strings(DynamicContext* context, VectorOfDataItems* vec, XMLCh* toBeAdded)
{
	if(vec->size()>0 && vec->back()->getType()==DataItem::LITERAL)
	{
    DataItemLiteral *lit = (DataItemLiteral*)vec->back();
		const XMLCh* string=lit->getItemConstructor()->createItem(context)->asString(context);
		string=XPath2Utils::concatStrings(string,toBeAdded,context->getMemoryManager());

    AnyAtomicTypeConstructor *ic = new (context->getMemoryManager())
      AnyAtomicTypeConstructor(
						XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
						XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
				string);
    lit->setItemConstructor(ic);
	}
	else
	{
    AnyAtomicTypeConstructor *ic = new (context->getMemoryManager())
      AnyAtomicTypeConstructor(
						XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
						XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
				toBeAdded);

		vec->push_back(new (context->getMemoryManager())
                   DataItemLiteral(ic, context->getMemoryManager()));
	}
}

//imports the data in step 2 into step1
static void importStep(NavStepImpl *step1, NavStepImpl *step2)
{
  if(step2->getPrefixSet()) {
    step1->setNodePrefix(step2->getNodePrefix());
  }
  else {
    step1->setNodeUri(step2->getNodeUri());
  }
	step1->setNodeName(step2->getNodeName());
	step1->setType(step2->getType());
	step2->setType(NULL);

	if(step2->getNameWildcard())
		step1->setNameWildcard();
	if(step2->getNamespaceWildcard())
		step1->setNamespaceWildcard();
	if(step2->getTypeWildcard())
		step1->setTypeWildcard();
}

static DataItem* wrapForDebug(XQueryParserArgs *qp, DataItem* pObjToWrap,
                              const XMLCh* fnName, unsigned int line, unsigned int column)
{
  if(!CONTEXT->getDebugCallback())
    return pObjToWrap;
  if(fnName==NULL && (unsigned int)pObjToWrap->getType()==XQContext::DEBUG_HOOK)
    return pObjToWrap;
  return new (MEMMGR) XQDebugHook(QP->_query->getFile(), line, column, pObjToWrap, fnName, MEMMGR);
}

namespace XQuery {

%}

/* this gives a nice name to the $end token */
%token MYEOF 0										"<end of file>"

/* str */
%token <str> _QNAME_								"<qualified name>"
%token <str> _FUNCTION_CALL_						"<function>("
%token <str> _TAG_NAME_								"<tag name>"
%token <str> _ATTRIBUTE_NAME_						"<attribute name>"
%token <str> _STRING_LITERAL_						"'...'"
%token <str> _VARIABLE_								"<variable name>"
%token <str> _CHAR_									"<char>"
%token <str> _CHAR_REF_								"&#XXX;"
%token <str> _PREDEFINED_ENTITY_REF_				"<predefined entity ref>"
%token <str> _NCNAME_COLON_STAR_					"<ns>:*"
%token <str> _STAR_COLON_NCNAME_					"*:<local name>"
%token <str> _NCNAME_								"<local name>"
%token <str> _PI_TARGET_							"<processing instruction target>"
%token <str> _NAMED_ATTRIBUTE_CONSTR_				"attribute <name> {"
%token <str> _NAMED_ELEMENT_CONSTR_					"element <name> {"
%token <str> _INTEGER_NUMBER_						"<integer number>"
%token <str> _DECIMAL_NUMBER_						"<decimal number>"
%token <str> _DOUBLE_NUMBER_						"<double number>"
%token <str> _AT_LITERAL_							"at ..."
%token <str> _XQUERY_VERSION_						"xquery version <ver>"
%token <str> _XML_COMMENT_							"<!-- ... -->"
%token <str> _CDATA_SECTION_						"<![CDATA[...]]>"
%token <str> _PROCESSING_INSTRUCTION_CONTENT_		"...?>"
%token <str> _NAMED_NAMESPACE_CONSTR_				"namespace <ns> {"
%token <str> _NAMED_PROCESSING_INSTRUCTION_CONSTR_  "processing-instruction <pi> {"

/* tok */
%token _XQUERY_COMMENT_					"(: comment :)"
%token _XQUERY_WHITESPACE_
%token _XQUERY_ERROR_
%token _XQUERY_PRAGMA_					"(:: pragma ::)"
%token _ESCAPE_APOS_					"\\'"
%token _ESCAPE_QUOT_					"\\\""
%token _COMMA_							","
%token _RETURN_							"return"
%token _FOR_							"for $"
%token _IN_								"in"
%token _DOLLAR_SIGN_					"$"
%token _AT_KEYWORD_						"at"
%token _LET_							"let $"
%token _COLON_EQ_						":="
%token _WHERE_							"where"
%token _ORDER_BY_						"order by"
%token _STABLE_ORDER_BY_				"stable order by"
%token _ASCENDING_						"ascending"
%token _DESCENDING_						"descending"
%token _EMPTY_GREATEST_					"empty greatest"
%token _EMPTY_LEAST_					"empty least"
%token _COLLATION_						"collation"
%token _SOME_							"some $"
%token _EVERY_							"every $"
%token _SATISFIES_						"satisfies"
%token _TYPESWITCH_						"typeswitch("
%token _DEFAULT_						"default"
%token _CASE_							"case"
%token _AS_								"as"
%token _IF_								"if("
%token _THEN_							"then"
%token _ELSE_							"else"
%token _OR_								"or"
%token _AND_							"and"
%token _INSTANCE_OF_					"instance of"
%token _CASTABLE_AS_					"castable as"
%token _TO_								"to"
%token _PLUS_							"+ (arithmetic operator)"
%token _MINUS_							"- (arithmetic operator)"
%token _MULTIPLY_						"* (arithmetic operator)"
%token _DIV_							"div"
%token _INTEGER_DIV_					"idiv"
%token _MOD_							"mod"
%token _UNION_							"union"
%token _VERTICAL_BAR_					"|"
%token _INTERSECT_						"intersect"
%token _EXCEPT_							"except"
%token _SLASH_							"/"
%token _SLASHSLASH_						"//"
%token _LBRACK_							"["
%token _RBRACK_							"]"
%token _VALIDATE_CONTENT_				"validate {"
%token _VALIDATE_MODE_LAX_				"validate lax"
%token _VALIDATE_MODE_STRICT_			"validate strict"
%token _CAST_AS_						"cast as"
%token _TREAT_AS_						"treat as"
%token _EQUALS_							"= (comparison operator)"
%token _NOT_EQUALS_						"!="
%token _LT_								"< (comparison operator)"
%token _LT_EQUALS_						"<="
%token _GT_								"> (comparison operator)"
%token _GT_EQUALS_						">="
%token _FORTRAN_EQ_						"eq"
%token _FORTRAN_NE_						"ne"
%token _FORTRAN_LT_						"lt"
%token _FORTRAN_LE_						"le"
%token _FORTRAN_GT_						"gt"
%token _FORTRAN_GE_						"ge"
%token _IS_								"is"
%token _LT_LT_							"<<"
%token _GT_GT_							">>"
%token _DOT_							"."
%token _AT_								"@"
%token _DOT_DOT_						".."
%token _AXIS_CHILD_						"child::"
%token _AXIS_DESCENDANT_				"descendant::"
%token _AXIS_ATTRIBUTE_					"attribute::"
%token _AXIS_SELF_						"self::"
%token _AXIS_DESCENDANT_OR_SELF_		"descendant-or-self::"
%token _AXIS_PARENT_					"parent::"
%token _STAR_							"* (wildcard)"
%token _PROCESSING_INSTRUCTION_LPAR_	"processing-instruction("
%token _COMMENT_LPAR_					"comment("
%token _TEXT_LPAR_						"text("
%token _NODE_LPAR_						"node("
%token _LPAR_							"("
%token _RPAR_							")"
%token _START_TAG_OPEN_					"<"
%token _EMPTY_TAG_CLOSE_				"/>"
%token _VALUE_INDICATOR_				"="
%token _END_TAG_OPEN_					">"
%token _TAG_CLOSE_						"</"
%token _DOCUMENT_CONSTR_				"document {"
%token _ELEMENT_CONSTR_					"element {"
%token _ATTRIBUTE_CONSTR_				"attribute {"
%token _TEXT_CONSTR_					"text {"
%token _PROCESSING_INSTRUCTION_START_	"<?"
%token _LCURLY_BRACE_ESCAPE_			"{{"
%token _RCURLY_BRACE_ESCAPE_			"}}"
%token _OPEN_QUOT_						"\" (open)"
%token _CLOSE_QUOT_						"\" (close)"
%token _OPEN_APOS_						"' (open)"
%token _CLOSE_APOS_						"' (close)"
%token _LBRACE_							"{"
%token _RBRACE_							"}"
%token _DECLARE_XMLSPACE_				"declare xmlspace"
%token _PRESERVE_						"preserve (xmlspace)"
%token _STRIP_							"strip (xmlspace)"
%token _DECLARE_DEFAULT_COLLATION_		"declare default collation"
%token _DECLARE_NAMESPACE_				"declare namespace"
%token _DECLARE_DEFAULT_ELEMENT_		"declare default element"
%token _DECLARE_DEFAULT_FUNCTION_		"declare default function"
%token _NAMESPACE_						"namespace"
%token _DECLARE_FUNCTION_				"declare function"
%token _EXPR_AS_						") as"
%token _EMPTY_							"empty()"
%token _ITEM_							"item()"
%token _NILLABLE_						"?"
%token _IMPORT_SCHEMA_					"import schema"
%token _IMPORT_MODULE_					"import module"
%token _DECLARE_VARIABLE_				"declare variable $"
%token _DOCUMENT_NODE_LPAR_				"document-node("
%token _ATTRIBUTE_LPAR_					"attribute("
%token _ELEMENT_LPAR_					"element("
%token _EXTERNAL_						"external"
%token _DECLARE_BASEURI_				"declare base-uri"
%token _MODULE_NAMESPACE_				"module namespace"
%token _PROCESSING_INSTRUCTION_CONSTR_	"processing-instruction {"
%token _COMMENT_CONSTR_					"comment {"
%token _AXIS_ANCESTOR_OR_SELF_			"ancestor-or-self::"
%token _AXIS_ANCESTOR_					"ancestor::"
%token _AXIS_FOLLOWING_SIBLING_			"following-sibling::"
%token _AXIS_FOLLOWING_					"following::"
%token _AXIS_PRECEDING_SIBLING_			"preceding-sibling::"
%token _AXIS_PRECEDING_					"preceding::"
%token _SEMICOLON_						";"
%token _DEFAULT_ELEMENT_				"default element"
%token _DECLARE_CONSTRUCTION_			"declare construction"
%token _DECLARE_ORDERING_				"declare ordering"
%token _SCHEMA_ELEMENT_LPAR_			"schema-element("
%token _SCHEMA_ATTRIBUTE_LPAR_			"schema-attribute("
%token _ORDERED_						"ordered {"
%token _UNORDERED_						"unordered {"
%token _CONSTRUCTION_PRESERVE_			"preserve (construction)"
%token _CONSTRUCTION_STRIP_				"strip (construction)"
%token _ORDERING_UNORDERED_				"unordered"
%token _ORDERING_ORDERED_				"ordered"
%token _ZERO_OR_ONE_					"? (occurrence)"
%token _ONE_OR_MORE_					"+ (occurrence)"
%token _ZERO_OR_MORE_					"* (occurrence)"
%token _EOF_

%type <functDecl>			FunctionDecl
%type <funcParam>			Param
%type <funcParams>			ParamList
%type <dataItem>			Expr ExprSingle OrExpr AndExpr EnclosedExpr FLWORExpr IfExpr ComparisonExpr DecimalLiteral VarRef
%type <dataItem>			RangeExpr AdditiveExpr MultiplicativeExpr UnionExpr QuantifiedExpr StringLiteral Literal ContextItemExpr
%type <dataItem>			UnaryExpr ValidateExpr CastExpr TreatExpr IntersectExceptExpr ParenthesizedExpr PrimaryExpr FunctionCall
%type <dataItem>			RelativePathExpr StepExpr AxisStep FilterExpr TypeswitchExpr ValueExpr PathExpr NumericLiteral IntegerLiteral
%type <dataItem>			CastableExpr Constructor ComputedConstructor DirElemConstructor DirCommentConstructor DirPIConstructor
%type <dataItem>			CompElemConstructor CompTextConstructor CompPIConstructor CompCommentConstructor LocalNamespaceDecl OrderedExpr UnorderedExpr
%type <dataItem>			CompAttrConstructor WhereClause CompDocConstructor DoubleLiteral InstanceofExpr DirectConstructor CompElemBody CompElemBodyItem
%type <itemList>			DirElementContent DirAttributeList QuotAttrValueContent AposAttrValueContent DirAttributeValue PredicateList FunctionCallArgumentList
%type <navStep>				ForwardAxis ReverseAxis NodeTest NameTest KindTest AbbrevForwardStep AbbrevReverseStep AttributeTest SchemaAttributeTest
%type <navStep>				ForwardStep ReverseStep Wildcard PITest CommentTest TextTest AnyKindTest ElementTest DocumentTest SchemaElementTest
%type <qName>				QName AtomicType TypeName ElementName AttributeName ElementNameOrWildcard AttribNameOrWildcard AttributeDeclaration ElementDeclaration
%type <sequenceType>		SequenceType TypeDeclaration SingleType
%type <occurrence>			OccurrenceIndicator
%type <itemType>			ItemType
%type <variableBinding>		ForBinding LetBinding QuantifyBinding
%type <variableBindingList> FlworExprForLetList ForOrLetClause ForClause LetClause ForBindingList LetBindingList QuantifyBindingList
%type <clause>				CaseClause
%type <clauseList>			CaseClauseList
%type <sortModifier>		OrderDirection EmptyHandling
%type <sortSpecList>		OrderSpecList
%type <sortSpec>			OrderSpec
%type <sort>				OrderByClause
%type <stringList>			ResourceLocations
%type <str>					PositionalVar SchemaPrefix CommonContent CdataSection

%start Module

%pure_parser

%%

// Parser rules go here.

// [1]    Module    ::=      VersionDecl? (MainModule | LibraryModule)
Module:
	VersionDecl MainModule
	| VersionDecl LibraryModule
	| MainModule
	| LibraryModule
	;

// [2]    VersionDecl    ::=    <"xquery" "version" StringLiteral> Separator
VersionDecl:
	_XQUERY_VERSION_ Separator
	{
		static XMLCh sz1_0[]={ XERCES_CPP_NAMESPACE_QUALIFIER chDigit_1, XERCES_CPP_NAMESPACE_QUALIFIER chDigit_0, XERCES_CPP_NAMESPACE_QUALIFIER chNull };
		if(XPath2Utils::equals($1,sz1_0))
			yyerror("This XQuery processor only support version 1.0 of the specs");
	}
	;

// [3]    MainModule    ::=    Prolog QueryBody
MainModule:
	Prolog QueryBody
	{
	}
	;

// [4]    LibraryModule    ::=    ModuleDecl Prolog
LibraryModule:
	ModuleDecl Prolog
	{
	}
	;

// [5]    ModuleDecl    ::=    <"module" "namespace"> NCName "=" StringLiteral Separator
ModuleDecl:
	_MODULE_NAMESPACE_ _NCNAME_ _EQUALS_ _STRING_LITERAL_ Separator
	{
		QP->_query->setIsLibraryModule();
		QP->_query->setModuleTargetNamespace($4);
		CONTEXT->setNamespaceBinding($2,$4);
	}
	;

// [6]    Prolog    ::=    (Setter Separator)* ((  Import
//												 | NamespaceDecl
//												 | VarDecl
//												 | FunctionDecl
//												) Separator)*
Prolog:
	Setters Declarations
	;

Setters:
	/* empty */
	| Setters Setter Separator
;

Declarations:
	/* empty */
	| Declarations Import Separator
	| Declarations NamespaceDecl Separator
	| Declarations VarDecl Separator
	| Declarations FunctionDecl Separator
	{
		XQFunction* decl=$2;
		CONTEXT->addCustomFunction(decl);
		QP->_query->addFunction(decl);
	}
;

// [7]    Setter    ::=   XMLSpaceDecl
//						| DefaultCollationDecl
//						| BaseURIDecl
//						| ConstructionDecl
//						| DefaultNamespaceDecl
//						| DefaultOrderingDecl
Setter:
	XMLSpaceDecl
	| DefaultCollationDecl
	| BaseURIDecl
	| ConstructionDecl
	| DefaultNamespaceDecl
	| DefaultOrderingDecl
;

// [8]    Import    ::=    SchemaImport | ModuleImport
Import:
	SchemaImport
	| ModuleImport
;

// [9]    Separator    ::=    ";"
Separator:
	_SEMICOLON_
	;

// [10]    NamespaceDecl    ::=    <"declare" "namespace"> NCName "=" StringLiteral
NamespaceDecl:
	  _DECLARE_NAMESPACE_ _NCNAME_ _EQUALS_ _STRING_LITERAL_
		{
			if(XERCES_CPP_NAMESPACE_QUALIFIER XMLString::stringLen($4)==0)
				yyerror("The namespace URI must not be an empty string");
			CONTEXT->setNamespaceBinding($2,$4);
		}
	;

// [11]    XMLSpaceDecl    ::=    <"declare" "xmlspace"> ("preserve" |  "strip")
XMLSpaceDecl:
	  _DECLARE_XMLSPACE_ _PRESERVE_
		{
			CONTEXT->setPreserveXMLSpace(true);
		}
	| _DECLARE_XMLSPACE_ _STRIP_
		{
			CONTEXT->setPreserveXMLSpace(false);
		}
	;

// [12]    DefaultNamespaceDecl    ::=    (<"declare" "default" "element"> |  <"declare" "default" "function">) "namespace" StringLiteral
DefaultNamespaceDecl:
	  _DECLARE_DEFAULT_ELEMENT_ _NAMESPACE_ _STRING_LITERAL_
		{
			CONTEXT->setDefaultElementAndTypeNS($3);
		}
	| _DECLARE_DEFAULT_FUNCTION_ _NAMESPACE_ _STRING_LITERAL_
		{
			CONTEXT->setDefaultFuncNS($3);
		}
	;

// [13]    DefaultOrderingDecl    ::=    <"declare" "ordering"> ("ordered" | "unordered")
DefaultOrderingDecl:
	_DECLARE_ORDERING_ _ORDERING_ORDERED_
	{
		CONTEXT->setNodeSetOrdering(StaticContext::ORDERING_ORDERED);
	}
	| _DECLARE_ORDERING_ _ORDERING_UNORDERED_
	{
		CONTEXT->setNodeSetOrdering(StaticContext::ORDERING_UNORDERED);
	}
	;

// [14]    DefaultCollationDecl    ::=    <"declare" "default" "collation"> StringLiteral
DefaultCollationDecl:
		_DECLARE_DEFAULT_COLLATION_ _STRING_LITERAL_
		{
			CONTEXT->setDefaultCollation($2);
		}
	  ;

// [15]    BaseURIDecl    ::=    <"declare" "base-uri"> StringLiteral
BaseURIDecl:
		_DECLARE_BASEURI_ _STRING_LITERAL_
		{
			CONTEXT->setBaseURI($2);
		}
	  ;

// [16]    SchemaImport    ::=    <"import" "schema"> SchemaPrefix? StringLiteral (<"at" StringLiteral> ("," StringLiteral)*)?
SchemaImport:
        _IMPORT_SCHEMA_ SchemaPrefix _STRING_LITERAL_
		{
			CONTEXT->setNamespaceBinding($2,$3);
			CONTEXT->addSchemaLocation($3,NULL);
		}
	  | _IMPORT_SCHEMA_ SchemaPrefix _STRING_LITERAL_ ResourceLocations
		{
			CONTEXT->addSchemaLocation($3,$4);
			CONTEXT->setNamespaceBinding($2,$3);
		}
	  | _IMPORT_SCHEMA_ _STRING_LITERAL_
		{
			CONTEXT->addSchemaLocation($2,NULL);
		}
	  | _IMPORT_SCHEMA_ _STRING_LITERAL_ ResourceLocations
		{
			CONTEXT->addSchemaLocation($2,$3);
		}
	  ;

ResourceLocations:
	_AT_LITERAL_
	{
		$$ = new (MEMMGR) VectorOfStrings(PathanAllocator<const XMLCh*>(MEMMGR));
		$$->push_back($1);
	}
	| ResourceLocations _COMMA_ _STRING_LITERAL_
	{
		$1->push_back($3);
		$$ = $1;
	}
;

// [17]    SchemaPrefix    ::=    ("namespace" NCName "=") |  (<"default" "element"> "namespace" "=")
SchemaPrefix:
	  _NAMESPACE_ _NCNAME_ _EQUALS_
		{
			$$ = $2;
		}
	| _DEFAULT_ELEMENT_ _NAMESPACE_ _EQUALS_
		{
			$$ = (unsigned short*)XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString;
		}
	;

// [18]    ModuleImport    ::=    <"import" "module"> ("namespace" NCName "=")? StringLiteral (<"at" StringLiteral> ("," StringLiteral)*)?
ModuleImport:
	_IMPORT_MODULE_ _NAMESPACE_ _NCNAME_ _EQUALS_ _STRING_LITERAL_ ResourceLocations
	{
		CONTEXT->setNamespaceBinding($3,$5);
		QP->_query->importModule($5,$6,CONTEXT);
	}
	| _IMPORT_MODULE_ _NAMESPACE_ _NCNAME_ _EQUALS_ _STRING_LITERAL_
	{
		yyerror("Cannot locate module without the 'at <location>' keyword");
	}
	| _IMPORT_MODULE_ _STRING_LITERAL_ ResourceLocations
	{
		QP->_query->importModule($2,$3,CONTEXT);
	}
	| _IMPORT_MODULE_ _STRING_LITERAL_
	{
		yyerror("Cannot locate module without the 'at <location>' keyword");
	}
	;

// [19]    VarDecl    ::=    <"declare" "variable" "$"> VarName TypeDeclaration? ((":=" ExprSingle) | "external")
VarDecl:
	_DECLARE_VARIABLE_ _VARIABLE_ TypeDeclaration _COLON_EQ_ ExprSingle
	{
		XQGlobalVariable* var=new (MEMMGR) XQGlobalVariable($2,$3,$5,MEMMGR);
		QP->_query->addVariable(var);
	}
	| _DECLARE_VARIABLE_ _VARIABLE_ _COLON_EQ_ ExprSingle
	{
		XQGlobalVariable* var=new (MEMMGR) XQGlobalVariable($2,new (MEMMGR) SequenceType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_ANYTHING), SequenceType::STAR),$4,MEMMGR);
		QP->_query->addVariable(var);
	}
	| _DECLARE_VARIABLE_ _VARIABLE_ TypeDeclaration _EXTERNAL_
	{
		XQGlobalVariable* var=new (MEMMGR) XQGlobalVariable($2,$3,NULL,MEMMGR);
		QP->_query->addVariable(var);
	}
	| _DECLARE_VARIABLE_ _VARIABLE_ _EXTERNAL_
	{
		XQGlobalVariable* var=new (MEMMGR) XQGlobalVariable($2,new (MEMMGR) SequenceType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_ANYTHING), SequenceType::STAR),NULL,MEMMGR);
		QP->_query->addVariable(var);
	}
	;

// [20]    ConstructionDecl    ::=    <"declare" "construction"> ("preserve" | "strip")
ConstructionDecl:
	_DECLARE_CONSTRUCTION_ _CONSTRUCTION_PRESERVE_
	{
		CONTEXT->setConstructionMode(XQStaticContext::CONSTRUCTION_MODE_PRESERVE);
	}
	| _DECLARE_CONSTRUCTION_ _CONSTRUCTION_STRIP_
	{
		CONTEXT->setConstructionMode(XQStaticContext::CONSTRUCTION_MODE_STRIP);
	}
	;

// [21]    FunctionDecl    ::=    <"declare" "function"> <QName "("> ParamList? (")" |  (<")" "as"> SequenceType))
//										(EnclosedExpr | "external")
FunctionDecl:
	  _DECLARE_FUNCTION_ _FUNCTION_CALL_ ParamList _RPAR_ EnclosedExpr
		{
			$$ = new (MEMMGR) XQFunction($2,$3,$5,NULL, MEMMGR);
			$$->setURI(CONTEXT->getUriBoundToPrefix($$->getPrefix()));
		}
	| _DECLARE_FUNCTION_ _FUNCTION_CALL_ _RPAR_ EnclosedExpr
		{
			$$ = new (MEMMGR) XQFunction($2,NULL,$4,NULL, MEMMGR);
			$$->setURI(CONTEXT->getUriBoundToPrefix($$->getPrefix()));
		}
	| _DECLARE_FUNCTION_ _FUNCTION_CALL_ ParamList _EXPR_AS_ SequenceType EnclosedExpr
		{
			$$ = new (MEMMGR) XQFunction($2,$3,$6,$5, MEMMGR);
			$$->setURI(CONTEXT->getUriBoundToPrefix($$->getPrefix()));
		}
	| _DECLARE_FUNCTION_ _FUNCTION_CALL_ _EXPR_AS_ SequenceType EnclosedExpr
		{
			$$ = new (MEMMGR) XQFunction($2,NULL,$5,$4, MEMMGR);
			$$->setURI(CONTEXT->getUriBoundToPrefix($$->getPrefix()));
		}
	| _DECLARE_FUNCTION_ _FUNCTION_CALL_ ParamList _RPAR_ _EXTERNAL_
		{
			$$ = new (MEMMGR) XQFunction($2,$3,NULL,NULL, MEMMGR);
			$$->setURI(CONTEXT->getUriBoundToPrefix($$->getPrefix()));
		}
	| _DECLARE_FUNCTION_ _FUNCTION_CALL_ _RPAR_ _EXTERNAL_
		{
			$$ = new (MEMMGR) XQFunction($2,NULL,NULL,NULL, MEMMGR);
			$$->setURI(CONTEXT->getUriBoundToPrefix($$->getPrefix()));
		}
	| _DECLARE_FUNCTION_ _FUNCTION_CALL_ ParamList _EXPR_AS_ SequenceType _EXTERNAL_
		{
			$$ = new (MEMMGR) XQFunction($2,$3,NULL,$5, MEMMGR);
			$$->setURI(CONTEXT->getUriBoundToPrefix($$->getPrefix()));
		}
	| _DECLARE_FUNCTION_ _FUNCTION_CALL_ _EXPR_AS_ SequenceType _EXTERNAL_
		{
			$$ = new (MEMMGR) XQFunction($2,NULL,NULL,$4, MEMMGR);
			$$->setURI(CONTEXT->getUriBoundToPrefix($$->getPrefix()));
		}
	;

// [22]    ParamList    ::=    Param ("," Param)*
ParamList:
        ParamList _COMMA_ Param
		{
			$1->push_back($3);
			$$ = $1;
		}
      | Param
		{
			XQFunction::VectorOfFunctionParameters* paramList = new (MEMMGR) XQFunction::VectorOfFunctionParameters(PathanAllocator<XQFunction::XQFunctionParameter*>(MEMMGR));
			paramList->push_back($1);
			$$ = paramList;
		}
      ;

// [23]    Param    ::=    "$" VarName TypeDeclaration?
Param:
        _DOLLAR_SIGN_ _VARIABLE_ TypeDeclaration
		{
			$$ = new (MEMMGR) XQFunction::XQFunctionParameter($2,$3,MEMMGR);
		}
	  | _DOLLAR_SIGN_ _VARIABLE_
		{
			$$ = new (MEMMGR) XQFunction::XQFunctionParameter($2,new (MEMMGR) SequenceType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_ANYTHING), SequenceType::STAR) ,MEMMGR);
		}
      ;

// [24]    EnclosedExpr    ::=    "{" Expr "}"
EnclosedExpr:
		_LBRACE_ Expr _RBRACE_
		{
			$$ = WRAP(@2, $2);
		}
      ;

// [25]    QueryBody    ::=    Expr
QueryBody:
	Expr
	{
	    QP->_query->setQueryBody($1);
	}
	;

// [26]    Expr    ::=    ExprSingle ("," ExprSingle)*
Expr:
		Expr _COMMA_ ExprSingle
		{
			DataItem* prevExpr=$1;
			if((unsigned int)prevExpr->getType()==XQContext::DEBUG_HOOK)
				prevExpr=((XQDebugHook*)prevExpr)->m_impl;
			if(prevExpr->getType()==DataItem::PARENTHESIZED)
			{
				((DataItemParenthesizedExpr *)prevExpr)->addItem($3);
				$$ = $1;
			}
			else
			{
				DataItemParenthesizedExpr *dis = new (MEMMGR) DataItemParenthesizedExpr(MEMMGR);
				dis->addItem($1);
				dis->addItem($3);
				$$ = dis;
			}
		}
	  | ExprSingle
		{
			$$ = $1;
		}
	  ;

// [27]     ExprSingle    ::=    FLWORExpr |  QuantifiedExpr |  TypeswitchExpr |  IfExpr |  OrExpr
ExprSingle:
		FLWORExpr
	  | QuantifiedExpr
	  | TypeswitchExpr
	  | IfExpr
	  | OrExpr
	  ;

// [28]    FLWORExpr    ::=    (ForClause |  LetClause)+ WhereClause? OrderByClause? "return" ExprSingle
FLWORExpr:
	    FlworExprForLetList WhereClause OrderByClause _RETURN_ ExprSingle
		{
			$$ = FNWRAP(@1, szFLWOR, new (MEMMGR) XQFLWOR($1, $2, $3, WRAP(@4, $5), MEMMGR));
		}
	  | FlworExprForLetList WhereClause _RETURN_ ExprSingle
		{
			$$ = FNWRAP(@1, szFLWOR, new (MEMMGR) XQFLWOR($1, $2, NULL, WRAP(@3, $4), MEMMGR));
		}
	  | FlworExprForLetList OrderByClause _RETURN_ ExprSingle
		{
			$$ = FNWRAP(@1, szFLWOR, new (MEMMGR) XQFLWOR($1, NULL, $2, WRAP(@3, $4), MEMMGR));
		}
	  | FlworExprForLetList _RETURN_ ExprSingle
		{
			$$ = FNWRAP(@1, szFLWOR, new (MEMMGR) XQFLWOR($1, NULL, NULL, WRAP(@2, $3), MEMMGR));
		}
	;

FlworExprForLetList:
		FlworExprForLetList ForOrLetClause
		{
			$$ = $1;
			for (VectorOfVariableBinding::iterator it = $2->begin(); it != $2->end (); ++it)
				$1->push_back(*it);
		}
	  | ForOrLetClause
      ;

ForOrLetClause:
		ForClause
      | LetClause
      ;

// [29]    ForClause    ::=    <"for" "$"> VarName TypeDeclaration? PositionalVar? "in" ExprSingle
//								  ("," "$" VarName TypeDeclaration? PositionalVar? "in" ExprSingle)*
ForClause:
		_FOR_ ForBindingList
		{
			$$ = $2;
		}
	  ;

ForBindingList:
		ForBindingList _COMMA_ _DOLLAR_SIGN_ ForBinding
		{
			$$->push_back($4);
		}
	  | ForBinding
		{
			$$ = new (MEMMGR) VectorOfVariableBinding(PathanAllocator<XQVariableBinding*>(MEMMGR));
			$$->push_back($1);
		}
	  ;

ForBinding:
	    _VARIABLE_ _IN_ ExprSingle
		{
			$$ = new (MEMMGR) XQVariableBinding(MEMMGR, XQVariableBinding::forBinding,$1,$3);
			$$->_line=@1.first_line;
			$$->_file=QP->_query->getFile();
		}
	  | _VARIABLE_ PositionalVar _IN_ ExprSingle
		{
			$$ = new (MEMMGR) XQVariableBinding(MEMMGR, XQVariableBinding::forBinding,$1,$4,$2);
			$$->_line=@1.first_line;
			$$->_file=QP->_query->getFile();
		}
	  |	_VARIABLE_ TypeDeclaration _IN_ ExprSingle
		{
			// TypeDeclaration should fire a static error
			$$ = new (MEMMGR) XQVariableBinding(MEMMGR, XQVariableBinding::forBinding,$1,$4);
			$$->_line=@1.first_line;
			$$->_file=QP->_query->getFile();
		}
	  |	_VARIABLE_ TypeDeclaration PositionalVar _IN_ ExprSingle
		{
			// TypeDeclaration should fire a static error
			$$ = new (MEMMGR) XQVariableBinding(MEMMGR, XQVariableBinding::forBinding,$1,$5,$3);
			$$->_line=@1.first_line;
			$$->_file=QP->_query->getFile();
		}
	  ;

// [30]    PositionalVar    ::=    "at" "$" VarName
PositionalVar:
      _AT_KEYWORD_ _DOLLAR_SIGN_ _VARIABLE_
		{
			$$ = $3;
		}
    ;

// [31]    LetClause    ::=    <"let" "$"> VarName TypeDeclaration? ":=" ExprSingle
//								  ("," "$" VarName TypeDeclaration? ":=" ExprSingle)*
LetClause:
		_LET_ LetBindingList
		{
			$$ = $2;
		}
	  ;

LetBindingList:
      LetBindingList _COMMA_ _DOLLAR_SIGN_ LetBinding
		{
			$1->push_back($4);
			$$ = $1;
		}
    | LetBinding
		{
			$$ = new (MEMMGR) VectorOfVariableBinding(PathanAllocator<XQVariableBinding*>(MEMMGR));
			$$->push_back($1);
		}
    ;

LetBinding:
      _VARIABLE_ _COLON_EQ_ ExprSingle
		{
			$$ = new (MEMMGR) XQVariableBinding(MEMMGR, XQVariableBinding::letBinding,$1,$3);
			$$->_line=@1.first_line;
			$$->_file=QP->_query->getFile();
		}
	| _VARIABLE_ TypeDeclaration _COLON_EQ_ ExprSingle
		{
			// TypeDeclaration should fire a static error
			$$ = new (MEMMGR) XQVariableBinding(MEMMGR, XQVariableBinding::letBinding,$1,$4);
			$$->_line=@1.first_line;
			$$->_file=QP->_query->getFile();
		}
    ;

// [32]    WhereClause    ::=    "where" Expr
WhereClause:
      _WHERE_ ExprSingle
		{
			$$ = WRAP(@1, $2);
		}
    ;

// [33]    OrderByClause    ::=    (<"order" "by"> |  <"stable" "order" "by">) OrderSpecList
OrderByClause:
	  _ORDER_BY_ OrderSpecList
		{
			$$=new (MEMMGR) XQSort(XQSort::unstable,$2);
		}
	| _STABLE_ORDER_BY_ OrderSpecList
		{
			$$=new (MEMMGR) XQSort(XQSort::stable,$2);
		}
	;

// [34]    OrderSpecList    ::=    OrderSpec ("," OrderSpec)*
OrderSpecList:
	  OrderSpecList _COMMA_ OrderSpec
		{
			$1->push_back($3);
			$$ = $1;
		}
	| OrderSpec
		{
			$$ = new (MEMMGR) XQSort::VectorOfSortSpec(PathanAllocator<XQSort::SortSpec*>(MEMMGR));
			$$->push_back($1);
		}
	;

// [35]    OrderSpec    ::=    ExprSingle OrderModifier
// [36]    OrderModifier    ::=    ("ascending" |  "descending")? (<"empty" "greatest"> |  <"empty" "least">)? ("collation" StringLiteral)?
OrderSpec:
	  ExprSingle OrderDirection EmptyHandling
		{
			$$ = new (MEMMGR) XQSort::SortSpec($1,$2+$3,NULL);
		}
	| ExprSingle OrderDirection EmptyHandling _COLLATION_ _STRING_LITERAL_
		{
			$$ = new (MEMMGR) XQSort::SortSpec($1,$2+$3,$5);
		}
	;

OrderDirection:
	  /* empty */
		{ $$ = XQSort::SortSpec::ascending; }
	|  _ASCENDING_
		{ $$ = XQSort::SortSpec::ascending; }
    | _DESCENDING_
		{ $$ = XQSort::SortSpec::descending; }
	;

EmptyHandling:
	  /* empty */
		{ $$ = XQSort::SortSpec::empty_least; }
    | _EMPTY_GREATEST_
		{ $$ = XQSort::SortSpec::empty_greatest; }
    | _EMPTY_LEAST_
		{ $$ = XQSort::SortSpec::empty_least; }
	;

// [37]    QuantifiedExpr    ::=    (<"some" "$"> |  <"every" "$">) VarName TypeDeclaration? "in" ExprSingle
//										("," "$" VarName TypeDeclaration? "in" ExprSingle)* "satisfies" ExprSingle
QuantifiedExpr:
	_SOME_ QuantifyBindingList _SATISFIES_ ExprSingle
	{
		$$ = new (MEMMGR) XQQuantified(XQQuantified::some, $2, WRAP(@3, $4), MEMMGR);
	}
	| _EVERY_ QuantifyBindingList _SATISFIES_ ExprSingle
	{
		$$ = new (MEMMGR) XQQuantified(XQQuantified::every, $2, WRAP(@3, $4), MEMMGR);
	}
	;

QuantifyBindingList:
		QuantifyBindingList _COMMA_ _DOLLAR_SIGN_ QuantifyBinding
		{
			$$->push_back($4);
		}
	  | QuantifyBinding
		{
			$$ = new (MEMMGR) VectorOfVariableBinding(PathanAllocator<XQVariableBinding*>(MEMMGR));
			$$->push_back($1);
		}
	  ;

QuantifyBinding:
	    _VARIABLE_ _IN_ ExprSingle
		{
			$$ = new (MEMMGR) XQVariableBinding(MEMMGR, XQVariableBinding::forBinding,$1,$3);
			$$->_line=@1.first_line;
			$$->_file=QP->_query->getFile();
		}
	  |	_VARIABLE_ TypeDeclaration _IN_ ExprSingle
		{
			// TypeDeclaration should fire a static error
			$$ = new (MEMMGR) XQVariableBinding(MEMMGR, XQVariableBinding::forBinding,$1,$4);
			$$->_line=@1.first_line;
			$$->_file=QP->_query->getFile();
		}
	  ;

// [38]    TypeswitchExpr    ::=    <"typeswitch" "("> Expr ")" CaseClause+ "default" ("$" VarName)? "return" ExprSingle
TypeswitchExpr:
		_TYPESWITCH_ Expr _RPAR_ CaseClauseList _DEFAULT_ _DOLLAR_SIGN_ _VARIABLE_ _RETURN_ ExprSingle
		{
			XQTypeswitch::Clause* defClause=new (MEMMGR) XQTypeswitch::Clause(NULL,WRAP(@5, $9),MEMMGR->getPooledString($7));
			$$ = new (MEMMGR) XQTypeswitch( WRAP(@1, $2), $4, defClause, MEMMGR);
		}
	  | _TYPESWITCH_ Expr _RPAR_ CaseClauseList _DEFAULT_ _RETURN_ ExprSingle
		{
			XQTypeswitch::Clause* defClause=new (MEMMGR) XQTypeswitch::Clause(NULL,WRAP(@5, $7),NULL);
			$$ = new (MEMMGR) XQTypeswitch( WRAP(@1, $2), $4, defClause, MEMMGR);
		}
	  ;

CaseClauseList:
		CaseClauseList CaseClause
		{
			$1->push_back($2);
			$$=$1;
		}
	  | CaseClause
		{
			$$=new (MEMMGR) XQTypeswitch::VectorOfClause(PathanAllocator<XQTypeswitch::Clause*>(MEMMGR));
			$$->push_back($1);
		}
	  ;

// [39]    CaseClause    ::=    "case" ("$" VarName "as")? SequenceType "return" ExprSingle
CaseClause:
	  _CASE_ SequenceType _RETURN_ ExprSingle
		{
			$$ = new (MEMMGR) XQTypeswitch::Clause($2, WRAP(@1, $4), NULL);
		}
	|  _CASE_ _DOLLAR_SIGN_ _VARIABLE_ _AS_ SequenceType _RETURN_ ExprSingle
		{
			$$ = new (MEMMGR) XQTypeswitch::Clause($5, WRAP(@1, $7), MEMMGR->getPooledString($3));
		}
	;

// [40]    IfExpr    ::=    <"if" "("> Expr ")" "then" ExprSingle "else" ExprSingle
IfExpr:
	  _IF_ Expr _RPAR_ _THEN_ ExprSingle _ELSE_ ExprSingle
		{
	        $$ = WRAP(@1, new (MEMMGR) DataItemIf($2, $5, $7, MEMMGR));
		}
	;

// [41]    OrExpr    ::=    AndExpr ( "or"  AndExpr )*
OrExpr:
		OrExpr _OR_ AndExpr
		{
			DataItem* prevExpr=$1;
			if((unsigned int)prevExpr->getType()==XQContext::DEBUG_HOOK)
				prevExpr=((XQDebugHook*)prevExpr)->m_impl;
			if(prevExpr->getType()==DataItem::OPERATOR &&
			   XPath2Utils::equals(((DataItemOperator*)prevExpr)->getOperatorName(),Or::name))
			{
				((Or*)prevExpr)->addArgument($3);
				$$ = prevExpr;
			}
			else
				$$ = WRAP(@1, new (MEMMGR) Or(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
	  | AndExpr
	  ;

// [42]    AndExpr    ::=    ComparisonExpr ( "and" ComparisonExpr )*
AndExpr:
		AndExpr _AND_ ComparisonExpr
		{
			DataItem* prevExpr=$1;
			if((unsigned int)prevExpr->getType()==XQContext::DEBUG_HOOK)
				prevExpr=((XQDebugHook*)prevExpr)->m_impl;
			if(prevExpr->getType()==DataItem::OPERATOR &&
			   XPath2Utils::equals(((DataItemOperator*)prevExpr)->getOperatorName(),And::name))
			{
				((And*)prevExpr)->addArgument($3);
				$$ = prevExpr;
			}
			else
				$$ = WRAP(@1, new (MEMMGR) And(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
	  | ComparisonExpr
      ;

// [43]    ComparisonExpr    ::=    RangeExpr ( (ValueComp
//									|  GeneralComp
//									|  NodeComp)  RangeExpr )?
// [55]    GeneralComp    ::=    "=" |  "!=" |  "<" |  "<=" |  ">" |  ">="
// [56]    ValueComp    ::=    "eq" |  "ne" |  "lt" |  "le" |  "gt" |  "ge"
// [57]    NodeComp    ::=    "is" |  "<<" |  ">>"
ComparisonExpr:
	  RangeExpr _EQUALS_ RangeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) GeneralComp(GeneralComp::EQUAL,packageArgs($1,$3, MEMMGR),MEMMGR));
		}
	| RangeExpr _NOT_EQUALS_ RangeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) GeneralComp(GeneralComp::NOT_EQUAL,packageArgs($1,$3, MEMMGR),MEMMGR));
		}
	| RangeExpr _LT_ RangeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) GeneralComp(GeneralComp::LESS_THAN,packageArgs($1,$3, MEMMGR),MEMMGR));
		}
	| RangeExpr _LT_EQUALS_ RangeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) GeneralComp(GeneralComp::LESS_THAN_EQUAL,packageArgs($1,$3, MEMMGR),MEMMGR));
		}
	| RangeExpr _GT_ RangeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) GeneralComp(GeneralComp::GREATER_THAN,packageArgs($1,$3, MEMMGR),MEMMGR));
		}
	| RangeExpr _GT_EQUALS_ RangeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) GeneralComp(GeneralComp::GREATER_THAN_EQUAL,packageArgs($1,$3, MEMMGR),MEMMGR));
		}
	| RangeExpr _FORTRAN_EQ_ RangeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) Equals(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
	| RangeExpr _FORTRAN_NE_ RangeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) NotEquals(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
	| RangeExpr _FORTRAN_LT_ RangeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) LessThan(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
	| RangeExpr _FORTRAN_LE_ RangeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) LessThanEqual(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
	| RangeExpr _FORTRAN_GT_ RangeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) GreaterThan(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
	| RangeExpr _FORTRAN_GE_ RangeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) GreaterThanEqual(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
	| RangeExpr _IS_ RangeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) NodeComparison(packageArgs($1, $3, MEMMGR), MEMMGR));
		}
	| RangeExpr _LT_LT_ RangeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) OrderComparison(packageArgs($1, $3, MEMMGR), true, MEMMGR));
		}
	| RangeExpr _GT_GT_ RangeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) OrderComparison(packageArgs($1, $3, MEMMGR), false,MEMMGR));
		}
	| RangeExpr
	;

// [44]    RangeExpr    ::=    AdditiveExpr ( "to"  AdditiveExpr )?
RangeExpr:
      AdditiveExpr _TO_ AdditiveExpr
		{
			$$ = WRAP(@2, new (MEMMGR) Range(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
	| AdditiveExpr
    ;

// [45]    AdditiveExpr    ::=    MultiplicativeExpr ( ("+" |  "-")  MultiplicativeExpr )*
AdditiveExpr:
      AdditiveExpr _PLUS_ MultiplicativeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) Plus(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
    | AdditiveExpr _MINUS_ MultiplicativeExpr
		{
			$$ = WRAP(@2, new (MEMMGR) Minus(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
	| MultiplicativeExpr
    ;

// [46]    MultiplicativeExpr    ::=    UnionExpr ( ("*" |  "div" |  "idiv" |  "mod")  UnionExpr )*
MultiplicativeExpr:
      MultiplicativeExpr _MULTIPLY_ UnionExpr
		{
			$$ = WRAP(@2, new (MEMMGR) Multiply(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
    | MultiplicativeExpr _DIV_ UnionExpr
		{
			$$ = WRAP(@2, new (MEMMGR) Divide(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
    | MultiplicativeExpr _INTEGER_DIV_ UnionExpr
		{
			$$ = WRAP(@2, new (MEMMGR) IntegerDivide(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
    | MultiplicativeExpr _MOD_ UnionExpr
		{
			$$ = WRAP(@2, new (MEMMGR) Mod(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
	| UnionExpr
    ;

// [47]    UnionExpr    ::=    IntersectExceptExpr ( ("union" |  "|")  IntersectExceptExpr )*
UnionExpr:
      UnionExpr _VERTICAL_BAR_ IntersectExceptExpr
		{
			$$ = WRAP(@2, new (MEMMGR) Union(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
    | UnionExpr _UNION_ IntersectExceptExpr
		{
			$$ = WRAP(@2, new (MEMMGR) Union(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
	| IntersectExceptExpr
    ;

// [48]    IntersectExceptExpr    ::=    InstanceofExpr ( ("intersect" |  "except")  InstanceofExpr )*
IntersectExceptExpr:
      IntersectExceptExpr _INTERSECT_ InstanceofExpr
		{
			$$ = WRAP(@2, new (MEMMGR) Intersect(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
    | IntersectExceptExpr _EXCEPT_ InstanceofExpr
		{
			$$ = WRAP(@2, new (MEMMGR) Except(packageArgs($1, $3, MEMMGR),MEMMGR));
		}
	| InstanceofExpr
    ;

// [49]    InstanceofExpr    ::=    TreatExpr ( <"instance" "of"> SequenceType )?
InstanceofExpr:
	TreatExpr _INSTANCE_OF_ SequenceType
	{
		$$ = WRAP(@2, new (MEMMGR) DataItemInstanceOf($1,$3,MEMMGR));
	}
	| TreatExpr
	;

// [50]    TreatExpr    ::=    CastableExpr ( <"treat" "as"> SequenceType )?
TreatExpr:
	CastableExpr _TREAT_AS_ SequenceType
	{
		$$ = WRAP(@2, new (MEMMGR) DataItemTreatAs($1,$3,MEMMGR));
	}
	| CastableExpr
	;

// [51]    CastableExpr    ::=    CastExpr ( <"castable" "as"> SingleType )?
CastableExpr:
	CastExpr _CASTABLE_AS_ SingleType
	{
		$$ = WRAP(@2, new (MEMMGR) DataItemCastableAs($1,$3,MEMMGR));
	}
	| CastExpr
	;

// [52]    CastExpr    ::=    UnaryExpr (<"cast" "as"> SingleType)?
CastExpr:
	UnaryExpr _CAST_AS_ SingleType
	{
		$$ = WRAP(@1, new (MEMMGR) DataItemCastAs($1,$3,MEMMGR));
	}
	| UnaryExpr
	;

// [53]    UnaryExpr    ::=    ("-" |  "+")* ValueExpr
UnaryExpr:
      _MINUS_ UnaryExpr
		{
			VectorOfDataItems args(PathanAllocator<DataItem*>(MEMMGR));
			args.push_back($2);
			$$ = new (MEMMGR) UnaryMinus(args, MEMMGR);
		}
    | _PLUS_ UnaryExpr
		{
			$$ = $2;
		}
	| ValueExpr
    ;

// [54]    ValueExpr    ::=    ValidateExpr | PathExpr
ValueExpr:
	  ValidateExpr
	| PathExpr
	;

// [58]    ValidateExpr    ::=    (<"validate" "{"> |
//								   (<"validate" ValidationMode> "{")
//								  ) Expr "}"
ValidateExpr:
	  _VALIDATE_CONTENT_ Expr _RBRACE_
		{
			$$ = WRAP(@1, new (MEMMGR) XQValidate($2,DocumentCache::VALIDATION_STRICT,MEMMGR));
		}
	| _VALIDATE_MODE_LAX_ _LBRACE_ Expr _RBRACE_
		{
			$$ = WRAP(@1, new (MEMMGR) XQValidate($3,DocumentCache::VALIDATION_LAX,MEMMGR));
		}
	| _VALIDATE_MODE_STRICT_ _LBRACE_ Expr _RBRACE_
		{
			$$ = WRAP(@1, new (MEMMGR) XQValidate($3,DocumentCache::VALIDATION_STRICT,MEMMGR));
		}
	;

// [59]    PathExpr    ::=    ("/" RelativePathExpr?) |  ("//" RelativePathExpr) |  RelativePathExpr
PathExpr:
	  _SLASH_
  		{
			DataItemNav *nav = new (MEMMGR) DataItemNav(MEMMGR);
			nav->setGotoRootFirst(true);
			$$ = nav;
		}
	| _SLASH_ RelativePathExpr
  		{
			DataItemNav* nav=getNavigation($2,MEMMGR);
			nav->setGotoRootFirst(true);
			$$ = nav;
		}
	| _SLASHSLASH_ RelativePathExpr
  		{
			DescendantOrSelfAxis *step = new (MEMMGR) DescendantOrSelfAxis();
			step->setTypeWildcard();
			step->setNameWildcard();
			step->setNamespaceWildcard();

			DataItemNav *newNavigation = getNavigation($2,MEMMGR);
			newNavigation->setGotoRootFirst(true);
			newNavigation->addStepFront(new (MEMMGR) DataItemStep(step, MEMMGR));
			$$ = newNavigation;
		}
	| RelativePathExpr
	;

// [60]    RelativePathExpr    ::=    StepExpr (("/" |  "//") StepExpr)*
RelativePathExpr:
	  RelativePathExpr _SLASH_ StepExpr
  		{
			DataItemNav *nav = getNavigation($1,MEMMGR);
			nav->addStep($3);
			$$ = nav;
		}
	| RelativePathExpr _SLASHSLASH_ StepExpr
  		{
			DescendantOrSelfAxis *step = new (MEMMGR) DescendantOrSelfAxis();
			step->setTypeWildcard();
			step->setNameWildcard();
			step->setNamespaceWildcard();

			DataItemNav *nav = getNavigation($1,MEMMGR);
			nav->addStep(step);
			nav->addStep($3);
			$$ = nav;
		}
	| StepExpr
	;

// [61]    StepExpr    ::=    AxisStep |  FilterExpr
StepExpr:
	  AxisStep
	| FilterExpr
	;

// [62]    AxisStep    ::=    (ForwardStep |  ReverseStep) PredicateList
AxisStep:
	  ForwardStep PredicateList
		{
			DataItemStep* step = new (MEMMGR) DataItemStep($1,MEMMGR);
			step->addPredicates(*$2);
			$$=step;
		}
	| ReverseStep PredicateList
		{
			DataItemStep* step = new (MEMMGR) DataItemStep($1,MEMMGR);
			step->addPredicates(*$2);
			$$=step;
		}
	;

// [63]    ForwardStep    ::=    (ForwardAxis NodeTest) |  AbbrevForwardStep
ForwardStep:
	  ForwardAxis NodeTest
		{
			importStep($1, $2);
			if($2->getTypeSet())
				$1->setNodeType($2->getNodeType());
			$$ = $1;
		}
	| AbbrevForwardStep
	;

// [64]    ForwardAxis    ::=    <"child" "::">
//								|  <"descendant" "::">
//								|  <"attribute" "::">
//								|  <"self" "::">
//								|  <"descendant-or-self" "::">
//								|  <"following-sibling" "::">
//								|  <"following" "::">
ForwardAxis:
	  _AXIS_CHILD_
		{
			ChildAxis *step = new (MEMMGR) ChildAxis();
			step->setNodeType(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE);
			$$ = step;
		}
	| _AXIS_DESCENDANT_
		{
			DescendantAxis *step = new (MEMMGR) DescendantAxis();
			step->setNodeType(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE);
			$$ = step;
		}
	| _AXIS_ATTRIBUTE_
		{
			AttributeAxis *step = new (MEMMGR) AttributeAxis();
			step->setNodeType(XERCES_CPP_NAMESPACE::DOMNode::ATTRIBUTE_NODE);
			$$ = step;
		}
	| _AXIS_SELF_
		{
			SelfAxis *step = new (MEMMGR) SelfAxis();
			step->setNodeType(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE);
			$$ = step;
		}
	| _AXIS_DESCENDANT_OR_SELF_
		{
			DescendantOrSelfAxis *step = new (MEMMGR) DescendantOrSelfAxis();
			step->setNodeType(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE);
			$$ = step;
		}
	| _AXIS_FOLLOWING_SIBLING_
		{
			FollowingSiblingAxis *step = new (MEMMGR) FollowingSiblingAxis();
			step->setNodeType(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE);
			$$ = step;
		}
	| _AXIS_FOLLOWING_
		{
			FollowingAxis *step = new (MEMMGR) FollowingAxis();
			step->setNodeType(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE);
			$$ = step;
		}
	;

// [65]    AbbrevForwardStep    ::=    "@"? NodeTest
AbbrevForwardStep:
	_AT_ NodeTest
		{
			AttributeAxis *at = new (MEMMGR) AttributeAxis;
			importStep(at, $2);
			at->setNodeType(XERCES_CPP_NAMESPACE::DOMNode::ATTRIBUTE_NODE);
			$$ = at;
		}
	| NodeTest
		{
			ChildAxis *ca = new (MEMMGR) ChildAxis;
			if($1->getTypeSet())
				ca->setNodeType($1->getNodeType());
			else
				ca->setNodeType(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE);
			importStep(ca, $1);
			$$ = ca;
		}
	;

// [66]    ReverseStep    ::=    (ReverseAxis NodeTest) |  AbbrevReverseStep
ReverseStep:
	  ReverseAxis NodeTest
		{
			importStep($1, $2);
			if($2->getTypeSet())
				$1->setNodeType($2->getNodeType());
			$$ = $1;
		}
	| AbbrevReverseStep
	;

// [67]    ReverseAxis    ::=    <"parent" "::">
//								| <"ancestor" "::">
//								| <"preceding-sibling" "::">
//								| <"preceding" "::">
//								| <"ancestor-or-self" "::">
ReverseAxis:
	  _AXIS_PARENT_
		{
			ParentAxis *step = new (MEMMGR) ParentAxis();
			step->setNodeType(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE);
			$$ = step;
		}
	| _AXIS_ANCESTOR_
		{
			AncestorAxis *step = new (MEMMGR) AncestorAxis();
			step->setNodeType(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE);
			$$ = step;
		}
	| _AXIS_PRECEDING_SIBLING_
		{
			PrecedingSiblingAxis *step = new (MEMMGR) PrecedingSiblingAxis();
			step->setNodeType(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE);
			$$ = step;
		}
	| _AXIS_PRECEDING_
		{
			PrecedingAxis *step = new (MEMMGR) PrecedingAxis();
			step->setNodeType(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE);
			$$ = step;
		}
	| _AXIS_ANCESTOR_OR_SELF_
		{
			AncestorOrSelfAxis *step = new (MEMMGR) AncestorOrSelfAxis();
			step->setNodeType(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE);
			$$ = step;
		}
	;

// [68]    AbbrevReverseStep    ::=    ".."
AbbrevReverseStep:
	  _DOT_DOT_
		{
			ParentAxis *step = new (MEMMGR) ParentAxis;
			step->setNameWildcard();
			step->setNamespaceWildcard();
			step->setTypeWildcard();
			$$ = step;
		}
	;

// [69]    NodeTest    ::=    KindTest |  NameTest
NodeTest:
	  KindTest
	| NameTest
	;

// [70]    NameTest    ::=    QName |  Wildcard
NameTest:
	  QName
		{
			NavStepImpl *step = new (MEMMGR) NavStepImpl();
			try
			{
				const XMLCh* uri = CONTEXT->getUriBoundToPrefix($1->getPrefix());
				step->setNodeUri(uri);
			}
			catch(NamespaceLookupException&)
			{
				step->setNodePrefix($1->getPrefix());
			}
			step->setNodeName($1->getName());
			$$ = step;
		}
	| Wildcard
	;

// [71]    Wildcard    ::=    "*" |  <NCName ":" "*"> |  <"*" ":" NCName>
Wildcard:
      _STAR_
		{
			NavStepImpl *step = new (MEMMGR) NavStepImpl();
			step->setNameWildcard();
			step->setNamespaceWildcard();
			$$ = step;
		}
    | _NCNAME_COLON_STAR_
		{
			NavStepImpl *step = new (MEMMGR) NavStepImpl();
			try
			{
				const XMLCh* uri = CONTEXT->getUriBoundToPrefix($1);
				step->setNodeUri(uri);
			}
			catch(NamespaceLookupException&)
			{
				step->setNodePrefix($1);
			}
			step->setNameWildcard();
			$$ = step;
		}
	| _STAR_COLON_NCNAME_
		{
			NavStepImpl *step = new (MEMMGR) NavStepImpl();
			step->setNodeName($1);
			step->setNamespaceWildcard();
			$$ = step;
		}
	;

// [72]    FilterExpr    ::=    PrimaryExpr PredicateList
FilterExpr:
	  PrimaryExpr PredicateList
		{
			$1->addPredicates(*$2);
			$$=$1;
		}
	;

// [73]    PredicateList    ::=    Predicate*
// [74]    Predicate    ::=    "[" Expr "]"
PredicateList:
	  /* empty */
		{
	        $$ = new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
		}
	| PredicateList _LBRACK_ Expr _RBRACK_
		{
			$1->push_back($3);
			$$ = $1;
		}
	;

// [75]    PrimaryExpr    ::=    Literal |  VarRef | ParenthesizedExpr | ContextItemExpr | FunctionCall | Constructor | OrderedExpr | UnorderedExpr
PrimaryExpr:
	   Literal
	|  VarRef
	|  ParenthesizedExpr
	|  ContextItemExpr
	|  FunctionCall
	|  Constructor
	|  OrderedExpr
	|  UnorderedExpr
	;

// [76]    Literal    ::=    NumericLiteral |  StringLiteral
Literal:
	  NumericLiteral
	| StringLiteral
	;

// [77]    NumericLiteral    ::=    IntegerLiteral |  DecimalLiteral |  DoubleLiteral
NumericLiteral:
	  IntegerLiteral
	| DecimalLiteral
	| DoubleLiteral
	;

// [78]    VarRef    ::=    "$" VarName
VarRef:
	_DOLLAR_SIGN_ _VARIABLE_
		{
		    int nColon=XERCES_CPP_NAMESPACE_QUALIFIER XMLString::indexOf($2,':');
			if(nColon!=-1)
  				$$ = new (MEMMGR) DataItemVariable($2,MEMMGR);
			else
				$$ = new (MEMMGR) DataItemVariable(XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString, $2,MEMMGR);
		}
	;

// [79]    ParenthesizedExpr    ::=    "(" Expr? ")"
ParenthesizedExpr:
      _LPAR_ Expr _RPAR_
		{
			DataItem* prevExpr=$2;
			if((unsigned int)prevExpr->getType()==XQContext::DEBUG_HOOK)
				prevExpr=((XQDebugHook*)prevExpr)->m_impl;
			if(prevExpr->getType()!=DataItem::PARENTHESIZED)
			{
				DataItemParenthesizedExpr *dis = new (MEMMGR) DataItemParenthesizedExpr(MEMMGR);
				dis->addItem($2);
				$$ = WRAP(@2, dis);
			}
			else
				$$ = WRAP(@2, $2);
		}
    | _LPAR_ _RPAR_
		{
			$$ = WRAP(@1, new (MEMMGR) DataItemSequence(MEMMGR));
		}
    ;

// [80]    ContextItemExpr    ::=    "."
ContextItemExpr:
	  _DOT_
		{
			$$ = new (MEMMGR) DataItemContextItem(MEMMGR);
		}
	;

// [81]    OrderedExpr    ::=    <"ordered" "{"> Expr "}"
OrderedExpr:
	_ORDERED_ Expr _RBRACE_
		{
			$$ = new (MEMMGR) XQOrderingChange(StaticContext::ORDERING_ORDERED, $2, MEMMGR);
		}
	;

// [82]    UnorderedExpr    ::=    <"unordered" "{"> Expr "}"
UnorderedExpr:
	_UNORDERED_ Expr _RBRACE_
		{
			$$ = new (MEMMGR) XQOrderingChange(StaticContext::ORDERING_UNORDERED, $2, MEMMGR);
		}
	;

// [83]    FunctionCall    ::=    <QName "("> (ExprSingle ("," ExprSingle)*)? ")"
FunctionCall:
	  _FUNCTION_CALL_ _RPAR_
		{
			VectorOfDataItems args(PathanAllocator<DataItem*>(MEMMGR));
			$$ = FNWRAP(@1, $1, new (MEMMGR) XQFunctionCall(new (MEMMGR) QualifiedName($1, MEMMGR), args, MEMMGR));
		}
	| _FUNCTION_CALL_ FunctionCallArgumentList _RPAR_
		{
			$$ = FNWRAP(@1, $1, new (MEMMGR) XQFunctionCall(new (MEMMGR) QualifiedName($1, MEMMGR), *$2,MEMMGR));
		}
	;

FunctionCallArgumentList:
	  FunctionCallArgumentList _COMMA_ ExprSingle
		{
			$1->push_back($3);
			$$ = $1;
		}
	| ExprSingle
		{
			$$ = new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			$$->push_back($1);
		}
	;

// [84]    Constructor    ::=    DirectConstructor | ComputedConstructor
Constructor:
	  DirectConstructor
	| ComputedConstructor
	;

// [85]    DirectConstructor    ::=    DirElemConstructor
//									 | DirCommentConstructor
//									 | DirPIConstructor
DirectConstructor:
	  DirElemConstructor
	| DirCommentConstructor
	| DirPIConstructor
	;

// [86]    DirElemConstructor    ::=    "<" QName DirAttributeList ("/>" |  (">" DirElementContent* "</" QName S? ">"))
DirElemConstructor:
      _START_TAG_OPEN_ _TAG_NAME_ DirAttributeList _EMPTY_TAG_CLOSE_
		{
			VectorOfDataItems* content=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE,
								new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
										$2),
										MEMMGR),
								$3, content, MEMMGR));
		}
	| _START_TAG_OPEN_ _TAG_NAME_ DirAttributeList _TAG_CLOSE_ DirElementContent _END_TAG_OPEN_ _TAG_NAME_ _TAG_CLOSE_
		{
			if(!XPath2Utils::equals($2,$7))
				yyerror("Close tag does not match open tag");
			// if we are requested to strip whitespace-only nodes, check if the last element content should be removed
			VectorOfDataItems* elemContent=$5;
			if(!CONTEXT->getPreserveXMLSpace() &&
			   elemContent->size()>0 &&
			   elemContent->back()->getType()==DataItem::LITERAL)
			{
        Item::Ptr litVal = ((DataItemLiteral*)elemContent->back())->getItemConstructor()->createItem(CONTEXT);
				if(((AnyAtomicType*)(const Item*)litVal)->getPrimitiveTypeIndex()==AnyAtomicType::STRING &&
           isAllSpaces(litVal->asString(CONTEXT)))
					elemContent->pop_back();
			}
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE,
							  new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
										$2),
										MEMMGR),
							  $3, elemContent,MEMMGR));
		}
	;

// [87]    DirAttributeList    ::=    (S (QName S? "=" S? DirAttributeValue)?)*
DirAttributeList:
		/* empty */
		{
			$$ = new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
		}
	  | DirAttributeList _ATTRIBUTE_NAME_ _VALUE_INDICATOR_ DirAttributeValue
		{
			$$ = $1;
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			DataItem* attrItem=WRAP(@2, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::ATTRIBUTE_NODE,
										   new (MEMMGR) DataItemLiteral(
						new (MEMMGR) AnyAtomicTypeConstructor(
											XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
											XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
											$2),
											MEMMGR),
										   empty, $4,MEMMGR));
			if(XPath2Utils::equals($2, XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgXMLNSString) ||
			   XERCES_CPP_NAMESPACE_QUALIFIER XMLString::startsWith($2, XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgXMLNSColonString))
			{
				$$->insert($$->begin(), attrItem);
			}
			else
			{
				$$->push_back(attrItem);
			}
		}
	  ;

// [88]    DirAttributeValue    ::=    ('"' (EscapeQuot |  QuotAttrValueContent)* '"')
//								 |  ("'" (EscapeApos |  AposAttrValueContent)* "'")
DirAttributeValue:
		_OPEN_QUOT_ QuotAttrValueContent _CLOSE_QUOT_
		{
			$$ = $2;
		}
	  | _OPEN_APOS_ AposAttrValueContent _CLOSE_APOS_
		{
			$$ = $2;
		}
	;

// [89]    QuotAttrValueContent    ::=    QuotAttContentChar
//										|  CommonContent
QuotAttrValueContent:
		/* empty */
		{
			$$ = new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
		}
      | QuotAttrValueContent EnclosedExpr
		{
			$$ = $1;
			$$->push_back($2);
		}
      | QuotAttrValueContent _ESCAPE_QUOT_
		{
			$$ = $1;
			merge_strings(CONTEXT,$$,szQuote);
		}
	  | QuotAttrValueContent CommonContent
		{
			$$ = $1;
			merge_strings(CONTEXT,$$,$2);
		}
	;

// [90]    AposAttrValueContent    ::=    AposAttContentChar
//										|  CommonContent
AposAttrValueContent:
		/* empty */
		{
			$$ = new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
		}
      | AposAttrValueContent EnclosedExpr
		{
			$$ = $1;
			$$->push_back($2);
		}
      | AposAttrValueContent _ESCAPE_APOS_
		{
			$$ = $1;
			merge_strings(CONTEXT,$$,szApos);
		}
      | AposAttrValueContent CommonContent
		{
			$$ = $1;
			merge_strings(CONTEXT,$$,$2);
		}
	  ;

// [91]    DirElementContent    ::=    DirectConstructor
//									|  ElementContentChar
//									|  CdataSection
//									|  CommonContent
DirElementContent:
	  /* empty */
		{
			$$ = new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
		}
	  |	DirElementContent DirectConstructor
		{
			// if the last token was a string literal made of whitesapce and
			// we are adding a node constructor, and the context tells us to strip whitespace, remove it
			if($1->size()>0 &&
			   $1->back()->getType()==DataItem::LITERAL)
			{
				const XMLCh* lastString=NULL;
        Item::Ptr litVal = ((DataItemLiteral*)$1->back())->getItemConstructor()->createItem(CONTEXT);
				if(((AnyAtomicType*)(const Item*)litVal)->getPrimitiveTypeIndex()==AnyAtomicType::STRING)
					lastString=litVal->asString(CONTEXT);
				if(lastString!=NULL && XERCES_CPP_NAMESPACE_QUALIFIER XMLString::stringLen(lastString)>0 && isAllSpaces(lastString) && !CONTEXT->getPreserveXMLSpace())
					$1->pop_back();
			}
			$$ = $1;
			$$->push_back($2);
		}
	  | DirElementContent EnclosedExpr
		{
			// if the last token was a string literal made of whitesapce and
			// we are adding an enclosed expression, and the context tells us to strip whitespace, remove it
			if($1->size()>0 &&
			   $1->back()->getType()==DataItem::LITERAL)
			{
				const XMLCh* lastString=NULL;
        Item::Ptr litVal = ((DataItemLiteral*)$1->back())->getItemConstructor()->createItem(CONTEXT);
				if(((AnyAtomicType*)(const Item*)litVal)->getPrimitiveTypeIndex()==AnyAtomicType::STRING)
					lastString=litVal->asString(CONTEXT);
				if(lastString!=NULL && XERCES_CPP_NAMESPACE_QUALIFIER XMLString::stringLen(lastString)>0 && isAllSpaces(lastString) && !CONTEXT->getPreserveXMLSpace())
					$1->pop_back();
			}
			$$ = $1;
			$$->push_back($2);
		}
      | DirElementContent CdataSection
		{
			$$ = $1;
			merge_strings(CONTEXT,$$,$2);
		}
	  | DirElementContent CommonContent
		{
			$$ = $1;
			merge_strings(CONTEXT,$$,$2);
		}
	;

// [92]    CommonContent    ::=    PredefinedEntityRef | CharRef | "{{" | "}}" | EnclosedExpr
// we choose to add the _CHAR_ and remove the EnclosedExpr, so that the type can be a string
CommonContent:
	_PREDEFINED_ENTITY_REF_
	| _CHAR_REF_
	| _LCURLY_BRACE_ESCAPE_
	{
		$$ = szCurlyOpen;
	}
	| _RCURLY_BRACE_ESCAPE_
	{
		$$ = szCurlyClose;
	}
	| _CHAR_
	;

// [93]    DirCommentConstructor    ::=    "<!--" DirCommentContents "-->"
// [94]    DirCommentContents    ::=    ((Char - '-') | <'-' (Char - '-')>)*
DirCommentConstructor:
	_XML_COMMENT_
		{
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::COMMENT_NODE,
									  new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
										$1),
										MEMMGR),
									  empty, empty,MEMMGR));
		}
	;

// [95]    DirPIConstructor    ::=    "<?" PITarget (S DirPIContents)? "?>"
// [96]    DirPIContents    ::=    (Char* - (Char* '?>' Char*))
DirPIConstructor:
	_PROCESSING_INSTRUCTION_START_ _PI_TARGET_ _PROCESSING_INSTRUCTION_CONTENT_
		{
			VectorOfDataItems* content=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			content->push_back(new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
										$3),
										MEMMGR));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::PROCESSING_INSTRUCTION_NODE,
								      new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
										$2),
										MEMMGR),
									  empty, content, MEMMGR));
		}
	;

// [97]    CDataSection    ::=    "<![CDATA[" CDataSectionContents "]]>"
// [98]    CDataSectionContents    ::=    (Char* - (Char* ']]>' Char*))
CdataSection:
	  _CDATA_SECTION_
		{
			$$ = $1;
		}
	;

// [99]    ComputedConstructor    ::=    CompDocConstructor
//									   | CompElemConstructor
//									   | CompAttrConstructor
//									   | CompTextConstructor
//									   | CompCommentConstructor
//									   | CompPIConstructor
ComputedConstructor:
	CompDocConstructor
	| CompElemConstructor
	| CompAttrConstructor
	| CompTextConstructor
	| CompCommentConstructor
	| CompPIConstructor
	;

// [100]    CompDocConstructor    ::=    <"document" "{"> Expr "}"
CompDocConstructor:
	  _DOCUMENT_CONSTR_ Expr _RBRACE_
		{
			VectorOfDataItems* content=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			content->push_back(WRAP(@2, $2));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::DOCUMENT_NODE,
								  new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
										XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString),
										MEMMGR),
								  empty, content,MEMMGR));
		}
	;

// [101]    CompElemConstructor    ::=    (<"element" QName "{"> |  (<"element" "{"> Expr "}" "{")) CompElemBody? "}"
CompElemConstructor:
	  _NAMED_ELEMENT_CONSTR_ CompElemBody _RBRACE_
		{
			VectorOfDataItems* content=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			content->push_back(WRAP(@2, $2));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE,
								  new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
										$1),
										MEMMGR),
								  empty, content,MEMMGR));
		}
	| _NAMED_ELEMENT_CONSTR_ _RBRACE_
		{
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE,
								  new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
										$1),
										MEMMGR),
								  empty, empty,MEMMGR));
		}
	| _ELEMENT_CONSTR_ Expr _RBRACE_ _LBRACE_ CompElemBody _RBRACE_
		{
			VectorOfDataItems* content=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			content->push_back(WRAP(@5, $5));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE,
								  WRAP(@2, $2),
								  empty, content, MEMMGR));
		}
	| _ELEMENT_CONSTR_ Expr _RBRACE_ _LBRACE_ _RBRACE_
		{
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::ELEMENT_NODE,
								  WRAP(@2, $2),
								  empty, empty, MEMMGR));
		}
	;

// [102]    CompElemBody    ::=    (LocalNamespaceDecl | ExprSingle) ("," (LocalNamespaceDecl | ExprSingle))*
CompElemBody:
	CompElemBodyItem
	| CompElemBody _COMMA_ CompElemBodyItem
	{
		DataItem* prevExpr=$1;
		if((unsigned int)prevExpr->getType()==XQContext::DEBUG_HOOK)
			prevExpr=((XQDebugHook*)prevExpr)->m_impl;
		if(prevExpr->getType()==DataItem::PARENTHESIZED)
		{
			((DataItemParenthesizedExpr *)prevExpr)->addItem($3);
			$$ = $1;
		}
		else
		{
			DataItemParenthesizedExpr *dis = new (MEMMGR) DataItemParenthesizedExpr(MEMMGR);
			dis->addItem($1);
			dis->addItem($3);
			$$ = dis;
		}
	}
	;

CompElemBodyItem:
	LocalNamespaceDecl
	| ExprSingle
	;


// [103]    LocalNamespaceDecl    ::=    "namespace" NCName? "{" StringLiteral "}"
LocalNamespaceDecl:
	  _NAMED_NAMESPACE_CONSTR_ StringLiteral _RBRACE_
		{
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			VectorOfDataItems* content=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			content->push_back(WRAP(@2, $2));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMXPathNamespace::XPATH_NAMESPACE_NODE,
								      new (MEMMGR) DataItemLiteral(
											new (MEMMGR) AnyAtomicTypeConstructor(
														XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
														XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
														$1),
											MEMMGR),
									  empty, content, MEMMGR));
		}
	;

// [104]    CompAttrConstructor    ::=    (<"attribute" QName "{"> |  (<"attribute" "{"> Expr "}" "{")) Expr? "}"
CompAttrConstructor:
	  _NAMED_ATTRIBUTE_CONSTR_ Expr _RBRACE_
		{
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			VectorOfDataItems* content=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			content->push_back(WRAP(@2, $2));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::ATTRIBUTE_NODE,
								      new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
										$1),
										MEMMGR),
									  empty, content,MEMMGR));
		}
	| _NAMED_ATTRIBUTE_CONSTR_ _RBRACE_
		{
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::ATTRIBUTE_NODE,
								      new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
										$1),
										MEMMGR),
									  empty, empty,MEMMGR));
		}
	| _ATTRIBUTE_CONSTR_ Expr _RBRACE_ _LBRACE_ Expr _RBRACE_
		{
			VectorOfDataItems* content=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			content->push_back(WRAP(@5, $5));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::ATTRIBUTE_NODE,
									  WRAP(@2, $2),
									  empty, content, MEMMGR));
		}
	| _ATTRIBUTE_CONSTR_ Expr _RBRACE_ _LBRACE_ _RBRACE_
		{
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::ATTRIBUTE_NODE,
									  WRAP(@2, $2),
									  empty, empty, MEMMGR));
		}
	;

// [105]    CompTextConstructor    ::=    <"text" "{"> Expr "}"
CompTextConstructor:
	  _TEXT_CONSTR_ Expr _RBRACE_
		{
			VectorOfDataItems* content=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			content->push_back(WRAP(@2, $2));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::TEXT_NODE,
								      new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
										XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString),
										MEMMGR),
									  empty, content, MEMMGR));
		}
	;

// [106]    CompCommentConstructor    ::=    <"comment" "{"> Expr "}"
CompCommentConstructor:
	  _COMMENT_CONSTR_ Expr _RBRACE_
		{
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::COMMENT_NODE,
									  WRAP(@2, $2),
									  empty, empty,MEMMGR));
		}
	;

// [107]    CompPIConstructor    ::=    (<"processing-instruction" NCName "{"> | (<"processing-instruction" "{"> Expr "}" "{")) Expr? "}"
CompPIConstructor:
	  _NAMED_PROCESSING_INSTRUCTION_CONSTR_ Expr _RBRACE_
	  {
			VectorOfDataItems* content=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			content->push_back(WRAP(@2, $2));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::PROCESSING_INSTRUCTION_NODE,
								      new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
										$1),
										MEMMGR),
									  empty, content, MEMMGR));
	  }
	| _NAMED_PROCESSING_INSTRUCTION_CONSTR_ _RBRACE_
	  {
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::PROCESSING_INSTRUCTION_NODE,
								      new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
										$1),
										MEMMGR),
									  empty, empty, MEMMGR));
	  }
	| _PROCESSING_INSTRUCTION_CONSTR_ Expr _RBRACE_ _LBRACE_ Expr _RBRACE_
	  {
			VectorOfDataItems* content=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			content->push_back(WRAP(@5, $5));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::PROCESSING_INSTRUCTION_NODE,
									  WRAP(@2, $2),
									  empty, content, MEMMGR));
	  }
	| _PROCESSING_INSTRUCTION_CONSTR_ Expr _RBRACE_ _LBRACE_ _RBRACE_
	  {
			VectorOfDataItems* empty=new (MEMMGR) VectorOfDataItems(PathanAllocator<DataItem*>(MEMMGR));
			$$ = WRAP(@1, new (MEMMGR) XQDOMConstructor(XERCES_CPP_NAMESPACE::DOMNode::PROCESSING_INSTRUCTION_NODE,
									  WRAP(@2, $2),
									  empty, empty, MEMMGR));
	  }
	;

// [108]    SingleType    ::=    AtomicType "?"?
SingleType:
		AtomicType _ZERO_OR_ONE_
	    {
			SequenceType* seq=new (MEMMGR) SequenceType();
			seq->setItemType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_ATOMIC_TYPE,NULL,$1));
			seq->setOccurrence(SequenceType::QUESTION_MARK);
			$$ = seq;
		}
	  | AtomicType
	    {
			SequenceType* seq=new (MEMMGR) SequenceType();
			seq->setItemType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_ATOMIC_TYPE,NULL,$1));
			seq->setOccurrence(SequenceType::EXACTLY_ONE);
			$$ = seq;
		}
	;

// [109]    TypeDeclaration    ::=    "as" SequenceType
TypeDeclaration:
	  _AS_ SequenceType
		{
			$$ = $2;
		}
	;

// [110]    SequenceType    ::=    (ItemType OccurrenceIndicator?) |  <"empty" "(" ")">
SequenceType:
	    ItemType OccurrenceIndicator
		{
			SequenceType* seq=new (MEMMGR) SequenceType();
			seq->setItemType($1);
			seq->setOccurrence($2);
			$$ = seq;
		}
	  | ItemType
		{
			SequenceType* seq=new (MEMMGR) SequenceType();
			seq->setItemType($1);
			seq->setOccurrence(SequenceType::EXACTLY_ONE);
			$$ = seq;
		}
	  | _EMPTY_
		{
			$$ = new (MEMMGR) SequenceType();
		}
	  ;


// [111]    OccurrenceIndicator    ::=    "*" |  "+" |  "?"
OccurrenceIndicator:
	_ZERO_OR_MORE_
	{ $$ = SequenceType::STAR; }
	| _ONE_OR_MORE_
	{ $$ = SequenceType::PLUS; }
	| _ZERO_OR_ONE_
	{ $$ = SequenceType::QUESTION_MARK; }
	;

// [112]    ItemType    ::=    AtomicType | KindTest | <"item" "(" ")">
ItemType:
	AtomicType
	{
        $$ = new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_ATOMIC_TYPE, NULL, $1);
	}
	| KindTest
	{
		$$ = $1->getType();
		$1->setType(NULL);
	}
	| _ITEM_
	{
		$$ = new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_ANYTHING);
	}
	;

// [113]    AtomicType    ::=    QName
AtomicType:
		QName
		{
			$$ = $1;
		}
	  ;

// [114]    KindTest    ::=    DocumentTest
//							|  ElementTest
//							|  AttributeTest
//							|  SchemaElementTest
//							|  SchemaAttributeTest
//							|  PITest
//							|  CommentTest
//							|  TextTest
//							|  AnyKindTest
KindTest:
	   DocumentTest
	|  ElementTest
	|  AttributeTest
	|  SchemaElementTest
	|  SchemaAttributeTest
	|  PITest
	|  CommentTest
	|  TextTest
	|  AnyKindTest
	;

// [115]    AnyKindTest    ::=    <"node" "("> ")"
AnyKindTest:
	_NODE_LPAR_ _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
        step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_NODE));
		$$ = step;
	}
	;

// [116]    DocumentTest    ::=    <"document-node" "("> (ElementTest | SchemaElementTest)? ")"
DocumentTest:
	_DOCUMENT_NODE_LPAR_ _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
        step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_DOCUMENT));
		$$ = step;
	}
	| _DOCUMENT_NODE_LPAR_ ElementTest _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
		SequenceType::ItemType* elemTest=$2->getType();
        step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_DOCUMENT,elemTest->getName(),elemTest->getType()));
		elemTest->setName(NULL);
		elemTest->setType(NULL);
		$$ = step;
	}
	| _DOCUMENT_NODE_LPAR_ SchemaElementTest _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
		SequenceType::ItemType* elemTest=$2->getType();
        step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_DOCUMENT,elemTest->getName(),elemTest->getType()));
		elemTest->setName(NULL);
		elemTest->setType(NULL);
		$$ = step;
	}
	;

// [117]    TextTest    ::=    <"text" "("> ")"
TextTest:
	_TEXT_LPAR_ _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
        step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_TEXT));
		$$ = step;
	}
	;

// [118]    CommentTest    ::=    <"comment" "("> ")"
CommentTest:
	_COMMENT_LPAR_ _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
		step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_COMMENT));
		$$ = step;
	}
	;

// [119]    PITest    ::=    <"processing-instruction" "("> (NCName | StringLiteral)? ")"
PITest:
	_PROCESSING_INSTRUCTION_LPAR_ _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
        step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_PI));
		$$ = step;
	}
	| _PROCESSING_INSTRUCTION_LPAR_ _NCNAME_ _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
        step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_PI));
		step->setNodeName($2);
		$$ = step;
	}
	| _PROCESSING_INSTRUCTION_LPAR_ _STRING_LITERAL_ _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
        step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_PI));
		step->setNodeName($2);
		$$ = step;
	}
	;

// [120]    AttributeTest    ::=    <"attribute" "("> (AttribNameOrWildcard ("," TypeName)?)? ")"
AttributeTest:
	_ATTRIBUTE_LPAR_ _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
        step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_ATTRIBUTE));
		$$ = step;
	}
	| _ATTRIBUTE_LPAR_ AttribNameOrWildcard _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
        step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_ATTRIBUTE,$2));
		$$ = step;
	}
	| _ATTRIBUTE_LPAR_ AttribNameOrWildcard _COMMA_ TypeName _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
        step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_ATTRIBUTE,$2,$4));
		$$ = step;
	}
	;

// [121]    AttribNameOrWildcard    ::=    AttributeName | "*"
AttribNameOrWildcard:
	AttributeName
	| _STAR_
	{
		$$ = NULL;
	}
	;

// [122]    SchemaAttributeTest    ::=    <"schema-attribute" "("> AttributeDeclaration ")"
SchemaAttributeTest:
	_SCHEMA_ATTRIBUTE_LPAR_ AttributeDeclaration _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
        step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_SCHEMA_ATTRIBUTE,$2));
		$$ = step;
	}
	;

// [123]    AttributeDeclaration    ::=    AttributeName
AttributeDeclaration:
	AttributeName
	;

// [124]    ElementTest    ::=    <"element" "("> (ElementNameOrWildcard ("," TypeName "?"?)?)? ")"
ElementTest:
	_ELEMENT_LPAR_ _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
        step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_ELEMENT));
		$$ = step;
	}
	| _ELEMENT_LPAR_ ElementNameOrWildcard _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
        step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_ELEMENT,$2));
		$$ = step;
	}
	| _ELEMENT_LPAR_ ElementNameOrWildcard _COMMA_ TypeName _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
        step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_ELEMENT,$2,$4));
		$$ = step;
	}
	| _ELEMENT_LPAR_ ElementNameOrWildcard _COMMA_ TypeName _NILLABLE_ _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
        SequenceType::ItemType* pType=new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_ELEMENT,$2,$4);
		pType->setAllowNilled(true);
        step->setType(pType);
		$$ = step;
	}
	;

// [125]    ElementNameOrWildcard    ::=    ElementName | "*"
ElementNameOrWildcard:
	ElementName
	| _STAR_
	{
		$$ = NULL;
	}
	;

// [126]    SchemaElementTest    ::=    <"schema-element" "("> ElementDeclaration ")"
SchemaElementTest:
	_SCHEMA_ELEMENT_LPAR_ ElementDeclaration _RPAR_
	{
		NavStepImpl *step = new (MEMMGR) NavStepImpl();
        step->setType(new (MEMMGR) SequenceType::ItemType(SequenceType::ItemType::TEST_SCHEMA_ELEMENT,$2));
		$$ = step;
	}
	;

// [127]    ElementDeclaration    ::=    ElementName
ElementDeclaration:
	ElementName
	;

// [128]    AttributeName    ::=    QName
AttributeName:
	QName
	;

// [129]    ElementName    ::=    QName
ElementName:
	QName
	;

// [130]    TypeName    ::=    QName
TypeName:
	QName
	;

StringLiteral:
      _STRING_LITERAL_
		{
			$$ = new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING,
										$1),
										MEMMGR);
		}
	;

IntegerLiteral:
      _INTEGER_NUMBER_
		{
			$$ = new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_INTEGER,
										$1),
										MEMMGR);
		}
	;

DecimalLiteral:
      _DECIMAL_NUMBER_
		{
			$$ = new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_DECIMAL,
										$1),
										MEMMGR);
		}
	;

DoubleLiteral:
      _DOUBLE_NUMBER_
		{
			$$ = new (MEMMGR) DataItemLiteral(
                    new (MEMMGR) AnyAtomicTypeConstructor(
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
										XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_DOUBLE,
										$1),
										MEMMGR);
		}
	;

QName:
	  _QNAME_
		{
			$$ = new (MEMMGR) QualifiedName($1,MEMMGR);
		}
	;
%%

}	// namespace XQuery


