//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2004-2005
//	Sleepycat Software.  All rights reserved.
// Copyright (c) 2004-2005
//	Progress Software Corporation.  All rights reserved.
//
// $Id: XQValidate.cpp,v 1.18 2005/04/05 16:44:58 bostic Exp $
//

//////////////////////////////////////////////////////////////////////
// XQValidate.cpp: implementation of the XQValidate class.
//////////////////////////////////////////////////////////////////////

#include "xquery/XQEngine.hpp"
#include "xquery/dataItem/XQValidate.hpp"
#include "xquery/context/XQDynamicContextImpl.hpp"
#include <pathan/exceptions/FunctionException.hpp>
#include <pathan/Node.hpp>
#include <pathan/SequenceType.hpp>
#include <xercesc/dom/DOMNode.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/validators/schema/SchemaGrammar.hpp>
#include <xercesc/validators/common/ContentSpecNode.hpp>
#include "xquery/XQContext.hpp"
#include <pathan/dataItem/StaticResolutionContext.hpp>
#include <pathan/dataItem/DataItemSequence.hpp>
#include <pathan/internal/factory/DatatypeFactory.hpp>

////////////////////////////////////////////////////////////////////////////////////////
//
//

XQValidate::XQValidate(DataItem* valExpr, DocumentCache::ValidationMode valMode, XPath2MemoryManager* expr)
  : DataItemImpl(expr)
{
  _expr=valExpr;
  _validationMode=valMode;
  setType((DataItem::whichType)XQContext::VALIDATE);
}

Sequence XQValidate::collapseTreeInternal(DynamicContext* context, int flags) const
{
  Result toBeValidated = _expr->collapseTree(context, DataItem::UNORDERED|DataItem::RETURN_TWO);
  const Item::Ptr first = toBeValidated.next(context);
  const Item::Ptr second = toBeValidated.next(context);

  if(first == NULLRCP || second != NULLRCP || !first->isNode())
    DSLthrow(FunctionException,X("XQValidate::collapseTreeInternal"), X("The expression to be validated must evaluate to exactly one document or element node [err:XQ0030]"));

  const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode* node=((Node*)(const Item*)first)->getDOMNode();
  if(node->getNodeType()!=XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ELEMENT_NODE &&
     node->getNodeType()!=XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::DOCUMENT_NODE)
    DSLthrow(FunctionException,X("XQValidate::collapseTreeInternal"), X("The expression to be validated must evaluate to exactly one document or element node [err:XQ0030]"));

  // perform validation on this item
  XERCES_CPP_NAMESPACE_QUALIFIER DOMNode* validatedElt=context->validate(node, _validationMode);
  if(validatedElt==NULL)
    DSLthrow(FunctionException,X("XQValidate::collapseTreeInternal"), X("Unexpected error while validating"));

  return Sequence(DatatypeFactory::POD2AT::createNode(validatedElt, context),context->getMemoryManager());
}

DataItem* XQValidate::staticResolution(StaticContext* ctx, StaticResolutionContext * src)
{
  XQContext* context = CAST_TO_XQCONTEXT(ctx);
  const DocumentCache* docCache=ctx->getDocumentCache();

  StaticResolutionContext newSrc(ctx->getMemoryManager());

  _expr = _expr->staticResolution(ctx, &newSrc);

  src->add(&newSrc);
  src->forceNoFolding(true);
  return resolvePredicates(ctx, src); // Never constant fold
}

const DataItem *XQValidate::getExpression() const
{
  return _expr;
}

DocumentCache::ValidationMode XQValidate::getValidationMode() const
{
  return _validationMode;
}

void XQValidate::setExpression(DataItem *expr)
{
  _expr = expr;
}
