//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2004-2005
//	Sleepycat Software.  All rights reserved.
// Copyright (c) 2004-2005
//	Progress Software Corporation.  All rights reserved.
//
// $Id: XQDOMConstructor.hpp,v 1.9 2005/04/20 18:31:51 bostic Exp $
//

//////////////////////////////////////////////////////////////////////
// XQDOMConstructor.hpp: interface for the XQDOMConstructor class.
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_XQDOMCONSTRUCTOR_H__56E97972_3896_49D3_B055_36CC3E9E550A__INCLUDED_)
#define AFX_XQDOMCONSTRUCTOR_H__56E97972_3896_49D3_B055_36CC3E9E550A__INCLUDED_

#include <pathan/dataItem/DataItemImpl.hpp>

class XQENGINE_API XQDOMConstructor : public DataItemImpl
{
public:
	XQDOMConstructor(short nodeType, DataItem* name, VectorOfDataItems* attrList, VectorOfDataItems* children, XPath2MemoryManager* expr);

	virtual Sequence collapseTreeInternal(DynamicContext* context, int flags=0) const;
	virtual DataItem* staticResolution(StaticContext* context, StaticResolutionContext * src);

  short getNodeType() const;
  const DataItem *getName() const;
  const VectorOfDataItems *getAttributes() const;
  const VectorOfDataItems *getChildren() const;

  void setName(DataItem *name);

protected:
	short m_nodeType;
	DataItem* m_name;
	VectorOfDataItems* m_attrList, *m_children;
};

#endif // !defined(AFX_XQDOMCONSTRUCTOR_H__56E97972_3896_49D3_B055_36CC3E9E550A__INCLUDED_)
