//
// See the file LICENSE for redistribution information.
//
// Copyright (c) 2004-2005
//	Sleepycat Software.  All rights reserved.
// Copyright (c) 2004-2005
//	Progress Software Corporation.  All rights reserved.
//
// $Id: XQStaticContext.hpp,v 1.6 2005/04/05 16:44:45 bostic Exp $
//

//////////////////////////////////////////////////////////////////////
// XQStaticContext.h: interface for the XQuery static context.
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_XQSTATICCONTEXT_H__D608B994_E090_4206_4973_81F3D7350410__INCLUDED_)
#define AFX_XQSTATICCONTEXT_H__D608B994_E090_4206_4973_81F3D7350410__INCLUDED_

#include "../XQEngine.hpp"
#include <pathan/DocumentCache.hpp>
#include <xercesc/dom/DOMDocument.hpp>

class XQENGINE_API XQStaticContext
{
public:
  virtual ~XQStaticContext() {};

  typedef enum {
    CONSTRUCTION_MODE_PRESERVE,
    CONSTRUCTION_MODE_STRIP
  } ConstructionMode;

  /** Returns the DOM document used to build the output nodes */
  virtual XERCES_CPP_NAMESPACE::DOMDocument *getOutputDocument() const = 0;

  /** Binds a prefix to a namespace URI */
  virtual void setNamespaceBinding(const XMLCh* prefix, const XMLCh* uri) = 0;

  /** Return the construction mode */
  virtual ConstructionMode getConstructionMode() const = 0;
  /** Set the construction mode */
  virtual void setConstructionMode(ConstructionMode newMode) = 0;

  /** Set the policy for XML space */
  virtual void setPreserveXMLSpace(bool value) = 0;
  /** Get the policy for XML space */
  virtual bool getPreserveXMLSpace() const = 0;

  /// The enableDebuging flag is considered to be in both the static and dynamic contexts
  virtual void enableDebugging(bool enable=true) = 0;
  /// The enableDebuging flag is considered to be in both the static and dynamic contexts
  virtual bool isDebuggingEnabled() const = 0;
};

#endif // !defined(AFX_XQSTATICCONTEXT_H__D608B994_E090_4206_4973_81F3D7350410__INCLUDED_)
