
/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <xercesc/dom/DOMImplementationRegistry.hpp>
#include <xercesc/util/PlatformUtils.hpp>

#include <pathan/internal/XPath2MemoryManagerImpl.hpp>

#include <pathan/PathanPlatformUtils.hpp>
#include <pathan/PathanImplementation.hpp>

#include <pathan/internal/m_apm.h>

static int gInitFlag = 0;

void PathanPlatformUtils::initialize(XERCES_CPP_NAMESPACE_QUALIFIER MemoryManager *memMgr) {
  XERCES_CPP_NAMESPACE_QUALIFIER XMLPlatformUtils::
    Initialize(XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgXercescDefaultLocale, 0, 0, memMgr);
  XERCES_CPP_NAMESPACE_QUALIFIER XMLPlatformUtils::atomicIncrement(gInitFlag);
#if 0
  // NOTE: BDB XML/XQuery only -- PathanImplementation is for DOM level 3
  // support, which is not used by XQuery and BDB XML.  Others may
  // wish to re-enable this.
  PathanImplementation::initialize();
#endif
  m_apm_mt_initialize();
}

void PathanPlatformUtils::terminate() {
  if(gInitFlag == 0) {
    return;
  }

  if(XERCES_CPP_NAMESPACE_QUALIFIER XMLPlatformUtils::atomicDecrement(gInitFlag)==0) {
	  m_apm_free_all_mem_mt();
    m_apm_mt_terminate();
  }
#if 0
  PathanImplementation::terminate();
#endif
  XERCES_CPP_NAMESPACE_QUALIFIER XMLPlatformUtils::Terminate();
}
