/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <assert.h>
#include "VarTypeStoreImpl.hpp"
#include <pathan/internal/simpleVariables/VarHashEntryImpl.hpp>
#include <pathan/StaticContext.hpp>
#include <pathan/XPath2NSUtils.hpp>
#include <pathan/internal/DOMutils/XStr.hpp> // defines X()
#include <xercesc/framework/XMLBuffer.hpp>

VarTypeStoreImpl::VarTypeStoreImpl(XPath2MemoryManager* memMgr)
  : _store(memMgr)
{
}

VarTypeStoreImpl::~VarTypeStoreImpl()
{
  /* nothing to do */
}

void VarTypeStoreImpl::clear()
{
  _store.clear();
}

void VarTypeStoreImpl::addLocalScope()
{
  _store.addScope(Scope<SequenceType*>::LOCAL_SCOPE);
}

void VarTypeStoreImpl::addLogicalBlockScope()
{
  _store.addScope(Scope<SequenceType*>::LOGICAL_BLOCK_SCOPE);
}

void VarTypeStoreImpl::removeScope()
{
  _store.removeScope();
}

void VarTypeStoreImpl::declareGlobalVar(const XMLCh* namespaceURI,
                                        const XMLCh* name,
                                        SequenceType* value, 
                                        const StaticContext* context)
{
  _store.setGlobalVar(namespaceURI, name, value);
}

void VarTypeStoreImpl::declareVar(const XMLCh* namespaceURI,
                                  const XMLCh* name,
                                  SequenceType* value, 
                                  const StaticContext* context)
{
  _store.declareVar(namespaceURI, name, value);
}

SequenceType* VarTypeStoreImpl::getVar(const XMLCh* namespaceURI,
                                       const XMLCh* name,
                                       const StaticContext* context) const
{
	VarHashEntry<SequenceType*>* result = _store.getVar(namespaceURI, name);
	if(result)
		return result->getValue();
  return 0;
}

SequenceType* VarTypeStoreImpl::getGlobalVar(const XMLCh* namespaceURI,
                                             const XMLCh* name,
                                             const StaticContext* context) const
{
  VarHashEntry<SequenceType*>* result = _store.getGlobalVar(namespaceURI, name);
  if(result)
    return result->getValue();
  return 0;
}
