/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/internal/navigation/SelfAxis.hpp>

#include <pathan/Node.hpp>

NavStepImpl::Axis SelfAxis::getAxis() const {
  return NavStepImpl::SELF;
}

Result SelfAxis::createResult(DynamicContext* context) const
{
  return new SelfAxisResult(this, context);
}

SelfAxis::SelfAxisResult::SelfAxisResult(const NavStepImpl *step, DynamicContext *context)
  : AxisResult(step, context),
    toDo_(true)
{
}

const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *SelfAxis::SelfAxisResult::stepNext(DynamicContext *context)
{
  if(toDo_) {
    toDo_ = false;
    return contextNode_;
  }
  else {
    return 0;
  }
}
