/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/internal/navigation/PrecedingSiblingAxis.hpp>
#include <xercesc/dom/DOMNode.hpp>

NavStepImpl::Axis PrecedingSiblingAxis::getAxis() const {
  return NavStepImpl::PRECEDING_SIBLING;
}

Result PrecedingSiblingAxis::createResult(DynamicContext* context) const
{
  return new PrecedingSiblingAxisResult(this, context);
}

PrecedingSiblingAxis::PrecedingSiblingAxisResult::PrecedingSiblingAxisResult(const NavStepImpl *step, DynamicContext *context)
  : AxisResult(step, context),
    toDo_(true),
    sibling_(0)
{
}

const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *PrecedingSiblingAxis::PrecedingSiblingAxisResult::stepNext(DynamicContext *context)
{
  // Behaves like descendant axis, but pretends that the only nodes with children
  // are entity reference nodes. In this way, entity reference node's children
  // are added to the axis results.

  if(toDo_) {
    // initialise
    toDo_ = false;
    sibling_ = contextNode_->getPreviousSibling();
    contextNode_ = contextNode_->getParentNode();
    while(contextNode_ != 0 &&
          contextNode_->getNodeType() == XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ENTITY_REFERENCE_NODE) {
      contextNode_ = contextNode_->getParentNode();
    }
  }
  else if(sibling_ != 0) {
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *result = 0;

    if(sibling_->getNodeType() == XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ENTITY_REFERENCE_NODE) {
      result = sibling_->getLastChild();
    }

    while(result == 0 && sibling_ != contextNode_) {
      result = sibling_->getPreviousSibling();
      if(result == 0) {
        sibling_ = sibling_->getParentNode();
      }
    }

    sibling_ = result;
  }

  return sibling_;
}
