/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/internal/navigation/PrecedingAxis.hpp>

#include <pathan/Node.hpp>

#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMElement.hpp>

NavStepImpl::Axis PrecedingAxis::getAxis() const {
  return NavStepImpl::PRECEDING;
}

Result PrecedingAxis::createResult(DynamicContext* context) const
{
  return new PrecedingAxisResult(this, context);
}

PrecedingAxis::PrecedingAxisResult::PrecedingAxisResult(const NavStepImpl *step, DynamicContext *context)
  : AxisResult(step, context),
    toDo_(true),
    node_(0)
{
}

const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *PrecedingAxis::PrecedingAxisResult::stepNext(DynamicContext *context)
{
  if(toDo_) {
    // initialise
    toDo_ = false;
    node_ = contextNode_;
    contextNode_ = contextNode_->getParentNode();
  }
  
  if(node_ != 0) {
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *result = node_->getPreviousSibling();

    while(result == 0) {
      node_ = node_->getParentNode();
      if(node_ != 0 && node_ == contextNode_) {
        contextNode_ = contextNode_->getParentNode();
        result = node_->getPreviousSibling();
     }
      else {
        break;
      }
    }

    while(result != 0) {
      node_ = result;
      result = node_->getLastChild();
    }
  }

  return node_;
}
