/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/internal/navigation/ParentAxis.hpp>
#include <xercesc/dom/DOMNode.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMElement.hpp>
#include <xercesc/dom/DOMXPathNamespace.hpp>
#include <pathan/Node.hpp>

NavStepImpl::Axis ParentAxis::getAxis() const {
  return NavStepImpl::PARENT;
}

Result ParentAxis::createResult(DynamicContext* context) const
{
  return new ParentAxisResult(this, context);
}

ParentAxis::ParentAxisResult::ParentAxisResult(const NavStepImpl *step, DynamicContext *context)
  : AxisResult(step, context),
    toDo_(true)
{
}

const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *ParentAxis::ParentAxisResult::stepNext(DynamicContext *context)
{
  if(toDo_) {
    // initialise
    toDo_ = false;

    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *result = 0;
    switch(contextNode_->getNodeType()) {
    case XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ATTRIBUTE_NODE: {
      result =  static_cast<const XERCES_CPP_NAMESPACE_QUALIFIER DOMAttr *>(contextNode_)->getOwnerElement();
      break;
    }
    case XERCES_CPP_NAMESPACE_QUALIFIER DOMXPathNamespace::XPATH_NAMESPACE_NODE: {
      result = 0;
      break;
    }
    default: {
      result = contextNode_->getParentNode();
      break;
    }
    }

    while(result != 0 && result->getNodeType() == XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ENTITY_REFERENCE_NODE) {
      result = result->getParentNode();
    }
    return result;
  }
  else {
    return 0;
  }
}
