/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/internal/navigation/NamespaceAxis.hpp>
#include <pathan/Node.hpp>
#include <xercesc/util/XMLUni.hpp>
#include <xercesc/dom/DOMNode.hpp>
#include <pathan/XPath2NSUtils.hpp>
#include "../dom-extensions/impl/XPathNamespaceImpl.hpp"
#include <pathan/exceptions/NavigationException.hpp>
#include <pathan/internal/factory/DatatypeFactory.hpp>

NavStepImpl::Axis NamespaceAxis::getAxis() const {
  return NavStepImpl::NAMESPACE;
}

Result NamespaceAxis::createResult(DynamicContext* context) const
{
  const Item::Ptr item = context->getContextItem();

  if(item == NULLRCP || !item->isNode()) {
    DSLthrow(NavigationException,X("NamespaceAxis::createResult"), X("An attempt was made to perform an axis step when the Context Item was not a node [err:XP0020]"));
  }

  const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *contextNode = ((Node*)(const Item*)item)->getDOMNode();
  if(contextNode==NULL) {
    DSLthrow(NavigationException,X("NamespaceAxis::createResult"), X("An attempt was made to perform an axis step when the Context Item was not a node [err:XP0020]"));
  }

  XPath2MemoryManager* memMgr=context->getMemoryManager();
  Sequence returnList = Sequence(memMgr);

  //If this isn't an element, then return nothing
  if(contextNode->getNodeType() != XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ELEMENT_NODE) {
    return returnList;
  }

  namespaceMapType nsMap;
  //nsMap["xml"] = "http://www.w3.org/XML/1998/namespace";
  nsMap[XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgXMLString] = XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgXMLURIName;

  std::map<const XMLCh* , XERCES_CPP_NAMESPACE_QUALIFIER DOMNode*, XMLChSort> nodeMap;

  const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *tmpNode = contextNode;
  while(tmpNode != 0) {
    //For each element, go through the attributes, and add any namespace bindings..
    XPath2NSUtils::addBindings(tmpNode, &nsMap, memMgr);

    namespaceMapType::iterator i = nsMap.begin();
    namespaceMapType::iterator e = nsMap.end();

    for(;i != e; i++) {
      std::map<const XMLCh* , XERCES_CPP_NAMESPACE_QUALIFIER DOMNode*, XMLChSort>::iterator tmpIter = nodeMap.find(i->first);
      if(tmpIter == nodeMap.end()) {

        XERCES_CPP_NAMESPACE_QUALIFIER DOMXPathNamespace *newNSNode = XPathNamespaceImpl::createXPathNamespace(i->first,i->second, static_cast<XERCES_CPP_NAMESPACE_QUALIFIER  DOMElement *>(const_cast<XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *>(tmpNode)));
        nodeMap[i->first] = newNSNode;

        if(filterNode(newNSNode, context))
          returnList.addItem(DatatypeFactory::POD2AT::createNode(newNSNode, context));
      }

    }
    tmpNode = tmpNode->getParentNode();
  }

  return returnList;
}
