/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/internal/navigation/FollowingSiblingAxis.hpp>
#include <xercesc/dom/DOMNode.hpp>
#include <pathan/Node.hpp>

NavStepImpl::Axis FollowingSiblingAxis::getAxis() const {
  return NavStepImpl::FOLLOWING_SIBLING;
}

Result FollowingSiblingAxis::createResult(DynamicContext* context) const
{
  return new FollowingSiblingAxisResult(this, context);
}

FollowingSiblingAxis::FollowingSiblingAxisResult::FollowingSiblingAxisResult(const NavStepImpl *step, DynamicContext *context)
  : AxisResult(step, context),
    toDo_(true),
    node_(0)
{
}

const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *FollowingSiblingAxis::FollowingSiblingAxisResult::stepNext(DynamicContext *context)
{
  // Behaves like descendant axis, but pretends that the only nodes with children
  // are entity reference nodes. In this way, entity reference node's children
  // are added to the axis results.

  if(toDo_) {
    // initialise
    toDo_ = false;
    node_ = contextNode_->getNextSibling();
    contextNode_ = contextNode_->getParentNode();
    while(contextNode_ != 0 &&
          contextNode_->getNodeType() == XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ENTITY_REFERENCE_NODE) {
      contextNode_ = contextNode_->getParentNode();
    }
  }
  else if(node_ != 0) {
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *result = 0;

    if(node_->getNodeType() == XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ENTITY_REFERENCE_NODE) {
      result = node_->getFirstChild();
    }

    while(result == 0 && node_ != contextNode_) {
      result = node_->getNextSibling();
      if(result == 0) {
        node_ = node_->getParentNode();
      }
    }

    node_ = result;
  }

  return node_;
}
