/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/internal/navigation/FollowingAxis.hpp>

#include <pathan/Node.hpp>

#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMElement.hpp>

NavStepImpl::Axis FollowingAxis::getAxis() const {
  return NavStepImpl::FOLLOWING;
}

Result FollowingAxis::createResult(DynamicContext* context) const
{
  return new FollowingAxisResult(this, context);
}

FollowingAxis::FollowingAxisResult::FollowingAxisResult(const NavStepImpl *step, DynamicContext *context)
  : AxisResult(step, context),
    toDo_(true),
    node_(0)
{
}

const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *FollowingAxis::FollowingAxisResult::stepNext(DynamicContext *context)
{
  if(toDo_) {
    // initialise
    toDo_ = false;
    node_ = contextNode_;
  }
  
  if(node_ != 0) {
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *result = 0;

    if(node_ != contextNode_) {
      result = node_->getFirstChild();
    }

    while(result == 0 && node_ != 0) {
      result = node_->getNextSibling();
      if(result == 0) {
        node_ = node_->getParentNode();
      }
    }

    node_ = result;
  }

  return node_;
}
