/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/internal/navigation/DescendantOrSelfAxis.hpp>
#include <xercesc/dom/DOMNode.hpp>
#include <pathan/Node.hpp>

NavStepImpl::Axis DescendantOrSelfAxis::getAxis() const {
  return NavStepImpl::DESCENDANT_OR_SELF;
}

Result DescendantOrSelfAxis::createResult(DynamicContext* context) const
{
  return new DescendantOrSelfAxisResult(this, context);
}

DescendantOrSelfAxis::DescendantOrSelfAxisResult::DescendantOrSelfAxisResult(const NavStepImpl *step, DynamicContext *context)
  : AxisResult(step, context),
    toDo_(true),
    descendant_(0)
{
}

const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *DescendantOrSelfAxis::DescendantOrSelfAxisResult::stepNext(DynamicContext *context)
{
  if(toDo_) {
    // initialise
    toDo_ = false;
    descendant_ = contextNode_;
  }
  else if(descendant_ != 0) {
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *result = descendant_->getFirstChild();

    while(result == 0 && descendant_ != contextNode_) {
      result = descendant_->getNextSibling();
      if(result == 0) {
        descendant_ = descendant_->getParentNode();
      }
    }

    descendant_ = result;
  }

  return descendant_;
}
