/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/internal/navigation/DescendantAxis.hpp>
#include <xercesc/dom/DOMNode.hpp>
#include <pathan/Node.hpp>

NavStepImpl::Axis DescendantAxis::getAxis() const {
  return NavStepImpl::DESCENDANT;
}

Result DescendantAxis::createResult(DynamicContext* context) const
{
  return new DescendantAxisResult(this, context);
}

DescendantAxis::DescendantAxisResult::DescendantAxisResult(const NavStepImpl *step, DynamicContext *context)
  : AxisResult(step, context),
    toDo_(true),
    descendant_(0)
{
}

const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *DescendantAxis::DescendantAxisResult::stepNext(DynamicContext *context)
{
  if(toDo_) {
    // initialise
    toDo_ = false;
    descendant_ = contextNode_->getFirstChild();
  }
  else if(descendant_ != 0) {
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *result = descendant_->getFirstChild();

    while(result == 0) {
      result = descendant_->getNextSibling();
      if(result == 0) {
        descendant_ = descendant_->getParentNode();
        if(descendant_ == contextNode_) break;
      }
    }

    descendant_ = result;
  }

  return descendant_;
}
