/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/internal/navigation/ChildAxis.hpp>
#include <xercesc/dom/DOMNode.hpp>
#include <pathan/Node.hpp>

NavStepImpl::Axis ChildAxis::getAxis() const {
  return NavStepImpl::CHILD;
}

Result ChildAxis::createResult(DynamicContext* context) const
{
  return new ChildAxisResult(this, context);
}

ChildAxis::ChildAxisResult::ChildAxisResult(const NavStepImpl *step, DynamicContext *context)
  : AxisResult(step, context),
    toDo_(true),
    child_(0)
{
}

const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *ChildAxis::ChildAxisResult::stepNext(DynamicContext *context)
{
  // Behaves like descendant axis, but pretends that the only nodes with children
  // are entity reference nodes. In this way, entity reference node's children
  // are added to the axis results.

  if(toDo_) {
    // initialise
    toDo_ = false;
    child_ = contextNode_->getFirstChild();
  }
  else if(child_ != 0) {
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *result = 0;

    if(child_->getNodeType() == XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ENTITY_REFERENCE_NODE) {
      result = child_->getFirstChild();
    }

    while(result == 0) {
      result = child_->getNextSibling();
      if(result == 0) {
        child_ = child_->getParentNode();
        if(child_ == contextNode_) break;
      }
    }

    child_ = result;
  }

  return child_;
}
