/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/internal/navigation/AttributeAxis.hpp>
#include <pathan/XPath2Utils.hpp>
#include <pathan/Node.hpp>
#include <xercesc/util/XMLUni.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/dom/DOMNode.hpp>

NavStepImpl::Axis AttributeAxis::getAxis() const {
  return NavStepImpl::ATTRIBUTE;
}

Result AttributeAxis::createResult(DynamicContext* context) const
{
  return new AttributeAxisResult(this, context);
}

AttributeAxis::AttributeAxisResult::AttributeAxisResult(const NavStepImpl *step, DynamicContext *context)
  : AxisResult(step, context),
    toDo_(true),
    nodeMap_(0),
    i_(0)
{
}

const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *AttributeAxis::AttributeAxisResult::stepNext(DynamicContext *context)
{
  if(toDo_) {
    // initialise
    toDo_ = false;
    nodeMap_ = contextNode_->getAttributes();
  }
  
  XERCES_CPP_NAMESPACE_QUALIFIER DOMNode* attr = 0;
  while(nodeMap_ != 0 && i_ < nodeMap_->getLength() && attr == 0) {
    attr = nodeMap_->item(i_);
    ++i_;
    if(XPath2Utils::equals(attr->getNamespaceURI(),XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgXMLNSURIName)) {
      attr = 0;
    }
  }

  return attr;
}
