/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/internal/navigation/AncestorOrSelfAxis.hpp>
#include <xercesc/dom/DOMNode.hpp>
#include <pathan/XPath2NSUtils.hpp>

NavStepImpl::Axis AncestorOrSelfAxis::getAxis() const {
  return NavStepImpl::ANCESTOR_OR_SELF;
}

Result AncestorOrSelfAxis::createResult(DynamicContext* context) const
{
  return new AncestorOrSelfAxisResult(this, context);
}

AncestorOrSelfAxis::AncestorOrSelfAxisResult::AncestorOrSelfAxisResult(const NavStepImpl *step, DynamicContext *context)
  : AxisResult(step, context),
    toDo_(true),
    ancestor_(0)
{
}

const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *AncestorOrSelfAxis::AncestorOrSelfAxisResult::stepNext(DynamicContext *context)
{
  if(toDo_) {
    // initialise
    toDo_ = false;
    ancestor_ = contextNode_;
  }
  else if(ancestor_ != 0) {
    ancestor_ = XPath2NSUtils::getParent(ancestor_);
  }

  return ancestor_;
}
