/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/internal/navigation/AncestorAxis.hpp>
#include <xercesc/dom/DOMNode.hpp>
#include <pathan/XPath2NSUtils.hpp>

NavStepImpl::Axis AncestorAxis::getAxis() const {
  return NavStepImpl::ANCESTOR;
}

Result AncestorAxis::createResult(DynamicContext* context) const
{
  return new AncestorAxisResult(this, context);
}

AncestorAxis::AncestorAxisResult::AncestorAxisResult(const NavStepImpl *step, DynamicContext *context)
  : AxisResult(step, context),
    toDo_(true),
    ancestor_(0)
{
}

const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *AncestorAxis::AncestorAxisResult::stepNext(DynamicContext *context)
{
  if(toDo_) {
    // initialise
    toDo_ = false;
    ancestor_ = contextNode_;
  }

  if(ancestor_ != 0) {
    ancestor_ = XPath2NSUtils::getParent(ancestor_);
  }

  return ancestor_;
}
