/*
 * Copyright (c) 2003, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _PATHANNODEIMPL_HPP
#define _PATHANNODEIMPL_HPP

#include <pathan/Node.hpp>
#include <xercesc/util/XercesDefs.hpp>
#include <xercesc/framework/XMLBuffer.hpp>

class DynamicContext;
class XPath2MemoryManager;
class Sequence;
class DocumentCache;

XERCES_CPP_NAMESPACE_BEGIN
class DatatypeValidator;
class DOMWriter;
class DOMNode;
XERCES_CPP_NAMESPACE_END

class PATHAN_EXPORT NodeImpl : public Node
{
public:
  NodeImpl(const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *node, const DynamicContext *context);
  ~NodeImpl();

  virtual bool isNode() const;
  virtual bool isAtomicValue() const;
  virtual const XMLCh* asString(const DynamicContext* context) const;
  virtual bool hasInstanceOfType(const XMLCh* typeURI, const XMLCh* typeName, const DynamicContext* context) const;

  virtual Sequence dmBaseURI(const DynamicContext* context) const;
  virtual const XMLCh* dmNodeKind() const;
  virtual Sequence dmNodeName(const DynamicContext* context) const;
  virtual const XMLCh* dmStringValue(const DynamicContext* context) const;
  virtual Sequence dmTypedValue(const DynamicContext* context) const;

  virtual Sequence dmDocumentURI(const DynamicContext* context) const;
  virtual Sequence dmTypeName(const DynamicContext* context) const;

  virtual Sequence dmNilled(const DynamicContext* context) const;

  virtual bool lessThan(const Node::Ptr &other) const;
  virtual bool equals(const Node::Ptr &other) const;

  virtual const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode* getDOMNode() const;

  virtual const XMLCh* getTypeURI() const;
  virtual const XMLCh* getTypeName() const;

  static const XMLCh ls_string[];

private:

  void getTypeUriAndName(const XMLCh*& uri, const XMLCh*& name) const;
  void getMemberTypeUriAndName(const XMLCh*& uri, const XMLCh*& name) const;
  Sequence getListTypeTypedValue(XERCES_CPP_NAMESPACE_QUALIFIER DatatypeValidator *dtv, const DynamicContext* context) const;
  void addStringValueToBuffer(const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode* node, XERCES_CPP_NAMESPACE_QUALIFIER XMLBuffer& buffer) const;

  XERCES_CPP_NAMESPACE_QUALIFIER DOMWriter *fSerializer;

  const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode* fNode;
  const DynamicContext *_context;
};
#endif
