/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */
  
#include "../../config/pathan_config.h"
#include "ATHexBinaryOrDerivedImpl.hpp"
#include <pathan/XPath2Utils.hpp>
#include <pathan/exceptions/IllegalArgumentException.hpp>
#include <xercesc/util/XMLUni.hpp>
#include <xercesc/validators/schema/SchemaSymbols.hpp>
#include <pathan/internal/DOMutils/XStr.hpp> // defines X() and XMLCh*
#include <pathan/XPath2MemoryManager.hpp>
#include <xercesc/util/XMLString.hpp>
#include <pathan/DynamicContext.hpp>

ATHexBinaryOrDerivedImpl::
ATHexBinaryOrDerivedImpl(const XMLCh* typeURI, const XMLCh* typeName, const XMLCh* value, const StaticContext* context): 
    ATHexBinaryOrDerived(),
    _typeName(typeName),
    _typeURI(typeURI) { 
    
  // revisit: have to cast away the const.  a bit nasty. 
  XERCES_CPP_NAMESPACE_QUALIFIER XMLString::upperCase(const_cast<XMLCh*>(value));
  _hexBinaryData = context->getMemoryManager()->getPooledString(value);
}

/* Get the name of the primitive type (basic type) of this type
 * (ie "decimal" for xs:decimal) */
const XMLCh* ATHexBinaryOrDerivedImpl::getPrimitiveTypeName() const {
  return this->getPrimitiveName();
}

const XMLCh* ATHexBinaryOrDerivedImpl::getPrimitiveName()  {
  return XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_HEXBINARY;
}

/* Get the name of this type  (ie "integer" for xs:integer) */
const XMLCh* ATHexBinaryOrDerivedImpl::getTypeName() const {
  return _typeName;
}

/* Get the namespace URI for this type */
const XMLCh* ATHexBinaryOrDerivedImpl::getTypeURI() const {
  return _typeURI; 
}

AnyAtomicType::AtomicObjectType ATHexBinaryOrDerivedImpl::getTypeIndex() {
  return AnyAtomicType::HEX_BINARY;
} 

/* returns the XMLCh* (canonical) representation of this type */
const XMLCh* ATHexBinaryOrDerivedImpl::asString(const DynamicContext* context) const {
  return _hexBinaryData;
}

/* returns true if the two objects' URI are equal (string comparison)
   * false otherwise */
bool ATHexBinaryOrDerivedImpl::equals(const AnyAtomicType::Ptr &target, const DynamicContext* context) const {
  if(this->getPrimitiveTypeIndex() != target->getPrimitiveTypeIndex()) {
    DSLthrow(IllegalArgumentException,X("ATHexBinaryOrDerivedImpl::equals"), X("Equality operator for given types not supported"));
  }
  return XPath2Utils::equals(target->asString(context), _hexBinaryData);
}

AnyAtomicType::AtomicObjectType ATHexBinaryOrDerivedImpl::getPrimitiveTypeIndex() const {
  return this->getTypeIndex();
}
