/*
 * Copyright (c) 2004, Parthenon Computing Limited, All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include <sstream>

#include "../config/pathan_config.h"
#include <pathan/NodeConstructor.hpp>
#include <pathan/internal/factory/DatatypeFactory.hpp>

#include <pathan/internal/utils/UTF8Str.hpp>

NodeConstructor::NodeConstructor(const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *node)
  : _node(node)
{
}

Item::Ptr NodeConstructor::createItem(const DynamicContext* context) const
{
  return DatatypeFactory::POD2AT::createNode(_node, context);
}

std::string NodeConstructor::asString(const DynamicContext* context) const
{
  std::ostringstream s;

  s << "<NodeConstructor";
  s << "/>";

  return s.str();
}
