/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <assert.h>
#include <pathan/functions/FunctionRoot.hpp>
#include <pathan/exceptions/FunctionException.hpp>
#include <pathan/DynamicContext.hpp>
#include <pathan/Sequence.hpp>
#include <pathan/Node.hpp>
#include <pathan/dataItem/StaticResolutionContext.hpp>
#include <xercesc/dom/DOMNode.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <pathan/internal/factory/DatatypeFactory.hpp>

const XMLCh FunctionRoot::name[] = {
XERCES_CPP_NAMESPACE_QUALIFIER chLatin_r, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_o, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_o, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_t, XERCES_CPP_NAMESPACE_QUALIFIER chNull };

/**
 * fn:root() as node()
 * fn:root($arg as node()?) as node()?
**/

FunctionRoot::FunctionRoot(const VectorOfDataItems &args, XPath2MemoryManager* memMgr)
  : DataItemFunction(name,0, 1, "node()?", args, memMgr)
{
}

/*static*/ const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode* FunctionRoot::root(const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *node) 
{
  XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *parent = NULL;
  if(node->getNodeType()==XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ATTRIBUTE_NODE)
    parent=(XERCES_CPP_NAMESPACE_QUALIFIER DOMNode*) ((XERCES_CPP_NAMESPACE_QUALIFIER DOMAttr*)node)->getOwnerElement();
  else
    parent=node->getParentNode();
  if (parent == NULL) return node;
  return root(parent);
}

DataItem* FunctionRoot::staticResolution(StaticContext *context, StaticResolutionContext *src) {
  if(_args.empty()) {
    src->contextItemUsed(true);
  }
  return resolveDataItems(_args, context, src, !_args.empty());
}

Sequence FunctionRoot::collapseTreeInternal(DynamicContext* context, int flags) const
{
	XPath2MemoryManager* memMgr = context->getMemoryManager();

  Node::Ptr node = NULL;
  if(getNumArgs() == 1)
  {
    Sequence arg1=getParamNumber(1,context);
    if(arg1.isEmpty())
      return Sequence(memMgr);
    node = (const Node::Ptr )arg1.first();
  }
  else
  {
    const Item::Ptr item = context->getContextItem();
    if(item==NULLRCP || !item->isNode()) {
      DSLthrow(FunctionException, X("FunctionRoot::collapseTreeInternal"), X("Function 'root' invoked with no context node"));
    }
    node = (const Node::Ptr )item;
  }
  return Sequence(DatatypeFactory::POD2AT::createNode(root(node->getDOMNode()), context), memMgr);
}
