/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/functions/FunctionNot.hpp>
#include <pathan/ATBooleanOrDerived.hpp>
#include <pathan/DynamicContext.hpp>
#include <pathan/internal/factory/DatatypeFactory.hpp>

const XMLCh FunctionNot::name[] = {
XERCES_CPP_NAMESPACE_QUALIFIER chLatin_n, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_o, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_t, XERCES_CPP_NAMESPACE_QUALIFIER chNull };

/**
 * fn:not($arg as item()*) as xs:boolean
**/

FunctionNot::FunctionNot(const VectorOfDataItems &args, XPath2MemoryManager* memMgr)
  : ConstantFoldingFunction(name,1,1, "item()*", args, memMgr)
{
}

Sequence FunctionNot::collapseTreeInternal(DynamicContext* context, int flags) const
{
	bool result = !getParamNumber(1,context,DataItem::UNORDERED|DataItem::RETURN_TWO).getEffectiveBooleanValue(context);
	XPath2MemoryManager* memMgr = context->getMemoryManager();
	return Sequence(DatatypeFactory::POD2AT::createBoolean(result, context), memMgr);
}
