/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/functions/FunctionNilled.hpp>

#include <pathan/DynamicContext.hpp>
#include <pathan/ATBooleanOrDerived.hpp>
#include <pathan/Node.hpp>
#include <pathan/internal/factory/DatatypeFactory.hpp>
#include <pathan/XPath2Utils.hpp>
#include <xercesc/dom/DOM.hpp>
#include <xercesc/validators/schema/SchemaSymbols.hpp>

const XMLCh FunctionNilled::name[] = {
XERCES_CPP_NAMESPACE_QUALIFIER chLatin_n, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_i, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_l, 
XERCES_CPP_NAMESPACE_QUALIFIER chLatin_l, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_e, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_d, 
XERCES_CPP_NAMESPACE_QUALIFIER chNull };

/*
 * fn:nilled($arg as node) as boolean?
 */

FunctionNilled::FunctionNilled(const VectorOfDataItems &args, XPath2MemoryManager* memMgr)
  : DataItemFunction(name, 1, 1, "node()", args, memMgr)
{
}

DataItem* FunctionNilled::staticResolution(StaticContext *context, StaticResolutionContext *src) {
  return resolveDataItems(_args, context, src, false);
}

Sequence FunctionNilled::collapseTreeInternal(DynamicContext* context, int flags) const
{
  Sequence arg = getParamNumber(1, context);

  //If the argument is not an element, the empty sequence is returned.
  
  const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode* node=((Node*)(const Item*)arg.first())->getDOMNode();
  if(node->getNodeType()!=XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ELEMENT_NODE) {
    return Sequence(context->getMemoryManager());
  }

  const XMLCh* isNilled=((XERCES_CPP_NAMESPACE_QUALIFIER DOMElement*)node)->getAttributeNS(XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_XSI,XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgATT_NILL);

  return Sequence(DatatypeFactory::POD2AT::createBoolean(XPath2Utils::equals(isNilled,XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgATTVAL_TRUE), context), context->getMemoryManager());
}
