/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <assert.h>
#include <pathan/functions/FunctionNamespaceUri.hpp>
#include <pathan/DynamicContext.hpp>
#include <pathan/exceptions/FunctionException.hpp>
#include <xercesc/dom/DOM.hpp>
#include <xercesc/util/XMLString.hpp>
#include <pathan/internal/factory/DatatypeFactory.hpp>
#include <pathan/Node.hpp>
#include <pathan/ATStringOrDerived.hpp>
#include <pathan/dataItem/StaticResolutionContext.hpp>

const XMLCh FunctionNamespaceUri::name[] = {
XERCES_CPP_NAMESPACE_QUALIFIER chLatin_n, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_a, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_m, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_e, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_s, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_p, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_a, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_c, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_e, XERCES_CPP_NAMESPACE_QUALIFIER chDash, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_u, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_r, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_i, XERCES_CPP_NAMESPACE_QUALIFIER chNull };

/**
 * fn:namespace-uri() as xs:string
 * fn:namespace-uri($arg as node()?) as xs:string
**/

FunctionNamespaceUri::FunctionNamespaceUri(const VectorOfDataItems &args, XPath2MemoryManager* memMgr)
  : DataItemFunction(name,0, 1, "node()?", args, memMgr)
{
}

DataItem* FunctionNamespaceUri::staticResolution(StaticContext *context, StaticResolutionContext *src) {
  if(_args.empty()) {
    src->contextItemUsed(true);
  }
  return resolveDataItems(_args, context, src, !_args.empty());
}

Sequence FunctionNamespaceUri::collapseTreeInternal(DynamicContext* context, int flags) const
{
  const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *node=0;
  XPath2MemoryManager* memMgr = context->getMemoryManager();

  if(getNumArgs() == 1)
  {
    Sequence arg=getParamNumber(1,context);
    if(arg.isEmpty()) { 
      return Sequence(DatatypeFactory::STR2AT::createString(XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString, context), memMgr);
    }
    node=((Node*)(const Item*)arg.first())->getDOMNode();
  }
  else
  {
    const Item::Ptr item = context->getContextItem();
    if(item==NULLRCP || !item->isNode()) {
      return Sequence(DatatypeFactory::STR2AT::createString(XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString, context), memMgr);
    }
    node = ((Node*)(const Item*)item)->getDOMNode();
  }

  switch(node->getNodeType()) {
    case XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ATTRIBUTE_NODE:
    case XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ELEMENT_NODE: {
      const XMLCh* uri = node->getNamespaceURI();
      if(uri)
        return Sequence(DatatypeFactory::STR2AT::createString(uri, context), memMgr);
      break;
   }
  }
  
  return Sequence(DatatypeFactory::STR2AT::createString(XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString, context), memMgr);
}
