/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/functions/FunctionName.hpp>
#include <pathan/XPath2NSUtils.hpp>
#include <pathan/DynamicContext.hpp>
#include <pathan/Node.hpp>
#include <pathan/ATStringOrDerived.hpp>
#include <pathan/internal/factory/DatatypeFactory.hpp>
#include <xercesc/dom/DOMXPathNamespace.hpp>
#include <xercesc/util/XMLUni.hpp>
#include <pathan/internal/DOMutils/XStr.hpp>
#include <pathan/dataItem/StaticResolutionContext.hpp>

const XMLCh FunctionName::name[] = {
XERCES_CPP_NAMESPACE_QUALIFIER chLatin_n, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_a, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_m, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_e, XERCES_CPP_NAMESPACE_QUALIFIER chNull };

/**
 * fn:name() as xs:string
 * fn:name($arg as node()?) as xs:string
**/

FunctionName::FunctionName(const VectorOfDataItems &args, XPath2MemoryManager* memMgr)
  : DataItemFunction(name,0, 1, "node()?", args, memMgr)
{
}

DataItem* FunctionName::staticResolution(StaticContext *context, StaticResolutionContext *src) {
  if(_args.empty()) {
    src->contextItemUsed(true);
  }
  return resolveDataItems(_args, context, src, !_args.empty());
}

Sequence FunctionName::collapseTreeInternal(DynamicContext* context, int flags) const
{
  const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *node=0;
  XPath2MemoryManager* memMgr = context->getMemoryManager();

  if(getNumArgs() == 1)
  {
    Sequence arg=getParamNumber(1,context);
    if(arg.isEmpty()) { 
      return Sequence(DatatypeFactory::STR2AT::createString(XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString, context), memMgr);
    }
    node=((Node*)(const Item*)arg.first())->getDOMNode();
  }
  else
  {
    const Item::Ptr item = context->getContextItem();
    if(item==NULLRCP || !item->isNode())
      return Sequence(DatatypeFactory::STR2AT::createString(XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString, context), memMgr);
    node = ((Node*)(const Item*)item)->getDOMNode();
  }

  switch(node->getNodeType()) {
    case XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ATTRIBUTE_NODE:
    case XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ELEMENT_NODE: {
      const XMLCh *qname = XPath2NSUtils::qualifyName(node->lookupNamespacePrefix(node->getNamespaceURI(), false), node->getLocalName(), memMgr);
      return Sequence(DatatypeFactory::STR2AT::createString(qname, context), memMgr);
    }
    case XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::PROCESSING_INSTRUCTION_NODE:  return Sequence(DatatypeFactory::STR2AT::createString(node->getNodeName(), context), memMgr);
    case XERCES_CPP_NAMESPACE_QUALIFIER DOMXPathNamespace::XPATH_NAMESPACE_NODE:  return Sequence(DatatypeFactory::STR2AT::createString(node->getPrefix(), context), memMgr);
  }
  return Sequence(DatatypeFactory::STR2AT::createString(XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString, context), memMgr);
}







