/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <assert.h>
#include <pathan/functions/FunctionLocalname.hpp>
#include <pathan/exceptions/FunctionException.hpp>
#include <pathan/DynamicContext.hpp>
#include <pathan/internal/factory/DatatypeFactory.hpp>
#include <xercesc/dom/DOMNode.hpp>
#include <xercesc/dom/DOMXPathNamespace.hpp>
#include <xercesc/util/XMLUni.hpp>
#include <pathan/Node.hpp>
#include <pathan/ATStringOrDerived.hpp>
#include <pathan/dataItem/StaticResolutionContext.hpp>

const XMLCh FunctionLocalname::name[] = {
XERCES_CPP_NAMESPACE_QUALIFIER chLatin_l, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_o, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_c, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_a, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_l, XERCES_CPP_NAMESPACE_QUALIFIER chDash, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_n, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_a, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_m, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_e, XERCES_CPP_NAMESPACE_QUALIFIER chNull };

/**
 * fn:local-name() as xs:string
 * fn:local-name($arg as node()?) as xs:string
**/

FunctionLocalname::FunctionLocalname(const VectorOfDataItems &args, XPath2MemoryManager* memMgr)
  : DataItemFunction(name,0, 1, "node()?", args, memMgr)
{
}

DataItem* FunctionLocalname::staticResolution(StaticContext *context, StaticResolutionContext *src) {
  if(_args.empty()) {
    src->contextItemUsed(true);
  }
  return resolveDataItems(_args, context, src, !_args.empty());
}

Sequence FunctionLocalname::collapseTreeInternal(DynamicContext* context, int flags) const
{
	// Use the nodelist
	const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *node=0;

	XPath2MemoryManager* memMgr = context->getMemoryManager();

	if(getNumArgs() == 0)
	{
		const Item::Ptr item = context->getContextItem();
		if(item!=NULLRCP && item->isNode())
			node = ((Node*)(const Item*)item)->getDOMNode();
	}
	else
	{
		Sequence nodelist = getParamNumber(1, context);
		if(nodelist.isEmpty())
			return Sequence(DatatypeFactory::STR2AT::createString(XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString, context), memMgr);
		node = ((Node*)(const Item*)nodelist.first())->getDOMNode();
	}

	if(node != 0)
	{
		switch(node->getNodeType())
		{
		case XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ATTRIBUTE_NODE:
		case XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::ELEMENT_NODE:
		case XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::PROCESSING_INSTRUCTION_NODE:
        case XERCES_CPP_NAMESPACE_QUALIFIER DOMXPathNamespace::XPATH_NAMESPACE_NODE:
			{
				const XMLCh *result = node->getLocalName();
				if( result == 0 )
					result = node->getNodeName();
				return Sequence(DatatypeFactory::STR2AT::createString(result, context), memMgr);
			}
			break;
		case XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::DOCUMENT_NODE:
		case XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::COMMENT_NODE:
		case XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::TEXT_NODE:
			return Sequence(DatatypeFactory::STR2AT::createString(XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString, context), memMgr);
		default:
			{
				assert(false);
				DSLthrow(FunctionException,X("FunctionLocalname::collapseTreeInternal"), X("Unknown node type"));
				break;
			}
		}
	}

	return Sequence(DatatypeFactory::STR2AT::createString(XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString, context), memMgr);
}





