/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/functions/FunctionIndexOf.hpp>
#include <pathan/Sequence.hpp>
#include <pathan/AnyAtomicType.hpp>
#include <pathan/ATAnyURIOrDerived.hpp>
#include <pathan/ATDecimalOrDerived.hpp>
#include <pathan/ATStringOrDerived.hpp>
#include <pathan/exceptions/FunctionException.hpp>
#include <pathan/exceptions/XPath2ErrorException.hpp>
#include <pathan/Collation.hpp>
#include <pathan/internal/collations/CodepointCollation.hpp>
#include <pathan/DynamicContext.hpp>
#include <pathan/internal/factory/DatatypeFactory.hpp>
#include <xercesc/validators/schema/SchemaSymbols.hpp>

const XMLCh FunctionIndexOf::name[] = {
XERCES_CPP_NAMESPACE_QUALIFIER chLatin_i, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_n, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_d, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_e, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_x, XERCES_CPP_NAMESPACE_QUALIFIER chDash, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_o, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_f, XERCES_CPP_NAMESPACE_QUALIFIER chNull };

/**
 * fn:index-of($seqParam as xdt:anyAtomicType*, $srchParam as xdt:anyAtomicType) as xs:integer*
 * fn:index-of($seqParam as xdt:anyAtomicType*, $srchParam as xdt:anyAtomicType, $collation as xs:string) as xs:integer*
**/

FunctionIndexOf::FunctionIndexOf(const VectorOfDataItems &args, XPath2MemoryManager* memMgr)
  : ConstantFoldingFunction(name,2, 3, "anyAtomicType*, anyAtomicType, string", args, memMgr)
{
}

Sequence FunctionIndexOf::indexOf(Sequence &list, const Item::Ptr &item, Collation* collation, const DynamicContext* context) const
{
  XPath2MemoryManager* memMgr = context->getMemoryManager();
  Sequence result = Sequence(list.getLength(),memMgr);
  int index = 1;
  Sequence::iterator end = list.end();
  const AnyAtomicType::Ptr atom = (const AnyAtomicType::Ptr )item;  
  const XMLCh* atomString = atom->asString(context);
  for(Sequence::iterator i = list.begin(); i != end; ++i,++index) {
    const AnyAtomicType::Ptr current = (const AnyAtomicType::Ptr )*i;
    if (current->isOfType(XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgURI_SCHEMAFORSCHEMA,
                          XERCES_CPP_NAMESPACE_QUALIFIER SchemaSymbols::fgDT_STRING, context)) {
      const XMLCh* currString = current->asString(context);
      if (collation->compare(currString, atomString) == 0)
        result.addItem(DatatypeFactory::POD2AT::createInteger(index, context));
    } else {
      if (current->equals(atom, context))
        result.addItem(DatatypeFactory::POD2AT::createInteger(index, context));
    }
  }
  return result;
}


Sequence FunctionIndexOf::collapseTreeInternal(DynamicContext* context, int flags) const
{
	XPath2MemoryManager* memMgr = context->getMemoryManager();
	Sequence list=getParamNumber(1,context).toSequence(context);
	if(list.isEmpty()) return Sequence(memMgr);
  const Item::Ptr srchparam = (const Item::Ptr )getParamNumber(2,context).next(context);
  
  Collation* collation=NULL;
  if (getNumArgs() > 2) {
    const XMLCh* collName=getParamNumber(3,context).next(context)->asString(context);
    try {
      DatatypeFactory::STR2AT::createAnyURI(collName, context);
    } catch(XPath2ErrorException &e) {
      DSLthrow(FunctionException, X("FunctionIndexOf::collapseTreeInternal"), X("Invalid collationURI"));  
    }
	  collation=context->getCollation(collName);
    if (collation==NULL)
      DSLthrow(FunctionException, X("FunctionIndexOf::collapseTreeInternal"), X("Collation object is not available"));
  }
  else
    collation = context->getDefaultCollation();
  if(collation==NULL)
    collation = context->getCollation(CodepointCollation::getCodepointCollationName());
  return indexOf(list, srchparam, collation, context);
}
