/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/functions/FunctionInScopePrefixes.hpp>
#include <pathan/ATStringOrDerived.hpp>
#include <pathan/Node.hpp>
#include <pathan/XPath2Utils.hpp>
#include <pathan/internal/DOMutils/XMLChCompare.hpp>
#include <pathan/DynamicContext.hpp>
#include <pathan/internal/factory/DatatypeFactory.hpp>
#include <xercesc/dom/DOMNode.hpp>
#include <xercesc/dom/DOMNamedNodeMap.hpp>
#include <xercesc/util/XMLString.hpp>

/**
 * fn:in-scope-prefixes($element as element) as xs:string*
**/

const XMLCh FunctionInScopePrefixes::name[] = {
XERCES_CPP_NAMESPACE_QUALIFIER chLatin_i, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_n,
XERCES_CPP_NAMESPACE_QUALIFIER chDash, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_s, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_c,
XERCES_CPP_NAMESPACE_QUALIFIER chLatin_o, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_p, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_e,
XERCES_CPP_NAMESPACE_QUALIFIER chDash, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_p, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_r,
XERCES_CPP_NAMESPACE_QUALIFIER chLatin_e, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_f, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_i,
XERCES_CPP_NAMESPACE_QUALIFIER chLatin_x, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_e, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_s,
XERCES_CPP_NAMESPACE_QUALIFIER chNull };


FunctionInScopePrefixes::FunctionInScopePrefixes(const VectorOfDataItems &args, XPath2MemoryManager* memMgr)
  : ConstantFoldingFunction(name,1, 1, "element()", args, memMgr)
{
}

void FunctionInScopePrefixes::addBindings(Sequence &s, const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *node, XMLChSet &ps, const DynamicContext* context) const
{
  //REVIST NS 1.1 changes this!!
  const XMLCh* prefix = node->getPrefix();
  if(prefix != 0) {
    if(ps.find(prefix) == ps.end()) {
      ps.insert(prefix);
      s.addItem(DatatypeFactory::STR2AT::createString(prefix, context));
    }
  }

	XERCES_CPP_NAMESPACE_QUALIFIER DOMNamedNodeMap *attrs = node->getAttributes();

	if (attrs != 0) {
		for (unsigned int cnt = 0; cnt < attrs->getLength(); cnt++) {
			XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *tmpAttr = attrs->item(cnt);

			const XMLCh* attrName = tmpAttr->getNodeName();

			if(XERCES_CPP_NAMESPACE_QUALIFIER XMLString::startsWith(attrName, XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgXMLNSString)) {

                if(XERCES_CPP_NAMESPACE_QUALIFIER XMLString::stringLen(attrName) > 5) {
                    prefix = XPath2Utils::subString(attrName, 6, XERCES_CPP_NAMESPACE_QUALIFIER XMLString::stringLen(attrName)-6, context->getMemoryManager());
                    if(ps.find(prefix) == ps.end()) {
                        ps.insert(prefix);
                        s.addItem(DatatypeFactory::STR2AT::createString(prefix, context));
                    }
                }
                else {
                    if(ps.find(XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString) == ps.end()) {
                        ps.insert(XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString);
                        s.addItem(DatatypeFactory::STR2AT::createString(XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString, context));
                    }
                }
            }
        }
    }
}

Sequence FunctionInScopePrefixes::collapseTreeInternal(DynamicContext* context, int flags) const
{
  Sequence arg1 = getParamNumber(1,context).toSequence(context);
  const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode* node = ((Node*)(const Item*)arg1.first())->getDOMNode();

  Sequence returnSeq(context->getMemoryManager());
  XMLChSet prefixSet;
  while(node->getNodeType() != XERCES_CPP_NAMESPACE_QUALIFIER DOMNode::DOCUMENT_NODE) {
      addBindings(returnSeq, node, prefixSet, context);
      node = node->getParentNode();
  }

  return returnSeq;
}
