/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/functions/FunctionError.hpp>
#include <pathan/exceptions/XPath2ErrorException.hpp>
#include <pathan/Item.hpp>
#include <pathan/dataItem/StaticResolutionContext.hpp>

const XMLCh FunctionError::name[] = {
XERCES_CPP_NAMESPACE_QUALIFIER chLatin_e, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_r, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_r, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_o, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_r, XERCES_CPP_NAMESPACE_QUALIFIER chNull };

/*
 * fn:error() as none
 * fn:error($arg as item()?) as none
 */

FunctionError::FunctionError(const VectorOfDataItems &args, XPath2MemoryManager* memMgr)
  : DataItemFunction(name,0, 1, "item()?", args, memMgr)
{
}

DataItem* FunctionError::staticResolution(StaticContext *context, StaticResolutionContext *src)
{
  src->forceNoFolding(true);
  return resolveDataItems(_args, context, src, false);
}

Sequence FunctionError::collapseTreeInternal(DynamicContext* context, int flags) const
{
  if(getNumArgs()==1)
  {
    Sequence arg=getParamNumber(1,context);
    if(!arg.isEmpty())
      DSLthrow(XPath2ErrorException, X("FunctionError::collapseTreeInternal"), arg.first()->asString(context));
  }
  DSLthrow(XPath2ErrorException, X("FunctionError::collapseTreeInternal"), X("User-requested error"));
}
















