/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/functions/FunctionBaseURI.hpp>
#include <pathan/DynamicContext.hpp>
#include <pathan/Node.hpp>
#include <pathan/ATStringOrDerived.hpp>
#include <pathan/internal/factory/DatatypeFactory.hpp>
#include <xercesc/util/XMLUni.hpp>

const XMLCh FunctionBaseURI::name[] = {
XERCES_CPP_NAMESPACE_QUALIFIER chLatin_b, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_a, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_s, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_e, XERCES_CPP_NAMESPACE_QUALIFIER chDash, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_u, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_r, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_i, XERCES_CPP_NAMESPACE_QUALIFIER chNull };

/**
 * fn:base-uri() as xs:string
 * fn:base-uri($arg as node()?) as xs:string?
**/

FunctionBaseURI::FunctionBaseURI(const VectorOfDataItems &args, XPath2MemoryManager* memMgr)
  : ConstantFoldingFunction(name,0, 1, "node()?", args, memMgr)
{
}

Sequence FunctionBaseURI::collapseTreeInternal(DynamicContext* context, int flags) const
{
  if(getNumArgs() == 0) {
    ATStringOrDerived::Ptr result;

    const XMLCh* uri = context->getBaseURI();
    if(uri) {
      result = DatatypeFactory::STR2AT::createString(uri, context);
    } else {
      result = DatatypeFactory::STR2AT::createString(XERCES_CPP_NAMESPACE_QUALIFIER XMLUni::fgZeroLenString, context);
    }
    return Sequence(result, context->getMemoryManager());
  } else {
    Sequence arg = getParamNumber(1,context);
    if(arg.isEmpty())
      return Sequence(context->getMemoryManager());
    return ((Node*)(const Item*)arg.first())->dmBaseURI(context);
  }
}
