/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/functions/FunctionAvg.hpp>
#include <pathan/functions/FunctionSum.hpp>
#include <pathan/Sequence.hpp>
#include <pathan/dataItem/DataItemSequence.hpp>
#include <pathan/operators/Divide.hpp>
#include <pathan/functions/FunctionConstructor.hpp>
#include <pathan/ATDecimalOrDerived.hpp>
#include <pathan/ATDurationOrDerived.hpp>
#include <pathan/exceptions/XPath2ErrorException.hpp>
#include <pathan/exceptions/IllegalArgumentException.hpp>
#include <pathan/DynamicContext.hpp>
#include <pathan/internal/factory/DatatypeFactory.hpp>
#include <xercesc/validators/schema/SchemaSymbols.hpp>

const XMLCh FunctionAvg::name[] = {
XERCES_CPP_NAMESPACE_QUALIFIER chLatin_a, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_v, XERCES_CPP_NAMESPACE_QUALIFIER chLatin_g, XERCES_CPP_NAMESPACE_QUALIFIER chNull };

/**
 * fn:avg($arg as xdt:anyAtomicType*) as xdt:anyAtomicType?
**/

FunctionAvg::FunctionAvg(const VectorOfDataItems &args, XPath2MemoryManager* memMgr)
  : AggregateFunction(name,1, 1, "anyAtomicType*", args, memMgr)
{
}

Sequence FunctionAvg::collapseTreeInternal(DynamicContext* context, int flags) const
{
  Sequence sequence(context->getMemoryManager());
  try {
    sequence = validateSequence(getParamNumber(1,context), context);
  } catch (IllegalArgumentException &e) {
    DSLthrow(IllegalArgumentException, X("FunctionAvg::collapseTreeInternal()"), X("Invalid argument to fn:avg() function"));
  }
	if(sequence.isEmpty())
		return Sequence(context->getMemoryManager());

  // check for types that don't support addition and division by an integer
  const AnyAtomicType::Ptr atom = (const AnyAtomicType::Ptr )sequence.first();
  if (!atom->isNumericValue() && 
      !context->isTypeOrDerivedFromType(atom->getTypeURI(), atom->getTypeName(), FunctionConstructor::XMLChXPath2DatatypesURI, ATDurationOrDerived::fgDT_DAYTIMEDURATION) &&
      !context->isTypeOrDerivedFromType(atom->getTypeURI(), atom->getTypeName(), FunctionConstructor::XMLChXPath2DatatypesURI, ATDurationOrDerived::fgDT_YEARMONTHDURATION))
    DSLthrow(IllegalArgumentException, X("FunctionAvg::collapseTreeInternal()"), X("Invalid argument to fn:avg() function"));

  FunctionSum fnSum(_args, context->getMemoryManager());
  Result sum = 0;
  try {
    sum = fnSum.collapseTree(context);
  } catch (IllegalArgumentException &e) {
    DSLthrow(IllegalArgumentException, X("FunctionAvg::collapseTreeInternal()"), X("Invalid argument to fn:avg() function"));
  }

  VectorOfDataItems divArgs = VectorOfDataItems(PathanAllocator<DataItem*>(context->getMemoryManager()));
  DataItemSequence seq1(sum, context, context->getMemoryManager());
  divArgs.push_back(&seq1);

  DataItemSequence seq2(DatatypeFactory::POD2AT::createDecimal((long)sequence.getLength(), context),
                        context, context->getMemoryManager());
  divArgs.push_back(&seq2);

  Divide divide(divArgs, context->getMemoryManager());
  Sequence avg(context->getMemoryManager()); 
  try {
    avg = divide.collapseTree(context);
  } catch (XPath2ErrorException &e) {
    DSLthrow(IllegalArgumentException, X("FunctionAvg::collapseTreeInternal()"), X("Invalid argument to fn:avg() function"));
  }
	return avg;
}
