/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _XPATHLEXER_EXCEPTION_HPP
#define _XPATHLEXER_EXCEPTION_HPP

#include <pathan/Pathan.hpp>

#include <pathan/exceptions/DSLException.hpp>
#include <pathan/internal/DOMutils/XStr.hpp>

/** This means that a user has tried to run an XML file that isn't an
    XST document (or is in the wrong namespace). */

class PATHAN_EXPORT XPathLexerException : public DSLException
{
public:
  XPathLexerException(const XMLCh *functionName, const XMLCh *reason, const char *file, int line)
    : DSLException(X("XPathLexerException"), functionName, reason, file, line) {};
};

#endif // _XPATHLEXERCES_CPP_NAMESPACE_QUALIFIER XCEPTION_HPP
