/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

/*

  SequenceException - handles invalid subscripts passed to sequence

*/

#ifndef _SEQUENCEEXCEPTION_HPP
#define _SEQUENCEEXCEPTION_HPP

#include <pathan/Pathan.hpp>

#include <pathan/exceptions/DSLException.hpp>
#include <pathan/internal/DOMutils/XStr.hpp>

/** exception class for invalid-array-subscript errors */
class PATHAN_EXPORT SequenceException : public DSLException
{
public:
  
  SequenceException(const XMLCh *functionName, const XMLCh *reason, const char *file, int line)
    : DSLException(X("SequenceException"), functionName, reason, file, line) {};
};

#endif // _SEQUENCEEXCEPTION_HPP
