/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

/*

  CannotHappenException - handles cases which cannot occur, eg. at the end of an exhaustive switch-case

*/

#ifndef _CANNOTHAPPENEXCEPTION_HPP
#define _CANNOTHAPPENEXCEPTION_HPP

#include <pathan/Pathan.hpp>

#include <pathan/exceptions/DSLException.hpp>

/** exception class for impossible exceptions (to prevent compiler warnings) */

class PATHAN_EXPORT CannotHappenException : public DSLException
{
public:
  
  CannotHappenException(const XMLCh *functionName, const XMLCh *reason, const char *file, int line)
    : DSLException(X("CannotHappenException"), functionName, reason, file, line) {};
};

#endif // _CANNOTHAPPENEXCEPTION_HPP
