/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

//note: check up on this - what sets it, cause it dont any more (used to be in NavStepImpl)?
//static bool myUseWholeText = false;

#include "../config/pathan_config.h"
#include <pathan/dataItem/DataItemStep.hpp>
#include <pathan/internal/navigation/NavStepImpl.hpp>
#include <pathan/Item.hpp>
#include <pathan/ATDecimalOrDerived.hpp>
#include <pathan/internal/factory/DatatypeFactory.hpp>
#include <pathan/dataItem/StaticResolutionContext.hpp>
#include <xercesc/validators/schema/SchemaSymbols.hpp>

DataItemStep::DataItemStep(NavStepImpl* step, XPath2MemoryManager* memMgr)
	: DataItemImpl(memMgr), _step(step) {
  setType(DataItem::STEP);
}

DataItemStep::~DataItemStep()
{
	//no-op
}


DataItem* DataItemStep::staticResolution(StaticContext *context, StaticResolutionContext *src)
{
  src->contextItemUsed(true);
  _step->staticResolution(context);
  return resolvePredicates(context, src);
}

Result DataItemStep::createResult(DynamicContext* context, int flags) const 
{
	return _step->createResult(context);
}

Result DataItemStep::postPredicateResultHook(Result &result, DynamicContext* context, int flags) const
{
  // parent axis doesn't need reordering
  if(!(context->getNodeSetOrdering()==StaticContext::ORDERING_UNORDERED || flags & DataItem::UNORDERED) &&
     _step->getAxisOrientation() == REVERSE && _step->getAxis() != NavStepImpl::PARENT) {
    // Reorder reverse axis results
    return result.sortIntoDocumentOrder(context);
  }
  else {
    return result;
  }
}

// from DataItem
unsigned int DataItemStep::getStaticProperties() const
{
  unsigned int properties = 0;
  // properties depend on the axis of the step
  NavStepImpl::Axis axis = _step->getAxis();
  switch (axis) {
  case NavStepImpl::SELF:
  case NavStepImpl::CHILD:
  case NavStepImpl::ATTRIBUTE:
    properties |= (DataItem::DOCORDER|
                   DataItem::SUBTREE|DataItem::PEER);
    break;
  default:
    properties |= DataItem::DOCORDER;
    break;
  }
  return properties;
}

const NavStepImpl *DataItemStep::getNavStep() const {
  return _step;
}

void DataItemStep::setNavStep(NavStepImpl *nav) {
  _step = nav;
}
