/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#include "../config/pathan_config.h"
#include <pathan/Pathan.hpp>
#include <pathan/dataItem/DataItemContextItem.hpp>
#include <pathan/Sequence.hpp>
#include <pathan/DynamicContext.hpp>
#include <pathan/exceptions/ContextException.hpp>
#include <pathan/dataItem/StaticResolutionContext.hpp>

DataItemContextItem::DataItemContextItem(XPath2MemoryManager* memMgr)
	: DataItemImpl(memMgr)
{
	setType(DataItem::CONTEXT_ITEM);
}

DataItemContextItem::~DataItemContextItem() {
	//no-op
}

DataItem* DataItemContextItem::staticResolution(StaticContext *context, StaticResolutionContext *src)
{
  src->contextItemUsed(true);
  return resolvePredicates(context, src);
}

Sequence DataItemContextItem::collapseTreeInternal(DynamicContext* context, int flags) const
{
  const Item::Ptr item = context->getContextItem();
  if(item == NULLRCP) {
    DSLthrow(ContextException,X("DataItemContextItem::collapseTreeInternal"), X("It is an error for the context item to be undefined when using it [err:XP0002]"));
  }

	return Sequence(item, context->getMemoryManager());
}
