/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _PRECEDINGSIBLINGAXIS_HPP
#define _PRECEDINGSIBLINGAXIS_HPP

#include <pathan/Pathan.hpp>

#include <pathan/internal/navigation/ReverseAxis.hpp>

/**
   This class implements the PrecedingSiblingAxis axis as defined by the XPath spec
*/
class PATHAN_EXPORT PrecedingSiblingAxis : public ReverseAxis
{
public:
  virtual Axis getAxis() const;
protected:
  virtual Result createResult(DynamicContext* context) const;

  class PrecedingSiblingAxisResult : public NavStepImpl::AxisResult
  {
  public:
    PrecedingSiblingAxisResult(const NavStepImpl *step, DynamicContext *context);
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *stepNext(DynamicContext *context);
  private:
    bool toDo_;
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *sibling_;
  };
};


#endif

