/*
 * Copyright (c) 2001, DecisionSoft Limited All rights reserved.
 * Please see LICENSE.TXT for more information.
 */

#ifndef _PRECEDINGAXIS_HPP
#define _PRECEDINGAXIS_HPP

#include <pathan/Pathan.hpp>

#include <pathan/internal/navigation/ReverseAxis.hpp>

/**
This class implements the PrecedingAxis axis as defined by the XPath spec
*/
class PATHAN_EXPORT PrecedingAxis : public ReverseAxis
{
public:
  virtual Axis getAxis() const;
protected:
  virtual Result createResult(DynamicContext* context) const;

  class PrecedingAxisResult : public NavStepImpl::AxisResult
  {
  public:
    PrecedingAxisResult(const NavStepImpl *step, DynamicContext *context);
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *stepNext(DynamicContext *context);
  private:
    bool toDo_;
    const XERCES_CPP_NAMESPACE_QUALIFIER DOMNode *node_;
  };
};


#endif

